/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.asset.plugins;

import com.jme3.asset.AssetInfo;
import com.jme3.asset.AssetKey;
import com.jme3.asset.AssetLocator;
import com.jme3.asset.AssetManager;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UrlLocator
implements AssetLocator {
    private static final Logger logger = Logger.getLogger(UrlLocator.class.getName());
    private URL root;

    public void setRootPath(String rootPath) {
        try {
            this.root = new URL(rootPath);
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException("Invalid rootUrl specified", ex);
        }
    }

    public AssetInfo locate(AssetManager manager, AssetKey key) {
        String name = key.getName();
        try {
            InputStream in;
            URL url = new URL(this.root, name);
            URLConnection conn = url.openConnection();
            conn.setUseCaches(false);
            conn.setDoOutput(false);
            try {
                in = conn.getInputStream();
                if (in == null) {
                    return null;
                }
            }
            catch (FileNotFoundException ex) {
                return null;
            }
            return new UrlAssetInfo(manager, key, in);
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, "Error while locating " + name, ex);
            return null;
        }
    }

    private static class UrlAssetInfo
    extends AssetInfo {
        private InputStream in;

        public UrlAssetInfo(AssetManager manager, AssetKey key, InputStream in) {
            super(manager, key);
            this.in = in;
        }

        public InputStream openStream() {
            return this.in;
        }
    }
}

