/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.collision;

import com.jme3.collision.CollisionResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollisionResults
implements Iterable<CollisionResult> {
    private final ArrayList<CollisionResult> results = new ArrayList();
    private boolean sorted = true;

    public void clear() {
        this.results.clear();
    }

    @Override
    public Iterator<CollisionResult> iterator() {
        if (!this.sorted) {
            Collections.sort(this.results);
            this.sorted = true;
        }
        return this.results.iterator();
    }

    public void addCollision(CollisionResult result) {
        this.results.add(result);
        this.sorted = false;
    }

    public int size() {
        return this.results.size();
    }

    public CollisionResult getClosestCollision() {
        if (this.size() == 0) {
            return null;
        }
        if (!this.sorted) {
            Collections.sort(this.results);
            this.sorted = true;
        }
        return this.results.get(0);
    }

    public CollisionResult getFarthestCollision() {
        if (this.size() == 0) {
            return null;
        }
        if (!this.sorted) {
            Collections.sort(this.results);
            this.sorted = true;
        }
        return this.results.get(this.size() - 1);
    }

    public CollisionResult getCollision(int index) {
        if (!this.sorted) {
            Collections.sort(this.results);
            this.sorted = true;
        }
        return this.results.get(index);
    }

    public CollisionResult getCollisionDirect(int index) {
        return this.results.get(index);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CollisionResults[");
        for (CollisionResult result : this.results) {
            sb.append(result).append(", ");
        }
        if (this.results.size() > 0) {
            sb.setLength(sb.length() - 2);
        }
        sb.append("]");
        return sb.toString();
    }
}

