/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.materials;

import com.jme3.scene.plugins.blender.DataRepository;
import com.jme3.scene.plugins.blender.exceptions.BlenderFileException;
import com.jme3.scene.plugins.blender.file.DynamicArray;
import com.jme3.scene.plugins.blender.file.Pointer;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.texture.Texture;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class MaterialContext {
    private static final Logger LOGGER = Logger.getLogger(MaterialContext.class.getName());
    final String name;
    final List<Structure> mTexs;
    final List<Structure> textures;
    final int texturesCount;
    final Texture.Type textureType;
    final boolean shadeless;
    final boolean vertexColor;
    final boolean transparent;
    final boolean vtangent;
    int uvCoordinatesType = -1;
    int projectionType;

    MaterialContext(Structure structure, DataRepository dataRepository) throws BlenderFileException {
        this.name = structure.getName();
        int mode = ((Number)structure.getFieldValue("mode")).intValue();
        this.shadeless = (mode & 4) != 0;
        this.vertexColor = (mode & 0x80) != 0;
        this.transparent = (mode & 0x10000) != 0;
        this.vtangent = (mode & 0x4000000) != 0;
        this.mTexs = new ArrayList<Structure>();
        this.textures = new ArrayList<Structure>();
        DynamicArray mtexsArray = (DynamicArray)structure.getFieldValue("mtex");
        int separatedTextures = ((Number)structure.getFieldValue("septex")).intValue();
        Texture.Type firstTextureType = null;
        for (int i = 0; i < mtexsArray.getTotalSize(); ++i) {
            Structure tex;
            int type;
            Texture.Type textureType;
            Pointer p = (Pointer)mtexsArray.get(i);
            if (!p.isNotNull() || (separatedTextures & 1 << i) != 0) continue;
            Structure mtex = p.fetchData(dataRepository.getInputStream()).get(0);
            if (this.uvCoordinatesType == -1) {
                this.uvCoordinatesType = ((Number)mtex.getFieldValue("texco")).intValue();
                this.projectionType = ((Number)mtex.getFieldValue("mapping")).intValue();
            } else if (this.uvCoordinatesType != ((Number)mtex.getFieldValue("texco")).intValue()) {
                LOGGER.log(Level.WARNING, "The texture with index: {0} has different UV coordinates type than the first texture! This texture will NOT be loaded!", i + 1);
                continue;
            }
            Pointer pTex = (Pointer)mtex.getFieldValue("tex");
            if (!pTex.isNotNull() || (textureType = this.getType(type = ((Number)(tex = pTex.fetchData(dataRepository.getInputStream()).get(0)).getFieldValue("type")).intValue())) == null) continue;
            if (firstTextureType == null) {
                firstTextureType = textureType;
                this.mTexs.add(mtex);
                this.textures.add(tex);
                continue;
            }
            if (firstTextureType == textureType) {
                this.mTexs.add(mtex);
                this.textures.add(tex);
                continue;
            }
            LOGGER.log(Level.WARNING, "The texture with index: {0} is of different dimension than the first one! This texture will NOT be loaded!", i + 1);
        }
        this.texturesCount = this.mTexs.size();
        this.textureType = firstTextureType;
    }

    public int getUvCoordinatesType() {
        return this.uvCoordinatesType;
    }

    public int getProjectionType() {
        return this.projectionType;
    }

    public int getTextureDimension() {
        return this.textureType == Texture.Type.TwoDimensional ? 2 : 3;
    }

    public int getTexturesCount() {
        return this.textures == null ? 0 : this.textures.size();
    }

    private Texture.Type getType(int texType) {
        switch (texType) {
            case 8: {
                return Texture.Type.TwoDimensional;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: {
                return Texture.Type.ThreeDimensional;
            }
            case 0: {
                return null;
            }
            case 9: 
            case 10: 
            case 14: 
            case 15: {
                LOGGER.log(Level.WARNING, "Texture type NOT supported: {0}", texType);
                return null;
            }
        }
        throw new IllegalStateException("Unknown texture type: " + texType);
    }
}

