/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.ogre;

import com.jme3.animation.Animation;
import com.jme3.animation.Bone;
import com.jme3.animation.BoneAnimation;
import com.jme3.animation.BoneTrack;
import com.jme3.animation.Skeleton;
import com.jme3.asset.AssetInfo;
import com.jme3.asset.AssetLoader;
import com.jme3.asset.AssetManager;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.plugins.ogre.AnimData;
import com.jme3.scene.plugins.ogre.SceneLoader;
import com.jme3.util.xml.SAXUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class SkeletonLoader
extends DefaultHandler
implements AssetLoader {
    private static final Logger logger = Logger.getLogger(SceneLoader.class.getName());
    private AssetManager assetManager;
    private Stack<String> elementStack = new Stack();
    private HashMap<Integer, Bone> indexToBone = new HashMap();
    private HashMap<String, Bone> nameToBone = new HashMap();
    private BoneTrack track;
    private ArrayList<BoneTrack> tracks = new ArrayList();
    private BoneAnimation animation;
    private ArrayList<Animation> animations;
    private Bone bone;
    private Skeleton skeleton;
    private ArrayList<Float> times = new ArrayList();
    private ArrayList<Vector3f> translations = new ArrayList();
    private ArrayList<Quaternion> rotations = new ArrayList();
    private ArrayList<Vector3f> scales = new ArrayList();
    private float time = -1.0f;
    private Vector3f position;
    private Quaternion rotation;
    private Vector3f scale;
    private float angle;
    private Vector3f axis;

    public void startElement(String uri, String localName, String qName, Attributes attribs) throws SAXException {
        if (qName.equals("position") || qName.equals("translate")) {
            this.position = SAXUtil.parseVector3(attribs);
        } else if (qName.equals("rotation") || qName.equals("rotate")) {
            this.angle = SAXUtil.parseFloat(attribs.getValue("angle"));
        } else if (qName.equals("axis")) {
            assert (this.elementStack.peek().equals("rotation") || this.elementStack.peek().equals("rotate"));
            this.axis = SAXUtil.parseVector3(attribs);
        } else if (qName.equals("scale")) {
            this.scale = SAXUtil.parseVector3(attribs);
        } else if (qName.equals("keyframe")) {
            assert (this.elementStack.peek().equals("keyframes"));
            this.time = SAXUtil.parseFloat(attribs.getValue("time"));
        } else if (qName.equals("keyframes")) {
            assert (this.elementStack.peek().equals("track"));
        } else if (qName.equals("track")) {
            assert (this.elementStack.peek().equals("tracks"));
            String boneName = SAXUtil.parseString(attribs.getValue("bone"));
            Bone bone = this.nameToBone.get(boneName);
            int index = this.skeleton.getBoneIndex(bone);
            this.track = new BoneTrack(index);
        } else if (qName.equals("boneparent")) {
            assert (this.elementStack.peek().equals("bonehierarchy"));
            String boneName = attribs.getValue("bone");
            String parentName = attribs.getValue("parent");
            Bone bone = this.nameToBone.get(boneName);
            Bone parent = this.nameToBone.get(parentName);
            parent.addChild(bone);
        } else if (qName.equals("bone")) {
            assert (this.elementStack.peek().equals("bones"));
            this.bone = new Bone(attribs.getValue("name"));
            int id = SAXUtil.parseInt(attribs.getValue("id"));
            this.indexToBone.put(id, this.bone);
            this.nameToBone.put(this.bone.getName(), this.bone);
        } else if (qName.equals("tracks")) {
            assert (this.elementStack.peek().equals("animation"));
            this.tracks.clear();
        } else if (qName.equals("animation")) {
            assert (this.elementStack.peek().equals("animations"));
            String name = SAXUtil.parseString(attribs.getValue("name"));
            float length = SAXUtil.parseFloat(attribs.getValue("length"));
            this.animation = new BoneAnimation(name, length);
        } else if (qName.equals("bonehierarchy")) {
            assert (this.elementStack.peek().equals("skeleton"));
        } else if (qName.equals("animations")) {
            assert (this.elementStack.peek().equals("skeleton"));
            this.animations = new ArrayList();
        } else if (qName.equals("bones") ? !$assertionsDisabled && !this.elementStack.peek().equals("skeleton") : qName.equals("skeleton") && !$assertionsDisabled && this.elementStack.size() != 0) {
            throw new AssertionError();
        }
        this.elementStack.add(qName);
    }

    public void endElement(String uri, String name, String qName) {
        if (!(qName.equals("translate") || qName.equals("position") || qName.equals("scale") || qName.equals("axis"))) {
            if (qName.equals("rotate") || qName.equals("rotation")) {
                this.rotation = new Quaternion();
                this.axis.normalizeLocal();
                this.rotation.fromAngleNormalAxis(this.angle, this.axis);
                this.angle = 0.0f;
                this.axis = null;
            } else if (qName.equals("bone")) {
                this.bone.setBindTransforms(this.position, this.rotation, this.scale);
                this.bone = null;
                this.position = null;
                this.rotation = null;
                this.scale = null;
            } else if (qName.equals("bonehierarchy")) {
                Bone[] bones = new Bone[this.indexToBone.size()];
                for (Map.Entry<Integer, Bone> entry : this.indexToBone.entrySet()) {
                    Bone bone;
                    bones[entry.getKey().intValue()] = bone = entry.getValue();
                }
                this.indexToBone.clear();
                this.skeleton = new Skeleton(bones);
            } else if (qName.equals("animation")) {
                this.animations.add(this.animation);
                this.animation = null;
            } else if (qName.equals("track")) {
                if (this.track != null) {
                    this.tracks.add(this.track);
                    this.track = null;
                }
            } else if (qName.equals("tracks")) {
                BoneTrack[] trackList = this.tracks.toArray(new BoneTrack[this.tracks.size()]);
                this.animation.setTracks(trackList);
                this.tracks.clear();
            } else if (qName.equals("keyframe")) {
                assert (this.time >= 0.0f);
                assert (this.position != null);
                assert (this.rotation != null);
                this.times.add(Float.valueOf(this.time));
                this.translations.add(this.position);
                this.rotations.add(this.rotation);
                if (this.scale != null) {
                    this.scales.add(this.scale);
                } else {
                    this.scales.add(new Vector3f(1.0f, 1.0f, 1.0f));
                }
                this.time = -1.0f;
                this.position = null;
                this.rotation = null;
                this.scale = null;
            } else if (qName.equals("keyframes")) {
                if (this.times.size() > 0) {
                    float[] timesArray = new float[this.times.size()];
                    for (int i = 0; i < timesArray.length; ++i) {
                        timesArray[i] = this.times.get(i).floatValue();
                    }
                    Vector3f[] transArray = this.translations.toArray(new Vector3f[this.translations.size()]);
                    Quaternion[] rotArray = this.rotations.toArray(new Quaternion[this.rotations.size()]);
                    Vector3f[] scalesArray = this.scales.toArray(new Vector3f[this.scales.size()]);
                    this.track.setKeyframes(timesArray, transArray, rotArray, scalesArray);
                } else {
                    this.track = null;
                }
                this.times.clear();
                this.translations.clear();
                this.rotations.clear();
                this.scales.clear();
            } else if (qName.equals("skeleton")) {
                this.nameToBone.clear();
            }
        }
        assert (this.elementStack.peek().equals(qName));
        this.elementStack.pop();
    }

    private void fullReset() {
        this.elementStack.clear();
        this.indexToBone.clear();
        this.nameToBone.clear();
        this.track = null;
        this.tracks.clear();
        this.animation = null;
        if (this.animations != null) {
            this.animations.clear();
        }
        this.bone = null;
        this.skeleton = null;
        this.times.clear();
        this.rotations.clear();
        this.translations.clear();
        this.time = -1.0f;
        this.position = null;
        this.rotation = null;
        this.scale = null;
        this.angle = 0.0f;
        this.axis = null;
    }

    public Object load(InputStream in) throws IOException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            XMLReader xr = factory.newSAXParser().getXMLReader();
            xr.setContentHandler(this);
            xr.setErrorHandler(this);
            InputStreamReader r = new InputStreamReader(in);
            xr.parse(new InputSource(r));
            if (this.animations == null) {
                this.animations = new ArrayList();
            }
            AnimData data = new AnimData(this.skeleton, this.animations);
            this.skeleton = null;
            this.animations = null;
            return data;
        }
        catch (SAXException ex) {
            IOException ioEx = new IOException("Error while parsing Ogre3D dotScene");
            ioEx.initCause(ex);
            this.fullReset();
            throw ioEx;
        }
        catch (ParserConfigurationException ex) {
            IOException ioEx = new IOException("Error while parsing Ogre3D dotScene");
            ioEx.initCause(ex);
            this.fullReset();
            throw ioEx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object load(AssetInfo info) throws IOException {
        this.assetManager = info.getManager();
        InputStream in = null;
        try {
            in = info.openStream();
            Object object = this.load(in);
            return object;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }
}

