/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.util.GLArrayDataEditable;
import com.jogamp.opengl.util.GLArrayDataWrapper;
import com.jogamp.opengl.util.GLArrayHandler;
import com.jogamp.opengl.util.GLFixedArrayHandler;
import com.jogamp.opengl.util.glsl.GLSLArrayHandler;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.media.opengl.GL;
import javax.media.opengl.GLException;
import jogamp.opengl.SystemUtil;

public class GLArrayDataClient
extends GLArrayDataWrapper
implements GLArrayDataEditable {
    public static final boolean hasVBOBug = AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return SystemUtil.getenv("JOGL_VBO_BUG");
        }
    }) != null;
    protected boolean sealed;
    protected boolean sealedGL;
    protected boolean bufferEnabled;
    protected boolean bufferWritten;
    protected boolean enableBufferAlways;
    protected int initialSize;
    protected GLArrayHandler glArrayHandler;

    public static GLArrayDataClient createFixed(GL gL, int n, String string, int n2, int n3, boolean bl, int n4) throws GLException {
        gL.getGLProfile().isValidArrayDataType(n, n2, n3, false, true);
        GLArrayDataClient gLArrayDataClient = new GLArrayDataClient();
        GLFixedArrayHandler gLFixedArrayHandler = new GLFixedArrayHandler(gLArrayDataClient);
        gLArrayDataClient.init(string, n, n2, n3, bl, 0, null, n4, false, gLFixedArrayHandler, 0, 0L);
        return gLArrayDataClient;
    }

    public static GLArrayDataClient createFixed(GL gL, int n, String string, int n2, int n3, boolean bl, int n4, Buffer buffer) throws GLException {
        gL.getGLProfile().isValidArrayDataType(n, n2, n3, false, true);
        GLArrayDataClient gLArrayDataClient = new GLArrayDataClient();
        GLFixedArrayHandler gLFixedArrayHandler = new GLFixedArrayHandler(gLArrayDataClient);
        gLArrayDataClient.init(string, n, n2, n3, bl, n4, buffer, n2 * n2, false, gLFixedArrayHandler, 0, 0L);
        return gLArrayDataClient;
    }

    public static GLArrayDataClient createGLSL(GL gL, String string, int n, int n2, boolean bl, int n3) throws GLException {
        if (!gL.hasGLSL()) {
            throw new GLException("GLArrayDataClient.GLSL not supported: " + gL);
        }
        gL.getGLProfile().isValidArrayDataType(-1, n, n2, true, true);
        GLArrayDataClient gLArrayDataClient = new GLArrayDataClient();
        GLSLArrayHandler gLSLArrayHandler = new GLSLArrayHandler(gLArrayDataClient);
        gLArrayDataClient.init(string, -1, n, n2, bl, 0, null, n3, true, gLSLArrayHandler, 0, 0L);
        return gLArrayDataClient;
    }

    public static GLArrayDataClient createGLSL(GL gL, String string, int n, int n2, boolean bl, int n3, Buffer buffer) throws GLException {
        if (!gL.hasGLSL()) {
            throw new GLException("GLArrayDataClient.GLSL not supported: " + gL);
        }
        gL.getGLProfile().isValidArrayDataType(-1, n, n2, true, true);
        GLArrayDataClient gLArrayDataClient = new GLArrayDataClient();
        GLSLArrayHandler gLSLArrayHandler = new GLSLArrayHandler(gLArrayDataClient);
        gLArrayDataClient.init(string, -1, n, n2, bl, n3, buffer, n * n, true, gLSLArrayHandler, 0, 0L);
        return gLArrayDataClient;
    }

    @Override
    public final boolean isBufferWritten() {
        return this.bufferWritten;
    }

    @Override
    public final boolean sealed() {
        return this.sealed;
    }

    @Override
    public int getBufferUsage() {
        return -1;
    }

    @Override
    public final void setBufferWritten(boolean bl) {
        this.bufferWritten = bl;
    }

    @Override
    public void destroy(GL gL) {
        this.reset(gL);
        this.buffer = null;
    }

    @Override
    public void reset(GL gL) {
        this.enableBuffer(gL, false);
        this.reset();
    }

    @Override
    public void seal(GL gL, boolean bl) {
        this.seal(bl);
        if (this.sealedGL == bl) {
            return;
        }
        this.sealedGL = bl;
        if (bl) {
            this.init_vbo(gL);
            this.enableBuffer(gL, true);
        } else {
            this.enableBuffer(gL, false);
        }
    }

    @Override
    public void enableBuffer(GL gL, boolean bl) {
        if (this.enableBufferAlways && bl) {
            this.bufferEnabled = false;
        }
        if (this.bufferEnabled != bl && this.components > 0) {
            if (bl) {
                this.checkSeal(true);
                if (null != this.buffer) {
                    this.buffer.rewind();
                }
            }
            this.glArrayHandler.enableBuffer(gL, bl);
            this.bufferEnabled = bl;
        }
    }

    @Override
    public void setEnableAlways(boolean bl) {
        this.enableBufferAlways = bl;
    }

    @Override
    public void reset() {
        if (this.buffer != null) {
            this.buffer.clear();
        }
        this.sealed = false;
        this.bufferEnabled = false;
        this.bufferWritten = false;
    }

    @Override
    public void seal(boolean bl) {
        if (this.sealed == bl) {
            return;
        }
        this.sealed = bl;
        if (bl) {
            this.bufferWritten = false;
            if (null != this.buffer) {
                this.buffer.flip();
            }
        } else if (null != this.buffer) {
            this.buffer.position(this.buffer.limit());
            this.buffer.limit(this.buffer.capacity());
        }
    }

    @Override
    public void rewind() {
        if (this.buffer != null) {
            this.buffer.rewind();
        }
    }

    @Override
    public void padding(int n) {
        if (this.buffer == null || this.sealed) {
            return;
        }
        while (n < this.strideL) {
            Buffers.putb((Buffer)this.buffer, (byte)0);
            ++n;
        }
    }

    @Override
    public void put(Buffer buffer) {
        if (this.buffer == null || this.sealed) {
            return;
        }
        if (0 != buffer.remaining() % this.strideL) {
            throw new GLException("Buffer length (" + buffer.remaining() + ") is not a multiple of component-stride:\n\t" + this);
        }
        this.growBufferIfNecessary(buffer.remaining());
        Buffers.put((Buffer)this.buffer, (Buffer)buffer);
    }

    @Override
    public void putb(byte by) {
        if (this.buffer == null || this.sealed) {
            return;
        }
        this.growBufferIfNecessary(1);
        Buffers.putb((Buffer)this.buffer, (byte)by);
    }

    @Override
    public void puts(short s) {
        if (this.buffer == null || this.sealed) {
            return;
        }
        this.growBufferIfNecessary(1);
        Buffers.puts((Buffer)this.buffer, (short)s);
    }

    @Override
    public void puti(int n) {
        if (this.buffer == null || this.sealed) {
            return;
        }
        this.growBufferIfNecessary(1);
        Buffers.puti((Buffer)this.buffer, (int)n);
    }

    @Override
    public void putx(int n) {
        this.puti(n);
    }

    @Override
    public void putf(float f) {
        if (this.buffer == null || this.sealed) {
            return;
        }
        this.growBufferIfNecessary(1);
        Buffers.putf((Buffer)this.buffer, (float)f);
    }

    @Override
    public String toString() {
        return "GLArrayDataClient[" + this.name + ", index " + this.index + ", location " + this.location + ", isVertexAttribute " + this.isVertexAttribute + ", dataType " + this.dataType + ", bufferClazz " + this.clazz + ", elements " + this.getElementNumber() + ", components " + this.components + ", stride " + this.stride + "u " + this.strideB + "b " + this.strideL + "c" + ", initialSize " + this.initialSize + ", sealed " + this.sealed + ", bufferEnabled " + this.bufferEnabled + ", bufferWritten " + this.bufferWritten + ", buffer " + this.buffer + "]";
    }

    protected final boolean growBufferIfNecessary(int n) {
        if (this.buffer == null || this.buffer.remaining() < n) {
            this.growBuffer(this.initialSize);
            return true;
        }
        return false;
    }

    protected final void growBuffer(int n) {
        if (this.sealed || 0 == n || 0 == this.components) {
            return;
        }
        n += n / this.components * (this.strideL - this.components);
        if (this.components > 0) {
            int n2;
            int n3 = n2 = this.buffer != null ? this.buffer.capacity() : 0;
            if (this.clazz == ByteBuffer.class) {
                ByteBuffer byteBuffer = Buffers.newDirectByteBuffer((int)((n2 + n) * this.components));
                if (this.buffer != null) {
                    this.buffer.flip();
                    byteBuffer.put((ByteBuffer)this.buffer);
                }
                this.buffer = byteBuffer;
            } else if (this.clazz == ShortBuffer.class) {
                ShortBuffer shortBuffer = Buffers.newDirectShortBuffer((int)((n2 + n) * this.components));
                if (this.buffer != null) {
                    this.buffer.flip();
                    shortBuffer.put((ShortBuffer)this.buffer);
                }
                this.buffer = shortBuffer;
            } else if (this.clazz == IntBuffer.class) {
                IntBuffer intBuffer = Buffers.newDirectIntBuffer((int)((n2 + n) * this.components));
                if (this.buffer != null) {
                    this.buffer.flip();
                    intBuffer.put((IntBuffer)this.buffer);
                }
                this.buffer = intBuffer;
            } else if (this.clazz == FloatBuffer.class) {
                FloatBuffer floatBuffer = Buffers.newDirectFloatBuffer((int)((n2 + n) * this.components));
                if (this.buffer != null) {
                    this.buffer.flip();
                    floatBuffer.put((FloatBuffer)this.buffer);
                }
                this.buffer = floatBuffer;
            } else {
                throw new GLException("Given Buffer Class not supported: " + this.clazz + ":\n\t" + this);
            }
        }
    }

    protected final void checkSeal(boolean bl) throws GLException {
        if (this.sealed != bl) {
            if (bl) {
                throw new GLException("Not Sealed yet, seal first:\n\t" + this);
            }
            throw new GLException("Already Sealed, can't modify VBO:\n\t" + this);
        }
    }

    protected void init(String string, int n, int n2, int n3, boolean bl, int n4, Buffer buffer, int n5, boolean bl2, GLArrayHandler gLArrayHandler, int n6, long l) throws GLException {
        super.init(string, n, n2, n3, bl, n4, buffer, bl2, n6, l);
        this.initialSize = n5;
        this.glArrayHandler = gLArrayHandler;
        this.sealed = false;
        this.sealedGL = false;
        this.bufferEnabled = false;
        this.enableBufferAlways = false;
        this.bufferWritten = false;
        if (null == this.buffer) {
            this.growBuffer(n5);
        }
    }

    protected void init_vbo(GL gL) {
    }

    protected GLArrayDataClient() {
    }
}

