/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl;

import com.jogamp.common.util.IntLongHashMap;
import javax.media.opengl.GL;
import javax.media.opengl.GLException;
import jogamp.opengl.Debug;
import jogamp.opengl.GLBufferStateTracker;

public class GLBufferSizeTracker {
    private IntLongHashMap bufferSizeMap = new IntLongHashMap();
    protected static final boolean DEBUG = Debug.debug("GLStatusTracker");

    public GLBufferSizeTracker() {
        this.bufferSizeMap.setKeyNotFoundValue(-1L);
    }

    public void setBufferSize(GLBufferStateTracker gLBufferStateTracker, int n, GL gL, long l) {
        int n2 = gLBufferStateTracker.getBoundBufferObject(n, gL);
        boolean bl = gLBufferStateTracker.isBoundBufferObjectKnown(n);
        if (bl) {
            if (n2 == 0) {
                throw new GLException("Error: no OpenGL buffer object appears to be bound to target 0x" + Integer.toHexString(n));
            }
            this.setDirectStateBufferSize(n2, gL, l);
        }
    }

    public void setDirectStateBufferSize(int n, GL gL, long l) {
        this.bufferSizeMap.put(n, l);
    }

    public long getBufferSize(GLBufferStateTracker gLBufferStateTracker, int n, GL gL) {
        int n2 = gLBufferStateTracker.getBoundBufferObject(n, gL);
        boolean bl = gLBufferStateTracker.isBoundBufferObjectKnown(n);
        if (bl) {
            if (0 == n2) {
                throw new GLException("Error: no OpenGL buffer object appears to be bound to target 0x" + Integer.toHexString(n));
            }
            return this.getBufferSizeImpl(n, n2, gL);
        }
        int[] nArray = new int[1];
        gL.glGetBufferParameteriv(n, 34660, nArray, 0);
        if (DEBUG) {
            System.err.println("GLBufferSizeTracker.getBufferSize(): no cached buffer information");
        }
        return nArray[0];
    }

    public long getDirectStateBufferSize(int n, GL gL) {
        return this.getBufferSizeImpl(0, n, gL);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private long getBufferSizeImpl(int n, int n2, GL gL) {
        long l = this.bufferSizeMap.get(n2);
        if (0L <= l) return l;
        int[] nArray = new int[1];
        if (0 == n) {
            if (!gL.isFunctionAvailable("glGetNamedBufferParameterivEXT")) throw new GLException("Error: getDirectStateBufferSize called with unknown state and GL function 'glGetNamedBufferParameterivEXT' n/a to query size");
            gL.getGL2().glGetNamedBufferParameterivEXT(n2, 34660, nArray, 0);
        } else {
            gL.glGetBufferParameteriv(n, 34660, nArray, 0);
        }
        if (nArray[0] == 0) {
            throw new GLException("Error: buffer size returned by " + (0 == n ? "glGetNamedBufferParameterivEXT" : "glGetBufferParameteriv") + " was zero; probably application error");
        }
        l = nArray[0];
        this.bufferSizeMap.put(n2, l);
        if (!DEBUG) return l;
        System.err.println("GLBufferSizeTracker.getBufferSize(): made slow query to cache size " + l + " for buffer " + n2);
        return l;
    }

    public void clearCachedBufferSizes() {
        this.bufferSizeMap.clear();
    }
}

