/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl;

import com.jogamp.common.JogampRuntimeException;
import com.jogamp.common.util.ReflectionUtil;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.media.nativewindow.NativeWindowFactory;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;
import jogamp.opengl.Debug;
import jogamp.opengl.GLWorkerThread;
import jogamp.opengl.ThreadingPlugin;

public class ThreadingImpl {
    public static final int AWT = 1;
    public static final int WORKER = 2;
    protected static final boolean DEBUG = Debug.debug("Threading");
    private static boolean singleThreaded = true;
    private static int mode;
    private static boolean hasAWT;
    private static boolean _isX11;
    private static final ThreadingPlugin threadingPlugin;

    private ThreadingImpl() {
    }

    public static boolean isX11() {
        return _isX11;
    }

    public static int getMode() {
        return mode;
    }

    public static void disableSingleThreading() {
        singleThreaded = false;
        if (Debug.verbose()) {
            System.err.println("Application forced disabling of single-threading of javax.media.opengl implementation");
        }
    }

    public static boolean isSingleThreaded() {
        return singleThreaded;
    }

    public static boolean isOpenGLThread() throws GLException {
        if (!ThreadingImpl.isSingleThreaded()) {
            throw new GLException("Should only call this in single-threaded mode");
        }
        if (null != threadingPlugin) {
            return threadingPlugin.isOpenGLThread();
        }
        switch (mode) {
            case 1: {
                throw new InternalError();
            }
            case 2: {
                return GLWorkerThread.isWorkerThread();
            }
        }
        throw new InternalError("Illegal single-threading mode " + mode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void invokeOnOpenGLThread(Runnable runnable) throws GLException {
        if (!ThreadingImpl.isSingleThreaded()) {
            throw new GLException("Should only call this in single-threaded mode");
        }
        if (ThreadingImpl.isOpenGLThread()) {
            throw new GLException("Should only call this from other threads than the OpenGL thread");
        }
        if (null != threadingPlugin) {
            threadingPlugin.invokeOnOpenGLThread(runnable);
            return;
        }
        switch (mode) {
            case 1: {
                throw new InternalError();
            }
            case 2: {
                if (!GLWorkerThread.isStarted()) {
                    Class<GLWorkerThread> clazz = GLWorkerThread.class;
                    // MONITORENTER : jogamp.opengl.GLWorkerThread.class
                    if (!GLWorkerThread.isStarted()) {
                        GLWorkerThread.start();
                    }
                    // MONITOREXIT : clazz
                }
                try {
                    GLWorkerThread.invokeAndWait(runnable);
                    return;
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new GLException(invocationTargetException.getTargetException());
                }
                catch (InterruptedException interruptedException) {
                    throw new GLException(interruptedException);
                }
            }
        }
        throw new InternalError("Illegal single-threading mode " + mode);
    }

    public static boolean isAWTMode() {
        return mode == 1;
    }

    private static void printWorkaroundNotice() {
        if (singleThreaded && Debug.verbose()) {
            System.err.println("Using " + (mode == 1 ? "AWT" : "OpenGL worker") + " thread for performing OpenGL work in javax.media.opengl implementation");
        }
    }

    static {
        Object t = AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string = Debug.getProperty("jogl.1thread", true);
                ClassLoader classLoader = ThreadingImpl.class.getClassLoader();
                hasAWT = GLProfile.isAWTAvailable();
                String string2 = NativeWindowFactory.getNativeWindowType((boolean)false);
                _isX11 = "X11".equals(string2);
                int n = hasAWT ? 1 : 2;
                mode = n;
                if (string != null && !(string = string.toLowerCase()).equals("true") && !string.equals("auto")) {
                    if (string.equals("worker")) {
                        singleThreaded = true;
                        mode = 2;
                    } else if (hasAWT && string.equals("awt")) {
                        singleThreaded = true;
                        mode = 1;
                    } else {
                        singleThreaded = false;
                    }
                }
                ThreadingImpl.printWorkaroundNotice();
                Object object = null;
                if (hasAWT) {
                    JogampRuntimeException jogampRuntimeException = null;
                    try {
                        object = ReflectionUtil.createInstance((String)"jogamp.opengl.awt.AWTThreadingPlugin", (ClassLoader)classLoader);
                    }
                    catch (JogampRuntimeException jogampRuntimeException2) {
                        jogampRuntimeException = jogampRuntimeException2;
                    }
                    if (1 == mode && null == object) {
                        throw new GLException("Mode is AWT, but class 'jogamp.opengl.awt.AWTThreadingPlugin' is not available", jogampRuntimeException);
                    }
                }
                return object;
            }
        });
        threadingPlugin = (ThreadingPlugin)t;
        if (DEBUG) {
            System.err.println("Threading: hasAWT " + hasAWT + ", mode " + (mode == 1 ? "AWT" : "WORKER") + ", plugin " + threadingPlugin);
        }
    }
}

