/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.awt;

import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import javax.media.opengl.GLException;
import jogamp.opengl.GLWorkerThread;
import jogamp.opengl.ThreadingImpl;
import jogamp.opengl.ThreadingPlugin;
import jogamp.opengl.awt.Java2D;

public class AWTThreadingPlugin
implements ThreadingPlugin {
    @Override
    public boolean isOpenGLThread() throws GLException {
        switch (ThreadingImpl.getMode()) {
            case 1: {
                if (Java2D.isOGLPipelineActive() && !ThreadingImpl.isX11()) {
                    return Java2D.isQueueFlusherThread();
                }
                return EventQueue.isDispatchThread();
            }
            case 2: {
                if (Java2D.isOGLPipelineActive()) {
                    return Java2D.isQueueFlusherThread() || ThreadingImpl.isX11() && GLWorkerThread.isWorkerThread();
                }
                return GLWorkerThread.isWorkerThread();
            }
        }
        throw new InternalError("Illegal single-threading mode " + ThreadingImpl.getMode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void invokeOnOpenGLThread(Runnable runnable) throws GLException {
        switch (ThreadingImpl.getMode()) {
            case 1: {
                if (Java2D.isOGLPipelineActive() && !ThreadingImpl.isX11()) {
                    Java2D.invokeWithOGLContextCurrent(null, runnable);
                    return;
                }
                try {
                    EventQueue.invokeAndWait(runnable);
                    return;
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new GLException(invocationTargetException.getTargetException());
                }
                catch (InterruptedException interruptedException) {
                    throw new GLException(interruptedException);
                }
            }
            case 2: {
                if (!GLWorkerThread.isStarted()) {
                    Class<GLWorkerThread> clazz = GLWorkerThread.class;
                    // MONITORENTER : jogamp.opengl.GLWorkerThread.class
                    if (!GLWorkerThread.isStarted()) {
                        GLWorkerThread.start();
                    }
                    // MONITOREXIT : clazz
                }
                try {
                    GLWorkerThread.invokeAndWait(runnable);
                    return;
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new GLException(invocationTargetException.getTargetException());
                }
                catch (InterruptedException interruptedException) {
                    throw new GLException(interruptedException);
                }
            }
        }
        throw new InternalError("Illegal single-threading mode " + ThreadingImpl.getMode());
    }
}

