/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.elements;

import de.lessvoid.nifty.EndNotify;
import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.NiftyEvent;
import de.lessvoid.nifty.NiftyMethodInvoker;
import de.lessvoid.nifty.controls.Controller;
import de.lessvoid.nifty.controls.FocusHandler;
import de.lessvoid.nifty.controls.NiftyControl;
import de.lessvoid.nifty.controls.NiftyInputControl;
import de.lessvoid.nifty.effects.Effect;
import de.lessvoid.nifty.effects.EffectEventId;
import de.lessvoid.nifty.effects.EffectImpl;
import de.lessvoid.nifty.effects.EffectManager;
import de.lessvoid.nifty.effects.Falloff;
import de.lessvoid.nifty.elements.ElementInteraction;
import de.lessvoid.nifty.elements.events.ElementDisableEvent;
import de.lessvoid.nifty.elements.events.ElementEnableEvent;
import de.lessvoid.nifty.elements.events.ElementHideEvent;
import de.lessvoid.nifty.elements.events.ElementShowEvent;
import de.lessvoid.nifty.elements.render.ElementRenderer;
import de.lessvoid.nifty.elements.render.ImageRenderer;
import de.lessvoid.nifty.elements.render.PanelRenderer;
import de.lessvoid.nifty.elements.render.TextRenderer;
import de.lessvoid.nifty.input.NiftyMouseInputEvent;
import de.lessvoid.nifty.input.keyboard.KeyboardInputEvent;
import de.lessvoid.nifty.layout.LayoutPart;
import de.lessvoid.nifty.layout.align.HorizontalAlign;
import de.lessvoid.nifty.layout.align.VerticalAlign;
import de.lessvoid.nifty.layout.manager.LayoutManager;
import de.lessvoid.nifty.loaderv2.types.ElementType;
import de.lessvoid.nifty.loaderv2.types.apply.ApplyRenderText;
import de.lessvoid.nifty.loaderv2.types.apply.ApplyRenderer;
import de.lessvoid.nifty.loaderv2.types.apply.ApplyRendererImage;
import de.lessvoid.nifty.loaderv2.types.apply.ApplyRendererPanel;
import de.lessvoid.nifty.loaderv2.types.apply.Convert;
import de.lessvoid.nifty.loaderv2.types.helper.PaddingAttributeParser;
import de.lessvoid.nifty.render.NiftyRenderEngine;
import de.lessvoid.nifty.screen.KeyInputHandler;
import de.lessvoid.nifty.screen.MouseOverHandler;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.tools.NullObjectFactory;
import de.lessvoid.nifty.tools.SizeValue;
import de.lessvoid.nifty.tools.TimeProvider;
import de.lessvoid.xml.xpp3.Attributes;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class Element
implements NiftyEvent<Void> {
    private static Logger log = Logger.getLogger(Element.class.getName());
    private ElementType elementType;
    private String id;
    private Element parent;
    private ArrayList<Element> elements = new ArrayList();
    private LayoutManager layoutManager;
    private LayoutPart layoutPart;
    private ElementRenderer[] elementRenderer = new ElementRenderer[0];
    private EffectManager effectManager;
    private ElementInteraction interaction;
    private Nifty nifty;
    private FocusHandler focusHandler;
    private boolean enabled;
    private int enabledCount;
    private boolean visible;
    private boolean done;
    private boolean interactionBlocked;
    private boolean visibleToMouseEvents;
    private boolean clipChildren;
    private NiftyInputControl attachedInputControl = null;
    private boolean isCalcWidthConstraint;
    private boolean isCalcHeightConstraint;
    private boolean focusable = false;
    private String focusableInsertBeforeElementId;
    private Screen screen;
    private TimeProvider time;
    private List<String> elementDebugOut = new ArrayList<String>();
    private StringBuffer elementDebug = new StringBuffer();
    private boolean parentClipArea = false;
    private int parentClipX;
    private int parentClipY;
    private int parentClipWidth;
    private int parentClipHeight;
    private static Convert convert = new Convert();
    private static Map<Class<? extends ElementRenderer>, ApplyRenderer> rendererApplier = new Hashtable<Class<? extends ElementRenderer>, ApplyRenderer>();

    public Element(Nifty newNifty, ElementType newElementType, String newId, Element newParent, FocusHandler newFocusHandler, boolean newVisibleToMouseEvents, TimeProvider newTimeProvider, ElementRenderer ... newElementRenderer) {
        rendererApplier.put(TextRenderer.class, new ApplyRenderText(convert));
        rendererApplier.put(ImageRenderer.class, new ApplyRendererImage(convert));
        rendererApplier.put(PanelRenderer.class, new ApplyRendererPanel(convert));
        this.initialize(newNifty, newElementType, newId, newParent, newElementRenderer, new LayoutPart(), newFocusHandler, newVisibleToMouseEvents, newTimeProvider);
    }

    public Element(Nifty newNifty, ElementType newElementType, String newId, Element newParent, LayoutPart newLayoutPart, FocusHandler newFocusHandler, boolean newVisibleToMouseEvents, TimeProvider newTimeProvider, ElementRenderer ... newElementRenderer) {
        rendererApplier.put(TextRenderer.class, new ApplyRenderText(convert));
        rendererApplier.put(ImageRenderer.class, new ApplyRendererImage(convert));
        rendererApplier.put(PanelRenderer.class, new ApplyRendererPanel(convert));
        this.initialize(newNifty, newElementType, newId, newParent, newElementRenderer, newLayoutPart, newFocusHandler, newVisibleToMouseEvents, newTimeProvider);
    }

    public void initializeFromAttributes(Attributes attributes, NiftyRenderEngine renderEngine) {
        this.layoutPart.getBoxConstraints().setHeight(convert.sizeValue(attributes.get("height")));
        this.layoutPart.getBoxConstraints().setWidth(convert.sizeValue(attributes.get("width")));
        this.layoutPart.getBoxConstraints().setX(convert.sizeValue(attributes.get("x")));
        this.layoutPart.getBoxConstraints().setY(convert.sizeValue(attributes.get("y")));
        this.layoutPart.getBoxConstraints().setHorizontalAlign(convert.horizontalAlign(attributes.get("align")));
        this.layoutPart.getBoxConstraints().setVerticalAlign(convert.verticalAlign(attributes.get("valign")));
        String paddingLeft = "0px";
        String paddingRight = "0px";
        String paddingTop = "0px";
        String paddingBottom = "0px";
        if (attributes.isSet("padding")) {
            try {
                PaddingAttributeParser paddingParser = new PaddingAttributeParser(attributes.get("padding"));
                paddingLeft = paddingParser.getLeft();
                paddingRight = paddingParser.getRight();
                paddingTop = paddingParser.getTop();
                paddingBottom = paddingParser.getBottom();
            }
            catch (Exception e) {
                log.warning(e.getMessage());
            }
        }
        this.layoutPart.getBoxConstraints().setPaddingLeft(convert.paddingSizeValue(attributes.get("paddingLeft"), paddingLeft));
        this.layoutPart.getBoxConstraints().setPaddingRight(convert.paddingSizeValue(attributes.get("paddingRight"), paddingRight));
        this.layoutPart.getBoxConstraints().setPaddingTop(convert.paddingSizeValue(attributes.get("paddingTop"), paddingTop));
        this.layoutPart.getBoxConstraints().setPaddingBottom(convert.paddingSizeValue(attributes.get("paddingBottom"), paddingBottom));
        this.clipChildren = attributes.getAsBoolean("childClip", false);
        boolean visible = attributes.getAsBoolean("visible", true);
        if (visible) {
            this.visible = true;
        }
        this.visibleToMouseEvents = attributes.getAsBoolean("visibleToMouse", false);
        this.layoutManager = convert.layoutManager(attributes.get("childLayout"));
        this.focusable = attributes.getAsBoolean("focusable", false);
        this.focusableInsertBeforeElementId = attributes.get("focusableInsertBeforeElementId");
        for (int i = 0; i < this.elementRenderer.length; ++i) {
            ElementRenderer renderer = this.elementRenderer[i];
            ApplyRenderer rendererApply = rendererApplier.get(renderer.getClass());
            rendererApply.apply(this, attributes, renderEngine);
        }
    }

    public void initializeFromPostAttributes(Attributes attributes) {
        boolean visible = attributes.getAsBoolean("visible", true);
        if (!visible) {
            this.hideWithChildren();
        }
    }

    private void hideWithChildren() {
        this.visible = false;
        for (int i = 0; i < this.elements.size(); ++i) {
            Element element = this.elements.get(i);
            element.hideWithChildren();
        }
    }

    private void initialize(Nifty newNifty, ElementType newElementType, String newId, Element newParent, ElementRenderer[] newElementRenderer, LayoutPart newLayoutPart, FocusHandler newFocusHandler, boolean newVisibleToMouseEvents, TimeProvider timeProvider) {
        this.nifty = newNifty;
        this.elementType = newElementType;
        this.id = newId;
        this.parent = newParent;
        this.elementRenderer = newElementRenderer == null ? new ElementRenderer[0] : newElementRenderer;
        this.effectManager = new EffectManager();
        this.effectManager.setAlternateKey(this.nifty.getAlternateKey());
        this.layoutPart = newLayoutPart;
        this.enabled = true;
        this.enabledCount = 0;
        this.visible = true;
        this.done = false;
        this.interactionBlocked = false;
        this.focusHandler = newFocusHandler;
        this.visibleToMouseEvents = newVisibleToMouseEvents;
        this.time = timeProvider;
        this.interaction = new ElementInteraction(this.nifty, this);
    }

    public String getId() {
        return this.id;
    }

    public Element getParent() {
        return this.parent;
    }

    public void setParent(Element element) {
        this.parent = element;
    }

    public String getElementStateString(String offset) {
        return this.getElementStateString(offset, ".*");
    }

    public String getElementStateString(String offset, String regex) {
        this.elementDebugOut.clear();
        this.elementDebugOut.add(" type: [" + this.elementType.output(offset.length()) + "]");
        this.elementDebugOut.add(" style [" + this.getElementType().getAttributes().get("style") + "]");
        this.elementDebugOut.add(" state [" + this.getState() + "]");
        this.elementDebugOut.add(" position [x=" + this.getX() + ", y=" + this.getY() + ", w=" + this.getWidth() + ", h=" + this.getHeight() + "]");
        this.elementDebugOut.add(" constraint [" + this.outputSizeValue(this.layoutPart.getBoxConstraints().getX()) + ", " + this.outputSizeValue(this.layoutPart.getBoxConstraints().getY()) + ", " + this.outputSizeValue(this.layoutPart.getBoxConstraints().getWidth()) + ", " + this.outputSizeValue(this.layoutPart.getBoxConstraints().getHeight()) + "]");
        this.elementDebugOut.add(" padding [" + this.outputSizeValue(this.layoutPart.getBoxConstraints().getPaddingLeft()) + ", " + this.outputSizeValue(this.layoutPart.getBoxConstraints().getPaddingRight()) + ", " + this.outputSizeValue(this.layoutPart.getBoxConstraints().getPaddingTop()) + ", " + this.outputSizeValue(this.layoutPart.getBoxConstraints().getPaddingBottom()) + "]");
        StringBuffer state = new StringBuffer();
        if (this.focusable) {
            state.append(" focusable");
        }
        if (this.enabled) {
            if (state.length() > 0) {
                state.append(",");
            }
            state.append(" enabled(" + this.enabledCount + ")");
        }
        if (this.visible) {
            if (state.length() > 0) {
                state.append(",");
            }
            state.append(" visible");
        }
        if (this.visibleToMouseEvents) {
            if (state.length() > 0) {
                state.append(",");
            }
            state.append(" mouseable");
        }
        if (this.clipChildren) {
            if (state.length() > 0) {
                state.append(",");
            }
            state.append(" clipChildren");
        }
        this.elementDebugOut.add(" flags [" + state + "]");
        this.elementDebugOut.add(" effects [" + this.effectManager.getStateString(offset) + "]");
        if (this.parentClipArea) {
            this.elementDebugOut.add(" parent clip [x=" + this.parentClipX + ", y=" + this.parentClipY + ", w=" + this.parentClipWidth + ", h=" + this.parentClipHeight + "]");
        }
        this.elementDebug.delete(0, this.elementDebug.length());
        for (int i = 0; i < this.elementDebugOut.size(); ++i) {
            String line = this.elementDebugOut.get(i);
            if (!line.matches(regex)) continue;
            if (this.elementDebug.length() > 0) {
                this.elementDebug.append("\n" + offset);
            }
            this.elementDebug.append(line);
        }
        return this.elementDebug.toString();
    }

    private String getState() {
        if (this.isEffectActive(EffectEventId.onStartScreen)) {
            return "starting";
        }
        if (this.isEffectActive(EffectEventId.onEndScreen)) {
            return "ending";
        }
        if (!this.visible) {
            return "hidden";
        }
        if (this.interactionBlocked) {
            return "interactionBlocked";
        }
        if (!this.enabled) {
            return "disabled";
        }
        return "normal";
    }

    private String outputSizeValue(SizeValue value) {
        if (value == null) {
            return "null";
        }
        return value.toString();
    }

    public int getX() {
        return this.layoutPart.getBox().getX();
    }

    public int getY() {
        return this.layoutPart.getBox().getY();
    }

    public int getHeight() {
        return this.layoutPart.getBox().getHeight();
    }

    public int getWidth() {
        return this.layoutPart.getBox().getWidth();
    }

    public void setHeight(int height) {
        this.layoutPart.getBox().setHeight(height);
    }

    public void setWidth(int width) {
        this.layoutPart.getBox().setWidth(width);
    }

    public List<Element> getElements() {
        return this.elements;
    }

    public void add(Element widget) {
        this.elements.add(widget);
    }

    public void render(NiftyRenderEngine r) {
        if (this.visible) {
            if (this.effectManager.isEmpty()) {
                r.saveState(null);
                this.renderElement(r);
                this.renderChildren(r);
                r.restoreState();
            } else {
                r.saveState(null);
                this.effectManager.begin(r, this);
                this.effectManager.renderPre(r, this);
                this.renderElement(r);
                this.effectManager.renderPost(r, this);
                this.effectManager.end(r);
                this.renderChildren(r);
                r.restoreState();
                r.saveState(null);
                this.effectManager.renderOverlay(r, this);
                r.restoreState();
            }
        }
    }

    private void renderElement(NiftyRenderEngine r) {
        for (int i = 0; i < this.elementRenderer.length; ++i) {
            ElementRenderer renderer = this.elementRenderer[i];
            renderer.render(this, r);
        }
    }

    private void renderChildren(NiftyRenderEngine r) {
        if (this.clipChildren) {
            r.enableClip(this.getX(), this.getY(), this.getX() + this.getWidth(), this.getY() + this.getHeight());
            this.renderInternalChildElements(r);
            r.disableClip();
        } else {
            this.renderInternalChildElements(r);
        }
    }

    private void renderInternalChildElements(NiftyRenderEngine r) {
        for (int i = 0; i < this.elements.size(); ++i) {
            Element p = this.elements.get(i);
            p.render(r);
        }
    }

    public void setLayoutManager(LayoutManager newLayout) {
        this.layoutManager = newLayout;
    }

    public void resetLayout() {
        this.isCalcWidthConstraint = false;
        this.isCalcHeightConstraint = false;
        for (int i = 0; i < this.elements.size(); ++i) {
            Element e = this.elements.get(i);
            e.resetLayout();
        }
    }

    private void preProcessConstraintWidth() {
        for (int i = 0; i < this.elements.size(); ++i) {
            Element e = this.elements.get(i);
            e.preProcessConstraintWidth();
        }
        this.preProcessConstraintWidthThisLevel();
    }

    private void preProcessConstraintWidthThisLevel() {
        SizeValue myWidth = this.getConstraintWidth();
        if (this.layoutManager != null && (myWidth == null || this.isCalcWidthConstraint)) {
            SizeValue newWidth;
            ArrayList<LayoutPart> layoutPartChild = new ArrayList<LayoutPart>();
            for (int i = 0; i < this.elements.size(); ++i) {
                Element e = this.elements.get(i);
                SizeValue childWidth = e.getConstraintWidth();
                if (childWidth == null || !childWidth.isPixel()) continue;
                layoutPartChild.add(e.layoutPart);
            }
            if (this.elements.size() == layoutPartChild.size() && (newWidth = this.layoutManager.calculateConstraintWidth(this.layoutPart, layoutPartChild)) != null) {
                this.setConstraintWidth(newWidth);
                this.isCalcWidthConstraint = true;
            }
        }
    }

    private void preProcessConstraintHeight() {
        for (int i = 0; i < this.elements.size(); ++i) {
            Element e = this.elements.get(i);
            e.preProcessConstraintHeight();
        }
        this.preProcessConstraintHeightThisLevel();
    }

    private void preProcessConstraintHeightThisLevel() {
        SizeValue myHeight = this.getConstraintHeight();
        if (this.layoutManager != null && (myHeight == null || this.isCalcHeightConstraint)) {
            SizeValue newHeight;
            ArrayList<LayoutPart> layoutPartChild = new ArrayList<LayoutPart>();
            for (int i = 0; i < this.elements.size(); ++i) {
                Element e = this.elements.get(i);
                SizeValue childHeight = e.getConstraintHeight();
                if (childHeight == null || !childHeight.isPixel()) continue;
                layoutPartChild.add(e.layoutPart);
            }
            if (this.elements.size() == layoutPartChild.size() && (newHeight = this.layoutManager.calculateConstraintHeight(this.layoutPart, layoutPartChild)) != null) {
                this.setConstraintHeight(newHeight);
                this.isCalcHeightConstraint = true;
            }
        }
    }

    private void processLayoutInternal() {
        for (int i = 0; i < this.elements.size(); ++i) {
            Element w = this.elements.get(i);
            TextRenderer textRenderer = w.getRenderer(TextRenderer.class);
            if (textRenderer == null) continue;
            textRenderer.setWidthConstraint(w, w.getConstraintWidth(), this.getWidth(), this.nifty.getRenderEngine());
        }
    }

    private void processLayout() {
        this.processLayoutInternal();
        if (this.layoutManager != null) {
            NiftyControl niftyControl;
            Element w;
            int i;
            ArrayList<LayoutPart> layoutPartChild = new ArrayList<LayoutPart>();
            for (i = 0; i < this.elements.size(); ++i) {
                w = this.elements.get(i);
                layoutPartChild.add(w.layoutPart);
            }
            this.layoutManager.layoutElements(this.layoutPart, layoutPartChild);
            if (this.attachedInputControl != null && (niftyControl = this.attachedInputControl.getNiftyControl(NiftyControl.class)) != null && niftyControl.isBound()) {
                niftyControl.layoutCallback();
            }
            for (i = 0; i < this.elements.size(); ++i) {
                w = this.elements.get(i);
                w.processLayout();
            }
        }
        if (this.clipChildren) {
            for (int i = 0; i < this.elements.size(); ++i) {
                Element w = this.elements.get(i);
                w.setParentClipArea(this.getX(), this.getY(), this.getWidth(), this.getHeight());
            }
        }
    }

    public void layoutElements() {
        this.prepareLayout();
        this.processLayout();
        this.prepareLayout();
        this.processLayout();
    }

    private void prepareLayout() {
        this.preProcessConstraintWidth();
        this.preProcessConstraintHeight();
    }

    private void setParentClipArea(int x, int y, int width, int height) {
        this.parentClipArea = true;
        this.parentClipX = x;
        this.parentClipY = y;
        this.parentClipWidth = width;
        this.parentClipHeight = height;
        for (int i = 0; i < this.elements.size(); ++i) {
            Element w = this.elements.get(i);
            w.setParentClipArea(this.parentClipX, this.parentClipY, this.parentClipWidth, this.parentClipHeight);
        }
        this.notifyListeners();
    }

    public void resetEffects() {
        this.effectManager.reset();
        for (int i = 0; i < this.elements.size(); ++i) {
            Element w = this.elements.get(i);
            w.resetEffects();
        }
    }

    public void resetAllEffects() {
        this.effectManager.resetAll();
        for (int i = 0; i < this.elements.size(); ++i) {
            Element w = this.elements.get(i);
            w.resetAllEffects();
        }
    }

    public void resetForHide() {
        this.effectManager.resetForHide();
        for (int i = 0; i < this.elements.size(); ++i) {
            Element w = this.elements.get(i);
            w.resetForHide();
        }
    }

    public void resetSingleEffect(EffectEventId effectEventId) {
        this.effectManager.resetSingleEffect(effectEventId);
        for (int i = 0; i < this.elements.size(); ++i) {
            Element w = this.elements.get(i);
            w.resetSingleEffect(effectEventId);
        }
    }

    public void resetSingleEffect(EffectEventId effectEventId, String customKey) {
        this.effectManager.resetSingleEffect(effectEventId, customKey);
        for (int i = 0; i < this.elements.size(); ++i) {
            Element w = this.elements.get(i);
            w.resetSingleEffect(effectEventId, customKey);
        }
    }

    public void resetMouseDown() {
        this.interaction.resetMouseDown();
        for (int i = 0; i < this.elements.size(); ++i) {
            Element w = this.elements.get(i);
            w.resetMouseDown();
        }
    }

    public void setConstraintX(SizeValue newX) {
        this.layoutPart.getBoxConstraints().setX(newX);
        this.notifyListeners();
    }

    public void setConstraintY(SizeValue newY) {
        this.layoutPart.getBoxConstraints().setY(newY);
        this.notifyListeners();
    }

    public void setConstraintWidth(SizeValue newWidth) {
        this.layoutPart.getBoxConstraints().setWidth(newWidth);
        this.notifyListeners();
    }

    public void setConstraintHeight(SizeValue newHeight) {
        this.layoutPart.getBoxConstraints().setHeight(newHeight);
        this.notifyListeners();
    }

    public SizeValue getConstraintX() {
        return this.layoutPart.getBoxConstraints().getX();
    }

    public SizeValue getConstraintY() {
        return this.layoutPart.getBoxConstraints().getY();
    }

    public SizeValue getConstraintWidth() {
        return this.layoutPart.getBoxConstraints().getWidth();
    }

    public SizeValue getConstraintHeight() {
        return this.layoutPart.getBoxConstraints().getHeight();
    }

    public void setConstraintHorizontalAlign(HorizontalAlign newHorizontalAlign) {
        this.layoutPart.getBoxConstraints().setHorizontalAlign(newHorizontalAlign);
    }

    public void setConstraintVerticalAlign(VerticalAlign newVerticalAlign) {
        this.layoutPart.getBoxConstraints().setVerticalAlign(newVerticalAlign);
    }

    public HorizontalAlign getConstraintHorizontalAlign() {
        return this.layoutPart.getBoxConstraints().getHorizontalAlign();
    }

    public VerticalAlign getConstraintVerticalAlign() {
        return this.layoutPart.getBoxConstraints().getVerticalAlign();
    }

    public void registerEffect(EffectEventId theId, Effect e) {
        log.fine("[" + this.getId() + "] register: " + theId.toString() + "(" + e.getStateString() + ")");
        this.effectManager.registerEffect(theId, e);
    }

    public void startEffect(EffectEventId effectEventId) {
        this.startEffect(effectEventId, null);
    }

    public void startEffect(EffectEventId effectEventId, EndNotify effectEndNotiy) {
        this.startEffect(effectEventId, effectEndNotiy, null);
    }

    public void startEffect(EffectEventId effectEventId, EndNotify effectEndNotiy, String customKey) {
        this.startEffectDoIt(effectEventId, effectEndNotiy, customKey, true);
    }

    public void startEffectWithoutChildren(EffectEventId effectEventId) {
        this.startEffectWithoutChildren(effectEventId, null);
    }

    public void startEffectWithoutChildren(EffectEventId effectEventId, EndNotify effectEndNotiy) {
        this.startEffectWithoutChildren(effectEventId, effectEndNotiy, null);
    }

    public void startEffectWithoutChildren(EffectEventId effectEventId, EndNotify effectEndNotiy, String customKey) {
        this.startEffectDoIt(effectEventId, effectEndNotiy, customKey, false);
    }

    private void startEffectDoIt(EffectEventId effectEventId, EndNotify effectEndNotiy, String customKey, boolean withChildren) {
        if (effectEventId == EffectEventId.onStartScreen) {
            if (!this.visible) {
                return;
            }
            this.done = false;
            this.interactionBlocked = true;
        }
        if (effectEventId == EffectEventId.onEndScreen) {
            if (!this.visible) {
                effectEndNotiy.perform();
                return;
            }
            this.done = true;
            this.interactionBlocked = true;
        }
        LocalEndNotify forwardToSelf = new LocalEndNotify(effectEventId, effectEndNotiy);
        this.effectManager.startEffect(effectEventId, this, this.time, forwardToSelf, customKey);
        if (withChildren) {
            for (int i = 0; i < this.elements.size(); ++i) {
                Element w = this.elements.get(i);
                w.startEffectInternal(effectEventId, forwardToSelf, customKey);
            }
        }
        if (effectEventId == EffectEventId.onFocus && this.attachedInputControl != null) {
            this.attachedInputControl.onFocus(true);
        }
        forwardToSelf.perform();
    }

    private void startEffectInternal(EffectEventId effectEventId, EndNotify effectEndNotiy, String customKey) {
        if (effectEventId == EffectEventId.onStartScreen) {
            if (!this.visible) {
                return;
            }
            this.done = false;
            this.interactionBlocked = true;
        }
        if (effectEventId == EffectEventId.onEndScreen) {
            if (!this.visible) {
                return;
            }
            this.done = true;
            this.interactionBlocked = true;
        }
        LocalEndNotify forwardToSelf = new LocalEndNotify(effectEventId, effectEndNotiy);
        this.effectManager.startEffect(effectEventId, this, this.time, forwardToSelf, customKey);
        for (int i = 0; i < this.elements.size(); ++i) {
            Element w = this.elements.get(i);
            w.startEffectInternal(effectEventId, forwardToSelf, customKey);
        }
        if (effectEventId == EffectEventId.onFocus && this.attachedInputControl != null) {
            this.attachedInputControl.onFocus(true);
        }
    }

    public void stopEffect(EffectEventId effectEventId) {
        this.stopEffectInternal(effectEventId, true);
    }

    public void stopEffectWithoutChildren(EffectEventId effectEventId) {
        this.stopEffectInternal(effectEventId, false);
    }

    private void stopEffectInternal(EffectEventId effectEventId, boolean withChildren) {
        if (EffectEventId.onStartScreen == effectEventId || EffectEventId.onEndScreen == effectEventId) {
            this.interactionBlocked = false;
            if (!this.visible) {
                return;
            }
        }
        this.effectManager.stopEffect(effectEventId);
        if (withChildren) {
            for (int i = 0; i < this.elements.size(); ++i) {
                Element w = this.elements.get(i);
                w.stopEffect(effectEventId);
            }
        }
        if (effectEventId == EffectEventId.onFocus && this.attachedInputControl != null) {
            this.attachedInputControl.onFocus(false);
        }
    }

    public boolean isEffectActive(EffectEventId effectEventId) {
        for (int i = 0; i < this.elements.size(); ++i) {
            Element w = this.elements.get(i);
            if (!w.isEffectActive(effectEventId)) continue;
            return true;
        }
        return this.effectManager.isActive(effectEventId);
    }

    public void enable() {
        if (this.enabled) {
            return;
        }
        this.enableInternal();
    }

    public void enableInternal() {
        ++this.enabledCount;
        if (this.enabledCount == 0) {
            this.enabled = true;
            this.enableEffect();
            for (int i = 0; i < this.elements.size(); ++i) {
                this.elements.get(i).enableInternal();
            }
        } else {
            for (int i = 0; i < this.elements.size(); ++i) {
                this.elements.get(i).enableInternal();
            }
        }
    }

    void enableEffect() {
        this.stopEffectWithoutChildren(EffectEventId.onDisabled);
        this.startEffectWithoutChildren(EffectEventId.onEnabled);
        this.nifty.publishEvent(this.getId(), new ElementEnableEvent(this));
    }

    public void disable() {
        if (!this.enabled) {
            return;
        }
        this.disableInternal();
    }

    private void disableInternal() {
        --this.enabledCount;
        if (this.enabledCount == -1) {
            this.enabled = false;
            this.disableFocus();
            this.disableEffect();
            for (int i = 0; i < this.elements.size(); ++i) {
                this.elements.get(i).disableInternal();
            }
        } else {
            for (int i = 0; i < this.elements.size(); ++i) {
                this.elements.get(i).disableInternal();
            }
        }
    }

    public void disableFocus() {
        if (this.focusHandler.getKeyboardFocusElement() == this) {
            Element prevElement = this.focusHandler.getNext(this);
            prevElement.setFocus();
        }
        this.focusHandler.lostKeyboardFocus(this);
        this.focusHandler.lostMouseFocus(this);
    }

    void disableEffect() {
        this.stopEffectWithoutChildren(EffectEventId.onHover);
        this.stopEffectWithoutChildren(EffectEventId.onStartHover);
        this.stopEffectWithoutChildren(EffectEventId.onEndHover);
        this.stopEffectWithoutChildren(EffectEventId.onEnabled);
        this.startEffectWithoutChildren(EffectEventId.onDisabled);
        this.nifty.publishEvent(this.getId(), new ElementDisableEvent(this));
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void show() {
        if (this.isEffectActive(EffectEventId.onShow)) {
            return;
        }
        if (this.isEffectActive(EffectEventId.onHide)) {
            this.resetSingleEffect(EffectEventId.onHide);
        }
        this.internalShow();
        this.startEffect(EffectEventId.onShow);
    }

    private void internalShow() {
        this.visible = true;
        this.effectManager.restoreForShow();
        for (int i = 0; i < this.elements.size(); ++i) {
            Element element = this.elements.get(i);
            element.internalShow();
        }
        this.nifty.publishEvent(this.getId(), new ElementShowEvent(this));
    }

    public void setVisible(boolean visibleParam) {
        if (visibleParam) {
            this.show();
        } else {
            this.hide();
        }
    }

    public void hide() {
        this.hide(null);
    }

    public void hide(final EndNotify perform) {
        if (!this.isVisible()) {
            return;
        }
        if (this.isEffectActive(EffectEventId.onHide)) {
            return;
        }
        if (this.isEffectActive(EffectEventId.onShow)) {
            this.resetSingleEffect(EffectEventId.onShow);
        }
        this.startEffect(EffectEventId.onHide, new EndNotify(){

            @Override
            public void perform() {
                Element.this.resetForHide();
                Element.this.internalHide();
                if (perform != null) {
                    perform.perform();
                }
            }
        });
    }

    public void showWithoutEffects() {
        this.internalShow();
    }

    public void hideWithoutEffect() {
        if (!this.isVisible()) {
            return;
        }
        this.resetEffects();
        this.internalHide();
    }

    public void internalHide() {
        this.visible = false;
        this.disableFocus();
        for (int i = 0; i < this.elements.size(); ++i) {
            Element element = this.elements.get(i);
            element.internalHide();
        }
        this.nifty.publishEvent(this.getId(), new ElementHideEvent(this));
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setHotSpotFalloff(Falloff newFalloff) {
        this.effectManager.setFalloff(newFalloff);
    }

    public Falloff getFalloff() {
        return this.effectManager.getFalloff();
    }

    boolean canHandleMouseEvents() {
        if (this.isEffectActive(EffectEventId.onStartScreen)) {
            return false;
        }
        if (this.isEffectActive(EffectEventId.onEndScreen)) {
            return false;
        }
        if (!this.visible) {
            return false;
        }
        if (this.done) {
            return false;
        }
        if (!this.visibleToMouseEvents) {
            return false;
        }
        if (!this.focusHandler.canProcessMouseEvents(this)) {
            return false;
        }
        if (this.interactionBlocked) {
            return false;
        }
        return this.enabled;
    }

    public void buildMouseOverElements(NiftyMouseInputEvent mouseEvent, long eventTime, MouseOverHandler mouseOverHandler) {
        if (this.canHandleMouseEvents()) {
            if (this.isInside(mouseEvent)) {
                mouseOverHandler.addMouseOverElement(this);
            } else {
                mouseOverHandler.addMouseElement(this);
            }
        }
        for (int i = 0; i < this.elements.size(); ++i) {
            Element w = this.elements.get(i);
            w.buildMouseOverElements(mouseEvent, eventTime, mouseOverHandler);
        }
    }

    public void mouseEventHoverPreprocess(NiftyMouseInputEvent mouseEvent, long eventTime) {
        this.effectManager.handleHoverDeactivate(this, mouseEvent.getMouseX(), mouseEvent.getMouseY());
    }

    public boolean mouseEvent(NiftyMouseInputEvent mouseEvent, long eventTime) {
        this.mouseEventHover(mouseEvent);
        return this.interaction.process(mouseEvent, eventTime, this.isInside(mouseEvent), this.canHandleInteraction(), this.focusHandler.hasExclusiveMouseFocus(this));
    }

    private void mouseEventHover(NiftyMouseInputEvent mouseEvent) {
        this.effectManager.handleHover(this, mouseEvent.getMouseX(), mouseEvent.getMouseY());
        this.effectManager.handleHoverStartAndEnd(this, mouseEvent.getMouseX(), mouseEvent.getMouseY());
    }

    public boolean mouseOverEvent(NiftyMouseInputEvent mouseEvent, long eventTime) {
        boolean eatMouseEvent = false;
        if (this.interaction.onMouseOver(this, mouseEvent)) {
            eatMouseEvent = true;
        }
        if (this.interaction.onMouseWheel(this, mouseEvent)) {
            eatMouseEvent = true;
        }
        return eatMouseEvent;
    }

    private boolean isInside(NiftyMouseInputEvent inputEvent) {
        return this.isMouseInsideElement(inputEvent.getMouseX(), inputEvent.getMouseY());
    }

    public boolean isMouseInsideElement(int mouseX, int mouseY) {
        if (this.parentClipArea) {
            if (this.isInsideParentClipArea(mouseX, mouseY)) {
                return mouseX >= this.getX() && mouseX <= this.getX() + this.getWidth() && mouseY > this.getY() && mouseY < this.getY() + this.getHeight();
            }
            return false;
        }
        return mouseX >= this.getX() && mouseX <= this.getX() + this.getWidth() && mouseY > this.getY() && mouseY < this.getY() + this.getHeight();
    }

    private boolean isInsideParentClipArea(int mouseX, int mouseY) {
        return mouseX >= this.parentClipX && mouseX <= this.parentClipX + this.parentClipWidth && mouseY > this.parentClipY && mouseY < this.parentClipY + this.parentClipHeight;
    }

    public void onClick() {
        if (this.canHandleInteraction()) {
            this.interaction.activate(this.nifty);
        }
    }

    private boolean canHandleInteraction() {
        return this.enabled && !this.screen.isEffectActive(EffectEventId.onStartScreen) && !this.screen.isEffectActive(EffectEventId.onEndScreen);
    }

    public Element findElementByName(String name) {
        if (name == null) {
            return null;
        }
        if (this.id != null && this.id.equals(name)) {
            return this;
        }
        if (this.childIdMatch(name, this.id)) {
            return this;
        }
        for (int i = 0; i < this.elements.size(); ++i) {
            Element e = this.elements.get(i);
            Element found = e.findElementByName(name);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    private boolean childIdMatch(String name, String id) {
        return name.startsWith("#") && id != null && id.endsWith(name);
    }

    public void setOnClickAlternateKey(String newAlternateKey) {
        this.interaction.setAlternateKey(newAlternateKey);
    }

    public void setAlternateKey(String alternateKey) {
        this.effectManager.setAlternateKey(alternateKey);
        for (int i = 0; i < this.elements.size(); ++i) {
            Element e = this.elements.get(i);
            e.setAlternateKey(alternateKey);
        }
    }

    public EffectManager getEffectManager() {
        return this.effectManager;
    }

    public void setEffectManager(EffectManager effectManagerParam) {
        this.effectManager = effectManagerParam;
    }

    private void bindToScreen(Screen newScreen) {
        this.screen = newScreen;
        this.screen.registerElementId(this.id);
    }

    private void bindToFocusHandler() {
        if (this.focusable) {
            this.focusHandler.addElement(this, this.screen.findElementByName(this.focusableInsertBeforeElementId));
        }
    }

    public void onStartScreen() {
        this.onStartScreenSubscribeControllerAnnotations();
        this.onStartScreenInternal();
    }

    private void onStartScreenSubscribeControllerAnnotations() {
        for (int i = 0; i < this.elements.size(); ++i) {
            Element e = this.elements.get(i);
            e.onStartScreenSubscribeControllerAnnotations();
        }
        if (this.attachedInputControl != null) {
            this.nifty.subscribeAnnotations(this.attachedInputControl.getController());
        }
    }

    private void onStartScreenInternal() {
        for (int i = 0; i < this.elements.size(); ++i) {
            Element e = this.elements.get(i);
            e.onStartScreenInternal();
        }
        if (this.attachedInputControl != null) {
            this.attachedInputControl.onStartScreen(this.nifty, this.screen);
        }
    }

    public <T extends ElementRenderer> T getRenderer(Class<T> requestedRendererClass) {
        for (int i = 0; i < this.elementRenderer.length; ++i) {
            ElementRenderer renderer = this.elementRenderer[i];
            if (!requestedRendererClass.isInstance(renderer)) continue;
            return (T)((ElementRenderer)requestedRendererClass.cast(renderer));
        }
        return null;
    }

    public void setVisibleToMouseEvents(boolean newVisibleToMouseEvents) {
        this.visibleToMouseEvents = newVisibleToMouseEvents;
    }

    public boolean keyEvent(KeyboardInputEvent inputEvent) {
        if (this.attachedInputControl != null) {
            return this.attachedInputControl.keyEvent(this.nifty, inputEvent, this.id);
        }
        return false;
    }

    public void setClipChildren(boolean clipChildrenParam) {
        this.clipChildren = clipChildrenParam;
    }

    public boolean isClipChildren() {
        return this.clipChildren;
    }

    public void setFocus() {
        if (this.nifty != null && this.nifty.getCurrentScreen() != null && this.isFocusable()) {
            this.focusHandler.setKeyFocus(this);
        }
    }

    public void attachInputControl(NiftyInputControl newInputControl) {
        this.attachedInputControl = newInputControl;
    }

    private boolean hasParentActiveOnStartOrOnEndScreenEffect() {
        if (this.parent != null) {
            return this.parent.effectManager.isActive(EffectEventId.onStartScreen) || this.parent.effectManager.isActive(EffectEventId.onEndScreen) || this.parent.hasParentActiveOnStartOrOnEndScreenEffect();
        }
        return false;
    }

    private void resetInteractionBlocked() {
        this.interactionBlocked = false;
        for (Element e : this.elements) {
            e.resetInteractionBlocked();
        }
    }

    public void setId(String newId) {
        this.id = newId;
    }

    public ElementType getElementType() {
        return this.elementType;
    }

    public ElementRenderer[] getElementRenderer() {
        return this.elementRenderer;
    }

    public void setFocusable(boolean newFocusable) {
        this.focusable = newFocusable;
        for (Element e : this.elements) {
            e.setFocusable(newFocusable);
        }
    }

    public NiftyInputControl getAttachedInputControl() {
        return this.attachedInputControl;
    }

    public void bindControls(Screen target) {
        if (this.screen == target) {
            return;
        }
        this.bindToScreen(target);
        for (Element element : this.elements) {
            element.bindControls(target);
        }
        if (this.attachedInputControl != null) {
            this.attachedInputControl.bindControl(this.nifty, target, this, this.elementType.getAttributes());
        }
    }

    public void initControls() {
        for (Element element : this.elements) {
            element.initControls();
        }
        if (this.attachedInputControl != null) {
            this.attachedInputControl.initControl(this.elementType.getAttributes());
        }
        this.bindToFocusHandler();
    }

    public void removeFromFocusHandler() {
        this.focusHandler.remove(this);
        for (Element element : this.elements) {
            element.removeFromFocusHandler();
        }
    }

    public FocusHandler getFocusHandler() {
        return this.focusHandler;
    }

    public void setStyle(String newStyle) {
        this.removeStyle(this.elementType.getAttributes().get("style"));
        this.elementType.getAttributes().set("style", newStyle);
        this.elementType.applyStyles(this.nifty.getDefaultStyleResolver());
        this.elementType.applyAttributes(this, this.elementType.getAttributes(), this.nifty.getRenderEngine());
        this.elementType.applyEffects(this.nifty, this.screen, this);
        this.elementType.applyInteract(this.nifty, this.screen, this);
        log.info("after setStyle [" + newStyle + "]\n" + this.elementType.output(0));
        this.notifyListeners();
    }

    public String getStyle() {
        return this.elementType.getAttributes().get("style");
    }

    void removeStyle(String style) {
        log.info("before removeStyle [" + style + "]\n" + this.elementType.output(0));
        this.elementType.removeWithTag(style);
        this.effectManager.removeAllEffects();
        log.info("after removeStyle [" + style + "]\n" + this.elementType.output(0));
        this.notifyListeners();
    }

    public void addInputHandler(KeyInputHandler handler) {
        if (this.attachedInputControl != null) {
            this.attachedInputControl.addInputHandler(handler);
        }
        for (Element element : this.elements) {
            element.addInputHandler(handler);
        }
    }

    public void addPreInputHandler(KeyInputHandler handler) {
        if (this.attachedInputControl != null) {
            this.attachedInputControl.addPreInputHandler(handler);
        }
        for (Element element : this.elements) {
            element.addPreInputHandler(handler);
        }
    }

    public <T extends Controller> T findControl(String elementName, Class<T> requestedControlClass) {
        Element element = this.findElementByName(elementName);
        if (element == null) {
            return null;
        }
        return element.getControl(requestedControlClass);
    }

    public <T extends NiftyControl> T findNiftyControl(String elementName, Class<T> requestedControlClass) {
        Element element = this.findElementByName(elementName);
        if (element == null) {
            return null;
        }
        return element.getNiftyControl(requestedControlClass);
    }

    public <T extends Controller> T getControl(Class<T> requestedControlClass) {
        T t;
        if (this.attachedInputControl != null && (t = this.attachedInputControl.getControl(requestedControlClass)) != null) {
            return t;
        }
        for (Element element : this.elements) {
            T t2 = element.getControl(requestedControlClass);
            if (t2 == null) continue;
            return t2;
        }
        return null;
    }

    public <T extends NiftyControl> T getNiftyControl(Class<T> requestedControlClass) {
        T t;
        if (this.attachedInputControl != null && (t = this.attachedInputControl.getNiftyControl(requestedControlClass)) != null) {
            return t;
        }
        for (Element element : this.elements) {
            T t2 = element.getNiftyControl(requestedControlClass);
            if (t2 == null) continue;
            return t2;
        }
        log.warning("missing element/control with id [" + this.getId() + "] for requested control class [" + requestedControlClass.getName() + "]");
        return NullObjectFactory.createNull(requestedControlClass);
    }

    public boolean isFocusable() {
        return this.focusable && this.enabled && this.visible;
    }

    public void setOnMouseOverMethod(NiftyMethodInvoker onMouseOverMethod) {
        this.interaction.setOnMouseOver(onMouseOverMethod);
    }

    public LayoutPart getLayoutPart() {
        return this.layoutPart;
    }

    public boolean isVisibleToMouseEvents() {
        return this.visibleToMouseEvents;
    }

    public void setPaddingLeft(SizeValue paddingValue) {
        this.layoutPart.getBoxConstraints().setPaddingLeft(paddingValue);
        this.notifyListeners();
    }

    public void setPaddingRight(SizeValue paddingValue) {
        this.layoutPart.getBoxConstraints().setPaddingRight(paddingValue);
        this.notifyListeners();
    }

    public void setPaddingTop(SizeValue paddingValue) {
        this.layoutPart.getBoxConstraints().setPaddingTop(paddingValue);
        this.notifyListeners();
    }

    public void setPaddingBottom(SizeValue paddingValue) {
        this.layoutPart.getBoxConstraints().setPaddingBottom(paddingValue);
        this.notifyListeners();
    }

    public String toString() {
        return this.id + " (" + super.toString() + ")";
    }

    public boolean isStarted() {
        return this.isEffectActive(EffectEventId.onStartScreen);
    }

    public void markForRemoval() {
        this.markForRemoval(null);
    }

    public void markForRemoval(EndNotify endNotify) {
        this.nifty.removeElement(this.screen, this, endNotify);
    }

    public void markForMove(Element destination) {
        this.markForMove(destination, null);
    }

    public void markForMove(Element destination, EndNotify endNotify) {
        this.nifty.moveElement(this.screen, this, destination, endNotify);
    }

    public void reactivate() {
        this.done = false;
        for (Element element : this.elements) {
            element.reactivate();
        }
    }

    private void notifyListeners() {
        this.nifty.publishEvent(this.id, this);
    }

    public Nifty getNifty() {
        return this.nifty;
    }

    public <T extends EffectImpl> List<Effect> getEffects(EffectEventId effectEventId, Class<T> requestedClass) {
        return this.effectManager.getEffects(effectEventId, requestedClass);
    }

    public void onEndScreen(Screen screen) {
        screen.unregisterElementId(this.id);
        if (this.attachedInputControl != null) {
            this.attachedInputControl.onEndScreen(this.nifty, screen, this.id);
        }
        for (Element element : this.elements) {
            element.onEndScreen(screen);
        }
    }

    public ElementInteraction getElementInteraction() {
        return this.interaction;
    }

    public class LocalEndNotify
    implements EndNotify {
        private EffectEventId effectEventId;
        private EndNotify effectEndNotiy;

        public LocalEndNotify(EffectEventId effectEventIdParam, EndNotify effectEndNotiyParam) {
            this.effectEventId = effectEventIdParam;
            this.effectEndNotiy = effectEndNotiyParam;
        }

        @Override
        public void perform() {
            if ((this.effectEventId.equals((Object)EffectEventId.onStartScreen) || this.effectEventId.equals((Object)EffectEventId.onEndScreen)) && Element.this.interactionBlocked && !Element.this.hasParentActiveOnStartOrOnEndScreenEffect() && !Element.this.isEffectActive(this.effectEventId)) {
                Element.this.resetInteractionBlocked();
            }
            if (!Element.this.isEffectActive(this.effectEventId) && this.effectEndNotiy != null) {
                this.effectEndNotiy.perform();
            }
        }
    }
}

