/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.xml.lwxs.elements;

import de.lessvoid.xml.lwxs.XmlType;
import de.lessvoid.xml.lwxs.elements.XmlProcessorElement;
import de.lessvoid.xml.lwxs.elements.XmlProcessorSubstituitionGroup;
import de.lessvoid.xml.tools.ClassHelper;
import de.lessvoid.xml.tools.MethodInvoker;
import de.lessvoid.xml.xpp3.Attributes;
import de.lessvoid.xml.xpp3.XmlParser;
import de.lessvoid.xml.xpp3.XmlProcessor;
import java.util.ArrayList;
import java.util.Collection;

public class XmlProcessorType
implements XmlProcessor {
    private String fullClassName;
    private Collection<XmlProcessorElement> elements = new ArrayList<XmlProcessorElement>();
    private Collection<XmlProcessorSubstituitionGroup> substGroups = new ArrayList<XmlProcessorSubstituitionGroup>();
    private XmlType xmlTypeParentSingle;
    private XmlType xmlTypeParentMultiple;
    private String xmlTypeParentName;
    private XmlType xmlType;

    public XmlProcessorType(String fullClassNameParam) {
        this.fullClassName = fullClassNameParam;
    }

    public void addElementProcessor(XmlProcessorElement element) {
        this.elements.add(element);
    }

    public void addSubstituitionGroup(XmlProcessorSubstituitionGroup element) {
        this.substGroups.add(element);
    }

    @Override
    public void process(XmlParser xmlParser, Attributes attributes) throws Exception {
        this.xmlType = ClassHelper.getInstance(this.fullClassName, XmlType.class);
        this.xmlType.initFromAttributes(attributes);
        if (this.xmlTypeParentSingle != null) {
            this.invoke(this.xmlType, this.xmlTypeParentSingle, "set");
        } else if (this.xmlTypeParentMultiple != null) {
            this.invoke(this.xmlType, this.xmlTypeParentMultiple, "add");
        }
        xmlParser.nextTag();
        for (XmlProcessorElement child : this.elements) {
            child.process(xmlParser, this.xmlType);
        }
        for (XmlProcessorSubstituitionGroup subst : this.substGroups) {
            xmlParser.zeroOrMore(subst.getSubstGroup(this.xmlType));
        }
    }

    public XmlType getXmlType() {
        return this.xmlType;
    }

    private void invoke(XmlType child, XmlType parent, String qualifier) {
        MethodInvoker methodInvoker = new MethodInvoker(qualifier + this.xmlTypeParentName + "()", parent);
        methodInvoker.invoke(child);
    }

    public void parentLinkSet(XmlType xmlTypeParent, String elementName) {
        this.xmlTypeParentSingle = xmlTypeParent;
        this.xmlTypeParentMultiple = null;
        this.xmlTypeParentName = elementName;
    }

    public void parentLinkAdd(XmlType xmlTypeParent, String elementName) {
        this.xmlTypeParentSingle = null;
        this.xmlTypeParentMultiple = xmlTypeParent;
        this.xmlTypeParentName = elementName;
    }
}

