/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.classreader.impl;

import com.jeantessier.classreader.DescriptorHelper;
import com.jeantessier.classreader.UTF8_info;
import com.jeantessier.classreader.Visitor;
import com.jeantessier.classreader.impl.ConstantPool;
import com.jeantessier.classreader.impl.ElementValue;
import com.jeantessier.classreader.impl.ElementValueType;
import java.io.DataInput;
import java.io.IOException;
import org.apache.log4j.Logger;

public class ClassElementValue
extends ElementValue
implements com.jeantessier.classreader.ClassElementValue {
    private int classInfoIndex;

    public ClassElementValue(ConstantPool constantPool, DataInput in) throws IOException {
        super(constantPool);
        this.classInfoIndex = in.readUnsignedShort();
        Logger.getLogger(this.getClass()).debug((Object)("Class info index: " + this.classInfoIndex));
    }

    @Override
    public int getClassInfoIndex() {
        return this.classInfoIndex;
    }

    @Override
    public UTF8_info getRawClassInfo() {
        return (UTF8_info)this.getConstantPool().get(this.getClassInfoIndex());
    }

    @Override
    public String getClassInfo() {
        String result = "";
        if (this.getClassInfoIndex() != 0) {
            result = DescriptorHelper.convert(this.getRawClassInfo().getValue());
        }
        return result;
    }

    @Override
    public char getTag() {
        return ElementValueType.CLASS.getTag();
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitClassElementValue(this);
    }
}

