/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.classreader.impl;

import com.jeantessier.classreader.impl.AnnotationElementValue;
import com.jeantessier.classreader.impl.ArrayElementValue;
import com.jeantessier.classreader.impl.BooleanConstantElementValue;
import com.jeantessier.classreader.impl.ByteConstantElementValue;
import com.jeantessier.classreader.impl.CharConstantElementValue;
import com.jeantessier.classreader.impl.ClassElementValue;
import com.jeantessier.classreader.impl.ConstantPool;
import com.jeantessier.classreader.impl.DoubleConstantElementValue;
import com.jeantessier.classreader.impl.ElementValue;
import com.jeantessier.classreader.impl.EnumElementValue;
import com.jeantessier.classreader.impl.FloatConstantElementValue;
import com.jeantessier.classreader.impl.IntegerConstantElementValue;
import com.jeantessier.classreader.impl.LongConstantElementValue;
import com.jeantessier.classreader.impl.ShortConstantElementValue;
import com.jeantessier.classreader.impl.StringConstantElementValue;
import java.io.DataInput;
import java.io.IOException;

public enum ElementValueType {
    BYTE(com.jeantessier.classreader.ElementValueType.BYTE){

        @Override
        public ElementValue create(ConstantPool constantPool, DataInput in) throws IOException {
            return new ByteConstantElementValue(constantPool, in);
        }
    }
    ,
    CHAR(com.jeantessier.classreader.ElementValueType.CHAR){

        @Override
        public ElementValue create(ConstantPool constantPool, DataInput in) throws IOException {
            return new CharConstantElementValue(constantPool, in);
        }
    }
    ,
    DOUBLE(com.jeantessier.classreader.ElementValueType.DOUBLE){

        @Override
        public ElementValue create(ConstantPool constantPool, DataInput in) throws IOException {
            return new DoubleConstantElementValue(constantPool, in);
        }
    }
    ,
    FLOAT(com.jeantessier.classreader.ElementValueType.FLOAT){

        @Override
        public ElementValue create(ConstantPool constantPool, DataInput in) throws IOException {
            return new FloatConstantElementValue(constantPool, in);
        }
    }
    ,
    INTEGER(com.jeantessier.classreader.ElementValueType.INTEGER){

        @Override
        public ElementValue create(ConstantPool constantPool, DataInput in) throws IOException {
            return new IntegerConstantElementValue(constantPool, in);
        }
    }
    ,
    LONG(com.jeantessier.classreader.ElementValueType.LONG){

        @Override
        public ElementValue create(ConstantPool constantPool, DataInput in) throws IOException {
            return new LongConstantElementValue(constantPool, in);
        }
    }
    ,
    SHORT(com.jeantessier.classreader.ElementValueType.SHORT){

        @Override
        public ElementValue create(ConstantPool constantPool, DataInput in) throws IOException {
            return new ShortConstantElementValue(constantPool, in);
        }
    }
    ,
    BOOLEAN(com.jeantessier.classreader.ElementValueType.BOOLEAN){

        @Override
        public ElementValue create(ConstantPool constantPool, DataInput in) throws IOException {
            return new BooleanConstantElementValue(constantPool, in);
        }
    }
    ,
    STRING(com.jeantessier.classreader.ElementValueType.STRING){

        @Override
        public ElementValue create(ConstantPool constantPool, DataInput in) throws IOException {
            return new StringConstantElementValue(constantPool, in);
        }
    }
    ,
    ENUM(com.jeantessier.classreader.ElementValueType.ENUM){

        @Override
        public ElementValue create(ConstantPool constantPool, DataInput in) throws IOException {
            return new EnumElementValue(constantPool, in);
        }
    }
    ,
    CLASS(com.jeantessier.classreader.ElementValueType.CLASS){

        @Override
        public ElementValue create(ConstantPool constantPool, DataInput in) throws IOException {
            return new ClassElementValue(constantPool, in);
        }
    }
    ,
    ANNOTATION(com.jeantessier.classreader.ElementValueType.ANNOTATION){

        @Override
        public ElementValue create(ConstantPool constantPool, DataInput in) throws IOException {
            return new AnnotationElementValue(constantPool, in);
        }
    }
    ,
    ARRAY(com.jeantessier.classreader.ElementValueType.ARRAY){

        @Override
        public ElementValue create(ConstantPool constantPool, DataInput in) throws IOException {
            return new ArrayElementValue(constantPool, in);
        }
    };

    private final com.jeantessier.classreader.ElementValueType elementValueType;

    private ElementValueType(com.jeantessier.classreader.ElementValueType elementValueType) {
        this.elementValueType = elementValueType;
    }

    public char getTag() {
        return this.elementValueType.getTag();
    }

    public abstract ElementValue create(ConstantPool var1, DataInput var2) throws IOException;

    public static ElementValueType forTag(char tag) {
        ElementValueType result = null;
        for (ElementValueType elementValueType : ElementValueType.values()) {
            if (elementValueType.getTag() != tag) continue;
            result = elementValueType;
        }
        return result;
    }
}

