/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.classreader.impl;

import com.jeantessier.classreader.Visitable;
import com.jeantessier.classreader.Visitor;
import com.jeantessier.classreader.impl.AttributeType;
import com.jeantessier.classreader.impl.Attribute_info;
import com.jeantessier.classreader.impl.ConstantPool;
import com.jeantessier.classreader.impl.LocalVariableType;
import java.io.DataInput;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public class LocalVariableTypeTable_attribute
extends Attribute_info
implements com.jeantessier.classreader.LocalVariableTypeTable_attribute {
    private Collection<LocalVariableType> localVariableTypes = new LinkedList<LocalVariableType>();

    public LocalVariableTypeTable_attribute(ConstantPool constantPool, Visitable owner, DataInput in) throws IOException {
        super(constantPool, owner);
        int byteCount = in.readInt();
        Logger.getLogger(this.getClass()).debug((Object)("Attribute length: " + byteCount));
        int localVariableTableTypeLength = in.readUnsignedShort();
        Logger.getLogger(this.getClass()).debug((Object)("Reading " + localVariableTableTypeLength + " local variable type(s) ..."));
        for (int i = 0; i < localVariableTableTypeLength; ++i) {
            Logger.getLogger(this.getClass()).debug((Object)("Local variable type " + i + ":"));
            this.localVariableTypes.add(new LocalVariableType(this, in));
        }
    }

    public Collection<LocalVariableType> getLocalVariableTypes() {
        return this.localVariableTypes;
    }

    public String toString() {
        return "Local Variable Type Table";
    }

    @Override
    public String getAttributeName() {
        return AttributeType.LOCAL_VARIABLE_TYPE_TABLE.getAttributeName();
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitLocalVariableTypeTable_attribute(this);
    }
}

