/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.classreader.impl;

import com.jeantessier.classreader.CodeFinder;
import com.jeantessier.classreader.Code_attribute;
import com.jeantessier.classreader.DescriptorHelper;
import com.jeantessier.classreader.Visitor;
import com.jeantessier.classreader.impl.Attribute_info;
import com.jeantessier.classreader.impl.Class_info;
import com.jeantessier.classreader.impl.Classfile;
import com.jeantessier.classreader.impl.Exceptions_attribute;
import com.jeantessier.classreader.impl.Feature_info;
import java.io.DataInput;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public class Method_info
extends Feature_info
implements com.jeantessier.classreader.Method_info {
    private static final int ACC_SYNCHRONIZED = 32;
    private static final int ACC_BRIDGE = 64;
    private static final int ACC_VARARGS = 128;
    private static final int ACC_NATIVE = 256;
    private static final int ACC_ABSTRACT = 1024;
    private static final int ACC_STRICT = 2048;

    public Method_info(Classfile classfile, DataInput in) throws IOException {
        super(classfile, in);
    }

    @Override
    public String getFeatureType() {
        return "method";
    }

    @Override
    public boolean isSynchronized() {
        return (this.getAccessFlag() & 0x20) != 0;
    }

    @Override
    public boolean isBridge() {
        return (this.getAccessFlag() & 0x40) != 0;
    }

    @Override
    public boolean isVarargs() {
        return (this.getAccessFlag() & 0x80) != 0;
    }

    @Override
    public boolean isNative() {
        return (this.getAccessFlag() & 0x100) != 0;
    }

    @Override
    public boolean isAbstract() {
        return (this.getAccessFlag() & 0x400) != 0;
    }

    @Override
    public boolean isStrict() {
        return (this.getAccessFlag() & 0x800) != 0;
    }

    @Override
    public boolean isConstructor() {
        return this.getName().equals("<init>");
    }

    @Override
    public boolean isStaticInitializer() {
        return this.getName().equals("<clinit>");
    }

    public Collection<Class_info> getExceptions() {
        Collection<Class_info> result = Collections.emptyList();
        for (Attribute_info attribute : this.getAttributes()) {
            if (!(attribute instanceof Exceptions_attribute)) continue;
            result = ((Exceptions_attribute)attribute).getExceptions();
        }
        return result;
    }

    @Override
    public String getSignature() {
        StringBuffer result = new StringBuffer();
        if (this.isConstructor()) {
            result.append(this.getClassfile().getSimpleName());
            result.append(DescriptorHelper.getSignature(this.getDescriptor()));
        } else if (this.isStaticInitializer()) {
            result.append("static {}");
        } else {
            result.append(this.getName());
            result.append(DescriptorHelper.getSignature(this.getDescriptor()));
        }
        return result.toString();
    }

    @Override
    public String getReturnType() {
        return DescriptorHelper.getReturnType(this.getDescriptor());
    }

    @Override
    public String getDeclaration() {
        StringBuffer result = new StringBuffer();
        if (this.isPublic()) {
            result.append("public ");
        }
        if (this.isProtected()) {
            result.append("protected ");
        }
        if (this.isPrivate()) {
            result.append("private ");
        }
        if (this.isStatic() && !this.isStaticInitializer()) {
            result.append("static ");
        }
        if (this.isFinal()) {
            result.append("final ");
        }
        if (this.isSynchronized()) {
            result.append("synchronized ");
        }
        if (this.isNative()) {
            result.append("native ");
        }
        if (this.isAbstract()) {
            result.append("abstract ");
        }
        if (!this.isConstructor() && !this.isStaticInitializer()) {
            result.append(this.getReturnType() != null ? this.getReturnType() : "void").append(" ");
        }
        result.append(this.getSignature());
        if (this.getExceptions().size() != 0) {
            result.append(" throws ");
            Iterator<Class_info> i = this.getExceptions().iterator();
            while (i.hasNext()) {
                result.append(i.next());
                if (!i.hasNext()) continue;
                result.append(", ");
            }
        }
        return result.toString();
    }

    @Override
    public Code_attribute getCode() {
        CodeFinder finder = new CodeFinder();
        this.accept(finder);
        return finder.getCode();
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitMethod_info(this);
    }
}

