/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependency;

import com.jeantessier.classreader.Annotation;
import com.jeantessier.classreader.ClassElementValue;
import com.jeantessier.classreader.ClassNameHelper;
import com.jeantessier.classreader.Class_info;
import com.jeantessier.classreader.Classfile;
import com.jeantessier.classreader.CollectorBase;
import com.jeantessier.classreader.EnumElementValue;
import com.jeantessier.classreader.ExceptionHandler;
import com.jeantessier.classreader.FieldRef_info;
import com.jeantessier.classreader.Field_info;
import com.jeantessier.classreader.Instruction;
import com.jeantessier.classreader.InterfaceMethodRef_info;
import com.jeantessier.classreader.MethodRef_info;
import com.jeantessier.classreader.Method_info;
import com.jeantessier.dependency.ClassNode;
import com.jeantessier.dependency.ComprehensiveSelectionCriteria;
import com.jeantessier.dependency.DependencyEvent;
import com.jeantessier.dependency.DependencyListener;
import com.jeantessier.dependency.FeatureNode;
import com.jeantessier.dependency.Node;
import com.jeantessier.dependency.NodeFactory;
import com.jeantessier.dependency.SelectionCriteria;
import java.util.Collection;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class CodeDependencyCollector
extends CollectorBase {
    private NodeFactory factory;
    private SelectionCriteria filterCriteria;
    private Node current;
    private HashSet<DependencyListener> dependencyListeners = new HashSet();

    public CodeDependencyCollector() {
        this(new NodeFactory());
    }

    public CodeDependencyCollector(NodeFactory factory) {
        this(factory, new ComprehensiveSelectionCriteria());
    }

    public CodeDependencyCollector(NodeFactory factory, SelectionCriteria filterCriteria) {
        this.factory = factory;
        this.filterCriteria = filterCriteria;
    }

    public NodeFactory getFactory() {
        return this.factory;
    }

    private Node getCurrent() {
        return this.current;
    }

    void setCurrent(Node current) {
        this.current = current;
    }

    @Override
    public Collection<String> getCollection() {
        return this.getFactory().getPackages().keySet();
    }

    @Override
    public void visitClassfile(Classfile classfile) {
        ClassNode currentClass = this.getFactory().createClass(classfile.getClassName(), true);
        this.setCurrent(currentClass);
        this.fireBeginClass(classfile.getClassName());
        if (classfile.getSuperclassIndex() != 0) {
            Class_info superclass = classfile.getRawSuperclass();
            superclass.accept(this);
            currentClass.addParent(this.getFactory().createClass(superclass.getName()));
        }
        for (Class_info class_info : classfile.getAllInterfaces()) {
            class_info.accept(this);
            currentClass.addParent(this.getFactory().createClass(class_info.getName()));
        }
        super.visitClassfile(classfile);
        this.fireEndClass(classfile.getClassName());
    }

    @Override
    protected void visitClassfileAttributes(Classfile classfile) {
        this.setCurrent(this.getFactory().createClass(classfile.getClassName()));
        super.visitClassfileAttributes(classfile);
    }

    @Override
    public void visitClass_info(Class_info entry) {
        String classname = entry.getName();
        if (Logger.getLogger(this.getClass()).isDebugEnabled()) {
            Logger.getLogger(this.getClass()).debug((Object)"VisitClass_info():");
            Logger.getLogger(this.getClass()).debug((Object)("    name = \"" + classname + "\""));
        }
        if (classname.startsWith("[")) {
            this.processDescriptor(classname);
        } else {
            this.processClassName(classname);
        }
        super.visitClass_info(entry);
    }

    @Override
    public void visitFieldRef_info(FieldRef_info entry) {
        if (Logger.getLogger(this.getClass()).isDebugEnabled()) {
            Logger.getLogger(this.getClass()).debug((Object)"VisitFieldRef_info():");
            Logger.getLogger(this.getClass()).debug((Object)("    class = \"" + entry.getClassName() + "\""));
            Logger.getLogger(this.getClass()).debug((Object)("    name = \"" + entry.getRawNameAndType().getName() + "\""));
            Logger.getLogger(this.getClass()).debug((Object)("    type = \"" + entry.getRawNameAndType().getType() + "\""));
        }
        String signature = entry.getFullSignature();
        if (this.filterCriteria.isMatchingFeatures() && this.filterCriteria.matchesFeatureName(signature)) {
            FeatureNode other = this.getFactory().createFeature(signature);
            this.getCurrent().addDependency(other);
            if (Logger.getLogger(this.getClass()).isDebugEnabled()) {
                Logger.getLogger(this.getClass()).info((Object)("FieldRef_info dependency: " + this.getCurrent() + " --> " + other));
            }
            this.fireDependency(this.getCurrent(), other);
        }
        this.processDescriptor(entry.getRawNameAndType().getType());
        super.visitFieldRef_info(entry);
    }

    @Override
    public void visitMethodRef_info(MethodRef_info entry) {
        if (Logger.getLogger(this.getClass()).isDebugEnabled()) {
            Logger.getLogger(this.getClass()).debug((Object)"VisitMethodRef_info():");
            Logger.getLogger(this.getClass()).debug((Object)("    class = \"" + entry.getClassName() + "\""));
            Logger.getLogger(this.getClass()).debug((Object)("    name = \"" + entry.getRawNameAndType().getName() + "\""));
            Logger.getLogger(this.getClass()).debug((Object)("    type = \"" + entry.getRawNameAndType().getType() + "\""));
        }
        if (!entry.isStaticInitializer()) {
            String signature = entry.getFullSignature();
            if (this.filterCriteria.isMatchingFeatures() && this.filterCriteria.matchesFeatureName(signature)) {
                FeatureNode other = this.getFactory().createFeature(signature);
                this.getCurrent().addDependency(other);
                if (Logger.getLogger(this.getClass()).isDebugEnabled()) {
                    Logger.getLogger(this.getClass()).info((Object)("MethodRef_info dependency: " + this.getCurrent() + " --> " + other));
                }
                this.fireDependency(this.getCurrent(), other);
            }
            this.processDescriptor(entry.getRawNameAndType().getType());
        }
        super.visitMethodRef_info(entry);
    }

    @Override
    public void visitInterfaceMethodRef_info(InterfaceMethodRef_info entry) {
        if (Logger.getLogger(this.getClass()).isDebugEnabled()) {
            Logger.getLogger(this.getClass()).debug((Object)"VisitInterfaceMethodRef_info():");
            Logger.getLogger(this.getClass()).debug((Object)("    class = \"" + entry.getClassName() + "\""));
            Logger.getLogger(this.getClass()).debug((Object)("    name = \"" + entry.getRawNameAndType().getName() + "\""));
            Logger.getLogger(this.getClass()).debug((Object)("    type = \"" + entry.getRawNameAndType().getType() + "\""));
        }
        String signature = entry.getFullSignature();
        if (this.filterCriteria.isMatchingFeatures() && this.filterCriteria.matchesFeatureName(signature)) {
            FeatureNode other = this.getFactory().createFeature(signature);
            this.getCurrent().addDependency(other);
            if (Logger.getLogger(this.getClass()).isDebugEnabled()) {
                Logger.getLogger(this.getClass()).info((Object)("InterfaceMethodRef_info dependency: " + this.getCurrent() + " --> " + other));
            }
            this.fireDependency(this.getCurrent(), other);
        }
        this.processDescriptor(entry.getRawNameAndType().getType());
        super.visitInterfaceMethodRef_info(entry);
    }

    @Override
    public void visitField_info(Field_info entry) {
        if (Logger.getLogger(this.getClass()).isDebugEnabled()) {
            Logger.getLogger(this.getClass()).debug((Object)"VisitField_info():");
            Logger.getLogger(this.getClass()).debug((Object)("    name = \"" + entry.getName() + "\""));
            Logger.getLogger(this.getClass()).debug((Object)("    descriptor = \"" + entry.getDescriptor() + "\""));
        }
        this.setCurrent(this.getFactory().createFeature(entry.getFullSignature(), true));
        this.processDescriptor(entry.getDescriptor());
        super.visitField_info(entry);
    }

    @Override
    public void visitMethod_info(Method_info entry) {
        if (Logger.getLogger(this.getClass()).isDebugEnabled()) {
            Logger.getLogger(this.getClass()).debug((Object)"VisitMethod_info():");
            Logger.getLogger(this.getClass()).debug((Object)("    name = \"" + entry.getName() + "\""));
            Logger.getLogger(this.getClass()).debug((Object)("    descriptor = \"" + entry.getDescriptor() + "\""));
        }
        this.setCurrent(this.getFactory().createFeature(entry.getFullSignature(), true));
        this.processDescriptor(entry.getDescriptor());
        super.visitMethod_info(entry);
    }

    @Override
    public void visitInstruction(Instruction helper) {
        Logger.getLogger(this.getClass()).debug((Object)"VisitInstruction() ...");
        switch (helper.getOpcode()) {
            case 18: 
            case 19: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 189: 
            case 192: 
            case 193: 
            case 197: {
                helper.getIndexedConstantPoolEntry().accept(this);
                break;
            }
        }
        super.visitInstruction(helper);
    }

    @Override
    public void visitExceptionHandler(ExceptionHandler helper) {
        if (Logger.getLogger(this.getClass()).isDebugEnabled()) {
            Logger.getLogger(this.getClass()).debug((Object)(this.getClass().getName() + "VisitExceptionHandler(): " + helper));
        }
        if (helper.getCatchTypeIndex() != 0) {
            helper.getRawCatchType().accept(this);
        }
        super.visitExceptionHandler(helper);
    }

    @Override
    public void visitAnnotation(Annotation helper) {
        this.processClassName(helper.getType());
        super.visitAnnotation(helper);
    }

    @Override
    public void visitEnumElementValue(EnumElementValue helper) {
        String signature = helper.getTypeName() + "." + helper.getConstName();
        if (this.filterCriteria.isMatchingFeatures() && this.filterCriteria.matchesFeatureName(signature)) {
            FeatureNode other = this.getFactory().createFeature(signature);
            this.getCurrent().addDependency(other);
            if (Logger.getLogger(this.getClass()).isDebugEnabled()) {
                Logger.getLogger(this.getClass()).info((Object)("EnumElementValue dependency: " + this.getCurrent() + " --> " + other));
            }
            this.fireDependency(this.getCurrent(), other);
        }
        super.visitEnumElementValue(helper);
    }

    @Override
    public void visitClassElementValue(ClassElementValue helper) {
        this.processClassName(helper.getClassInfo());
        super.visitClassElementValue(helper);
    }

    private void processDescriptor(String str) {
        int startPos;
        int currentPos = 0;
        while ((startPos = str.indexOf(76, currentPos)) != -1) {
            int endPos = str.indexOf(59, startPos);
            if (endPos != -1) {
                this.processClassName(ClassNameHelper.path2ClassName(str.substring(startPos + 1, endPos)));
                currentPos = endPos + 1;
                continue;
            }
            currentPos = startPos + 1;
        }
    }

    private void processClassName(String classname) {
        if (this.filterCriteria.isMatchingClasses() && this.filterCriteria.matchesClassName(classname)) {
            if (Logger.getLogger(this.getClass()).isDebugEnabled()) {
                Logger.getLogger(this.getClass()).debug((Object)("    Adding \"" + classname + "\""));
            }
            ClassNode other = this.getFactory().createClass(classname);
            this.getCurrent().addDependency(other);
            if (Logger.getLogger(this.getClass()).isDebugEnabled()) {
                Logger.getLogger(this.getClass()).info((Object)("Class_info dependency: " + this.getCurrent() + " --> " + other));
            }
            this.fireDependency(this.getCurrent(), other);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDependencyListener(DependencyListener listener) {
        HashSet<DependencyListener> hashSet = this.dependencyListeners;
        synchronized (hashSet) {
            this.dependencyListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDependencyListener(DependencyListener listener) {
        HashSet<DependencyListener> hashSet = this.dependencyListeners;
        synchronized (hashSet) {
            this.dependencyListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireBeginSession() {
        HashSet listeners;
        DependencyEvent event = new DependencyEvent(this);
        HashSet<DependencyListener> hashSet = this.dependencyListeners;
        synchronized (hashSet) {
            listeners = (HashSet)this.dependencyListeners.clone();
        }
        for (DependencyListener listener : listeners) {
            listener.beginSession(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireBeginClass(String classname) {
        HashSet listeners;
        DependencyEvent event = new DependencyEvent(this, classname);
        HashSet<DependencyListener> hashSet = this.dependencyListeners;
        synchronized (hashSet) {
            listeners = (HashSet)this.dependencyListeners.clone();
        }
        for (DependencyListener listener : listeners) {
            listener.beginClass(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireDependency(Node dependent, Node dependable) {
        HashSet listeners;
        DependencyEvent event = new DependencyEvent(this, dependent, dependable);
        HashSet<DependencyListener> hashSet = this.dependencyListeners;
        synchronized (hashSet) {
            listeners = (HashSet)this.dependencyListeners.clone();
        }
        for (DependencyListener listener : listeners) {
            listener.dependency(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireEndClass(String classname) {
        HashSet listeners;
        DependencyEvent event = new DependencyEvent(this, classname);
        HashSet<DependencyListener> hashSet = this.dependencyListeners;
        synchronized (hashSet) {
            listeners = (HashSet)this.dependencyListeners.clone();
        }
        for (DependencyListener listener : listeners) {
            listener.endClass(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireEndSession() {
        HashSet listeners;
        DependencyEvent event = new DependencyEvent(this);
        HashSet<DependencyListener> hashSet = this.dependencyListeners;
        synchronized (hashSet) {
            listeners = (HashSet)this.dependencyListeners.clone();
        }
        for (DependencyListener listener : listeners) {
            listener.endSession(event);
        }
    }
}

