/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependency;

import com.jeantessier.classreader.RemoveVisitor;
import com.jeantessier.dependency.ClassNode;
import com.jeantessier.dependency.FeatureNode;
import com.jeantessier.dependency.Node;
import com.jeantessier.dependency.NodeFactory;
import com.jeantessier.dependency.PackageNode;
import com.jeantessier.dependency.Visitor;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;

public class DeletingVisitor
implements Visitor,
RemoveVisitor {
    private NodeFactory factory;

    public DeletingVisitor(NodeFactory factory) {
        this.factory = factory;
    }

    public NodeFactory getFactory() {
        return this.factory;
    }

    @Override
    public void traverseNodes(Collection<? extends Node> nodes) {
        throw new UnsupportedOperationException("not implemented yet.");
    }

    @Override
    public void traverseInbound(Collection<? extends Node> nodes) {
        throw new UnsupportedOperationException("not implemented yet.");
    }

    @Override
    public void traverseOutbound(Collection<? extends Node> nodes) {
        throw new UnsupportedOperationException("not implemented yet.");
    }

    @Override
    public void visitPackageNode(PackageNode node) {
        Logger.getLogger(this.getClass()).debug((Object)("visitPackageNode(" + node + ")"));
        for (ClassNode classNode : new ArrayList<ClassNode>(node.getClasses())) {
            classNode.accept(this);
        }
        this.visitNode(node);
    }

    @Override
    public void visitClassNode(ClassNode node) {
        Logger.getLogger(this.getClass()).debug((Object)("visitClassNode(" + node + ")"));
        for (FeatureNode featureNode : new ArrayList<FeatureNode>(node.getFeatures())) {
            featureNode.accept(this);
        }
        this.visitNode(node);
    }

    @Override
    public void visitFeatureNode(FeatureNode node) {
        Logger.getLogger(this.getClass()).debug((Object)("visitFeatureNode(" + node + ")"));
        this.visitNode(node);
    }

    private void visitNode(Node node) {
        node.setConfirmed(false);
        for (Node outbound : new ArrayList<Node>(node.getOutboundDependencies())) {
            node.removeDependency(outbound);
            outbound.acceptOutbound(this);
        }
        node.acceptOutbound(this);
    }

    @Override
    public void visitOutboundPackageNode(PackageNode node) {
        Logger.getLogger(this.getClass()).debug((Object)("visitOutboundPackageNode(" + node + ")"));
        if (this.canDeletePackage(node)) {
            this.factory.deletePackage(node);
        }
    }

    @Override
    public void visitOutboundClassNode(ClassNode node) {
        Logger.getLogger(this.getClass()).debug((Object)("visitOutboundClassNode(" + node + ")"));
        if (this.canDeleteClass(node)) {
            this.factory.deleteClass(node);
        }
        node.getPackageNode().acceptOutbound(this);
    }

    @Override
    public void visitOutboundFeatureNode(FeatureNode node) {
        Logger.getLogger(this.getClass()).debug((Object)("visitOutboundFeatureNode(" + node + ")"));
        if (this.canDeleteFeature(node)) {
            this.factory.deleteFeature(node);
        }
        node.getClassNode().acceptOutbound(this);
    }

    private boolean canDelete(Node node) {
        return !node.isConfirmed() && node.getInboundDependencies().isEmpty();
    }

    private boolean canDeletePackage(PackageNode node) {
        return this.canDelete(node) && node.getClasses().isEmpty();
    }

    private boolean canDeleteClass(ClassNode node) {
        return this.canDelete(node) && node.getFeatures().isEmpty();
    }

    private boolean canDeleteFeature(FeatureNode node) {
        return this.canDelete(node);
    }

    @Override
    public void visitInboundPackageNode(PackageNode node) {
    }

    @Override
    public void visitInboundClassNode(ClassNode node) {
    }

    @Override
    public void visitInboundFeatureNode(FeatureNode node) {
    }

    @Override
    public void removeClass(String classname) {
        Node node = this.factory.getClasses().get(classname);
        if (node != null) {
            node.accept(this);
        }
    }
}

