/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependencyfinder.gui;

import com.jeantessier.classreader.ClassfileLoaderDispatcher;
import com.jeantessier.classreader.ClassfileLoaderEventSource;
import com.jeantessier.classreader.ModifiedOnlyDispatcher;
import com.jeantessier.classreader.Monitor;
import com.jeantessier.commandline.CommandLine;
import com.jeantessier.commandline.CommandLineUsage;
import com.jeantessier.commandline.NullParameterStrategy;
import com.jeantessier.dependency.CodeDependencyCollector;
import com.jeantessier.dependency.DeletingVisitor;
import com.jeantessier.dependency.GraphCopier;
import com.jeantessier.dependency.GraphSummarizer;
import com.jeantessier.dependency.MetricsGatherer;
import com.jeantessier.dependency.MetricsReport;
import com.jeantessier.dependency.NodeFactory;
import com.jeantessier.dependency.PackageNode;
import com.jeantessier.dependency.RegularExpressionSelectionCriteria;
import com.jeantessier.dependency.SelectiveTraversalStrategy;
import com.jeantessier.dependency.TextPrinter;
import com.jeantessier.dependency.TransitiveClosure;
import com.jeantessier.dependencyfinder.gui.AboutAction;
import com.jeantessier.dependencyfinder.gui.AdvancedQueryPanelAction;
import com.jeantessier.dependencyfinder.gui.AllQueriesAction;
import com.jeantessier.dependencyfinder.gui.ClosureQueryAction;
import com.jeantessier.dependencyfinder.gui.DependencyExtractAction;
import com.jeantessier.dependencyfinder.gui.DependencyQueryAction;
import com.jeantessier.dependencyfinder.gui.ExitAction;
import com.jeantessier.dependencyfinder.gui.MetricsQueryAction;
import com.jeantessier.dependencyfinder.gui.MetricsTableModel;
import com.jeantessier.dependencyfinder.gui.NewDependencyGraphAction;
import com.jeantessier.dependencyfinder.gui.OpenFileAction;
import com.jeantessier.dependencyfinder.gui.PrinterControlAction;
import com.jeantessier.dependencyfinder.gui.RefreshDependencyGraphAction;
import com.jeantessier.dependencyfinder.gui.SaveFileAction;
import com.jeantessier.dependencyfinder.gui.SimpleQueryPanelAction;
import com.jeantessier.dependencyfinder.gui.StatusLine;
import com.jeantessier.dependencyfinder.gui.WindowKiller;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.log4j.Logger;

public class DependencyFinder
extends JFrame {
    private boolean minimize;
    private boolean maximize;
    private boolean advancedMode;
    private JPanel queryPanel = new JPanel();
    private JMenuBar menuBar = new JMenuBar();
    private JMenu fileMenu = new JMenu();
    private JMenu viewMenu = new JMenu();
    private JMenu helpMenu = new JMenu();
    private JToolBar toolbar = new JToolBar();
    private JTextArea dependenciesResultArea = new JTextArea();
    private JTextArea closureResultArea = new JTextArea();
    private JTextArea metricsResultArea = new JTextArea();
    private MetricsTableModel metricsChartModel = new MetricsTableModel();
    private StatusLine statusLine = new StatusLine(420);
    private JProgressBar progressBar = new JProgressBar();
    private Collection<String> inputFiles = null;
    private ClassfileLoaderDispatcher dispatcher = null;
    private NodeFactory nodeFactory = null;
    private Monitor monitor = null;
    private JCheckBox packageScope = new JCheckBox("packages");
    private JCheckBox classScope = new JCheckBox("classes");
    private JCheckBox featureScope = new JCheckBox("features");
    private JTextField scopeIncludes = new JTextField();
    private JTextField packageScopeIncludes = new JTextField();
    private JTextField classScopeIncludes = new JTextField();
    private JTextField featureScopeIncludes = new JTextField();
    private JTextField scopeExcludes = new JTextField();
    private JTextField packageScopeExcludes = new JTextField();
    private JTextField classScopeExcludes = new JTextField();
    private JTextField featureScopeExcludes = new JTextField();
    private JCheckBox packageFilter = new JCheckBox("packages");
    private JCheckBox classFilter = new JCheckBox("classes");
    private JCheckBox featureFilter = new JCheckBox("features");
    private JTextField filterIncludes = new JTextField();
    private JTextField packageFilterIncludes = new JTextField();
    private JTextField classFilterIncludes = new JTextField();
    private JTextField featureFilterIncludes = new JTextField();
    private JTextField filterExcludes = new JTextField();
    private JTextField packageFilterExcludes = new JTextField();
    private JTextField classFilterExcludes = new JTextField();
    private JTextField featureFilterExcludes = new JTextField();
    private JCheckBox showInbounds = new JCheckBox("<--");
    private JCheckBox showOutbounds = new JCheckBox("-->");
    private JCheckBox showEmptyNodes = new JCheckBox("empty elements");
    private JCheckBox copyOnly = new JCheckBox("copy only");
    private JTextField maximumInboundDepth = new JTextField("0", 2);
    private JTextField maximumOutboundDepth = new JTextField(2);
    private GraphCopier dependenciesQuery = null;

    public DependencyFinder(CommandLine commandLine) {
        this.setSize(new Dimension(800, 600));
        this.setTitle("Dependency Finder");
        this.setIconImage(new ImageIcon(this.getClass().getResource("icons/logoicon.gif")).getImage());
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowKiller());
        this.setNewDependencyGraph();
        this.packageScope.setToolTipText("Select packages");
        this.classScope.setToolTipText("Select classes (with their package)");
        this.featureScope.setToolTipText("Select methods and fields (with their class and package)");
        this.scopeIncludes.setToolTipText("Package, class, method, or field must match any these expressions. E.g., /^com.mycompany/, /\\.get\\w+\\(/");
        this.packageScopeIncludes.setToolTipText("Package must match any these expressions. E.g., /^com.mycompany/, /\\.get\\w+\\(/");
        this.classScopeIncludes.setToolTipText("Class must match any these expressions. E.g., /^com.mycompany/, /\\.get\\w+\\(/");
        this.featureScopeIncludes.setToolTipText("Method or field must match any these expressions. E.g., /^com.mycompany/, /\\.get\\w+\\(/");
        this.scopeExcludes.setToolTipText("Package, class, method, or field must NOT match any of these expressions. E.g., /Test/");
        this.packageScopeExcludes.setToolTipText("Package must NOT match any of these expressions. E.g., /Test/");
        this.classScopeExcludes.setToolTipText("Class must NOT match any of these expressions. E.g., /Test/");
        this.featureScopeExcludes.setToolTipText("Method or field must NOT match any of these expressions. E.g., /Test/");
        this.packageFilter.setToolTipText("Show dependencies to/from packages");
        this.classFilter.setToolTipText("Show dependencies to/from classes");
        this.featureFilter.setToolTipText("Show dependencies to/from methods and fields");
        this.filterIncludes.setToolTipText("Package, class, method, or field at the other end of the dependency must match any these expressions. E.g., /^com.mycompany/, /\\.get\\w+\\(/");
        this.packageFilterIncludes.setToolTipText("Package at the other end of the dependency must match any these expressions. E.g., /^com.mycompany/, /\\.get\\w+\\(/");
        this.classFilterIncludes.setToolTipText("Class at the other end of the dependency must match any these expressions. E.g., /^com.mycompany/, /\\.get\\w+\\(/");
        this.featureFilterIncludes.setToolTipText("Method or field at the other end of the dependency must match any these expressions. E.g., /^com.mycompany/, /\\.get\\w+\\(/");
        this.filterExcludes.setToolTipText("Package, class, method, or field at the other end of the dependency must NOT match any of these expressions. E.g., /Test/");
        this.packageFilterExcludes.setToolTipText("Package at the other end of the dependency must NOT match any of these expressions. E.g., /Test/");
        this.classFilterExcludes.setToolTipText("Class at the other end of the dependency must NOT match any of these expressions. E.g., /Test/");
        this.featureFilterExcludes.setToolTipText("Method or field at the other end of the dependency must NOT match any of these expressions. E.g., /Test/");
        this.showInbounds.setToolTipText("Show dependencies that point to the selected packages, classes, methods, or fields");
        this.showOutbounds.setToolTipText("Show dependencies that originate from the selected packages, classes, methods, or fields");
        this.showEmptyNodes.setToolTipText("Show selected packages, classes, methods, and fields even if they do not have dependencies");
        this.copyOnly.setToolTipText("<html>Only copy explicit dependencies to the result graph.<br>Do not introduce implicit dependencies<br>where explicit dependencies match the regular expressions<br>but are otherwise out of scope</html>");
        this.showInbounds.setFont(this.getCodeFont(1, 14));
        this.showOutbounds.setFont(this.getCodeFont(1, 14));
        this.maximumInboundDepth.setToolTipText("Maximum hops against the direction dependencies.  Empty field means no limit.");
        this.maximumOutboundDepth.setToolTipText("Maximum hops in the direction of dependencies.  Empty field means no limit.");
        this.setAdvancedMode(false);
        this.buildMenus(commandLine);
        this.buildUI();
        try {
            UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
            SwingUtilities.updateComponentTreeUI(this);
        }
        catch (Exception ex) {
            Logger.getLogger(DependencyFinder.class).error((Object)"Unable to set look and feel", (Throwable)ex);
        }
        this.statusLine.showInfo("Ready.");
    }

    private Font getCodeFont(int style, int size) {
        String[] fontNames;
        String fontName = "Monospaced";
        for (String fontName1 : fontNames = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()) {
            if (fontName1.indexOf("Courier") == -1) continue;
            fontName = fontName1;
        }
        return new Font(fontName, style, size);
    }

    private boolean isAdvancedMode() {
        return this.advancedMode;
    }

    void setAdvancedMode(boolean advancedMode) {
        this.advancedMode = advancedMode;
        this.copyOnly.setVisible(advancedMode);
    }

    public boolean getMaximize() {
        return this.maximize;
    }

    private void setMaximize(boolean maximize) {
        this.maximize = maximize;
    }

    public boolean getMinimize() {
        return this.minimize;
    }

    private void setMinimize(boolean minimize) {
        this.minimize = minimize;
    }

    public ClassfileLoaderDispatcher getClassfileLoaderDispatcher() {
        return this.dispatcher;
    }

    private void setClassfileLoaderDispatcher(ClassfileLoaderDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    public Monitor getMonitor() {
        return this.monitor;
    }

    private void setMonitor(Monitor monitor) {
        this.monitor = monitor;
    }

    public Collection<String> getInputFiles() {
        return this.inputFiles;
    }

    private void setInputFiles(Collection<String> inputFiles) {
        this.inputFiles = inputFiles;
    }

    public void addInputFile(File file) {
        this.inputFiles.add(file.toString());
    }

    public Collection<PackageNode> getPackages() {
        return this.getNodeFactory().getPackages().values();
    }

    public NodeFactory getNodeFactory() {
        return this.nodeFactory;
    }

    private void setNodeFactory(NodeFactory nodeFactory) {
        this.nodeFactory = nodeFactory;
    }

    StatusLine getStatusLine() {
        return this.statusLine;
    }

    JProgressBar getProgressBar() {
        return this.progressBar;
    }

    private void buildMenus(CommandLine commandLine) {
        this.buildFileMenu(commandLine);
        this.buildViewMenu();
        this.buildHelpMenu();
        this.setJMenuBar(this.menuBar);
    }

    private void buildFileMenu(CommandLine commandLine) {
        this.menuBar.add(this.fileMenu);
        this.fileMenu.setText("File");
        AbstractAction action = new DependencyExtractAction(this);
        JMenuItem menuItem = this.fileMenu.add(action);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        menuItem.setMnemonic('e');
        JButton button = this.toolbar.add(action);
        button.setToolTipText((String)action.getValue("LongDescription"));
        action = new RefreshDependencyGraphAction(this);
        menuItem = this.fileMenu.add(action);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        menuItem.setMnemonic('r');
        button = this.toolbar.add(action);
        button.setToolTipText((String)action.getValue("LongDescription"));
        this.toolbar.addSeparator();
        this.fileMenu.addSeparator();
        action = new OpenFileAction(this);
        menuItem = this.fileMenu.add(action);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        menuItem.setMnemonic('o');
        button = this.toolbar.add(action);
        button.setToolTipText((String)action.getValue("LongDescription"));
        action = new SaveFileAction(this, commandLine.getSingleSwitch("encoding"), commandLine.getSingleSwitch("dtd-prefix"));
        menuItem = this.fileMenu.add(action);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        menuItem.setMnemonic('s');
        button = this.toolbar.add(action);
        button.setToolTipText((String)action.getValue("LongDescription"));
        if (commandLine.isPresent("indent-text")) {
            ((SaveFileAction)action).setIndentText(commandLine.getSingleSwitch("indent-text"));
        }
        this.toolbar.addSeparator();
        this.fileMenu.addSeparator();
        action = new NewDependencyGraphAction(this);
        menuItem = this.fileMenu.add(action);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        menuItem.setMnemonic('n');
        button = this.toolbar.add(action);
        button.setToolTipText((String)action.getValue("LongDescription"));
        this.toolbar.addSeparator();
        this.fileMenu.addSeparator();
        action = new DependencyQueryAction(this);
        menuItem = this.fileMenu.add(action);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(68, 2));
        menuItem.setMnemonic('d');
        button = this.toolbar.add(action);
        button.setToolTipText((String)action.getValue("LongDescription"));
        action = new ClosureQueryAction(this);
        menuItem = this.fileMenu.add(action);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        menuItem.setMnemonic('c');
        button = this.toolbar.add(action);
        button.setToolTipText((String)action.getValue("LongDescription"));
        action = new MetricsQueryAction(this);
        menuItem = this.fileMenu.add(action);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(77, 2));
        menuItem.setMnemonic('m');
        button = this.toolbar.add(action);
        button.setToolTipText((String)action.getValue("LongDescription"));
        action = new AllQueriesAction(this);
        menuItem = this.fileMenu.add(action);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        menuItem.setMnemonic('a');
        button = this.toolbar.add(action);
        button.setToolTipText((String)action.getValue("LongDescription"));
        this.toolbar.addSeparator();
        this.fileMenu.addSeparator();
        action = new ExitAction(this);
        menuItem = this.fileMenu.add(action);
        menuItem.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        menuItem.setMnemonic('x');
    }

    private void buildViewMenu() {
        this.menuBar.add(this.viewMenu);
        this.viewMenu.setText("View");
        ButtonGroup group = new ButtonGroup();
        JRadioButtonMenuItem menuItem = new JRadioButtonMenuItem(new SimpleQueryPanelAction(this));
        menuItem.setSelected(true);
        group.add(menuItem);
        this.viewMenu.add(menuItem);
        menuItem = new JRadioButtonMenuItem(new AdvancedQueryPanelAction(this));
        group.add(menuItem);
        this.viewMenu.add(menuItem);
    }

    private void buildHelpMenu() {
        this.menuBar.add(this.helpMenu);
        this.helpMenu.setText("Help");
        AboutAction action = new AboutAction(this);
        JMenuItem menuItem = this.helpMenu.add(action);
        menuItem.setMnemonic('a');
    }

    private void buildUI() {
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.buildControlPanel(), "North");
        this.getContentPane().add((Component)this.buildResultPanel(), "Center");
        this.getContentPane().add((Component)this.buildStatusPanel(), "South");
    }

    private JComponent buildControlPanel() {
        JPanel result = new JPanel();
        result.setLayout(new BorderLayout());
        result.add((Component)this.toolbar, "North");
        result.add((Component)this.buildQueryPanel(), "Center");
        return result;
    }

    JComponent buildQueryPanel() {
        if (this.isAdvancedMode()) {
            this.buildAdvancedQueryPanel();
        } else {
            this.buildSimpleQueryPanel();
        }
        return this.queryPanel;
    }

    private void buildSimpleQueryPanel() {
        this.queryPanel.removeAll();
        this.queryPanel.setLayout(new GridLayout(1, 2));
        this.queryPanel.add(this.buildSimpleScopePanel());
        this.queryPanel.add(this.buildSimpleFilterPanel());
        this.queryPanel.revalidate();
    }

    private void buildAdvancedQueryPanel() {
        this.queryPanel.removeAll();
        this.queryPanel.setLayout(new GridLayout(1, 2));
        this.queryPanel.add(this.buildAdvancedScopePanel());
        this.queryPanel.add(this.buildAdvancedFilterPanel());
        this.queryPanel.revalidate();
    }

    private JComponent buildSimpleScopePanel() {
        JPanel result = new JPanel();
        result.setBorder(BorderFactory.createTitledBorder("Select programming elements"));
        result.setLayout(new BorderLayout());
        result.add((Component)this.buildSimpleScopePanelCheckboxes(), "North");
        result.add((Component)this.buildSimpleScopePanelTextFields(), "South");
        return result;
    }

    private JComponent buildSimpleScopePanelTextFields() {
        JPanel result = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(0, 2, 0, 2);
        result.setLayout(gbl);
        JLabel scopeIncludesLabel = new JLabel("including:");
        c.anchor = 17;
        c.fill = 0;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        result.add(scopeIncludesLabel);
        gbl.setConstraints(scopeIncludesLabel, c);
        JLabel scopeExcludesLabel = new JLabel("excluding:");
        c.anchor = 17;
        c.fill = 0;
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        result.add(scopeExcludesLabel);
        gbl.setConstraints(scopeExcludesLabel, c);
        c.anchor = 17;
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        result.add(this.scopeIncludes);
        gbl.setConstraints(this.scopeIncludes, c);
        c.anchor = 17;
        c.fill = 2;
        c.gridx = 1;
        c.gridy = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        result.add(this.scopeExcludes);
        gbl.setConstraints(this.scopeExcludes, c);
        return result;
    }

    private JComponent buildSimpleScopePanelCheckboxes() {
        JPanel result = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(0, 2, 0, 2);
        result.setLayout(gbl);
        c.anchor = 13;
        c.fill = 0;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        result.add(this.packageScope);
        gbl.setConstraints(this.packageScope, c);
        c.anchor = 10;
        c.fill = 0;
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        result.add(this.classScope);
        gbl.setConstraints(this.classScope, c);
        c.anchor = 17;
        c.fill = 0;
        c.gridx = 2;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        result.add(this.featureScope);
        gbl.setConstraints(this.featureScope, c);
        return result;
    }

    private JComponent buildSimpleFilterPanel() {
        JPanel result = new JPanel();
        result.setBorder(BorderFactory.createTitledBorder("Show dependencies (stop for closure)"));
        result.setLayout(new BorderLayout());
        result.add((Component)this.buildSimpleFilterPanelCheckboxes(), "North");
        result.add((Component)this.buildSimpleFilterPanelTextFields(), "South");
        return result;
    }

    private JComponent buildSimpleFilterPanelTextFields() {
        JPanel result = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(0, 2, 0, 2);
        result.setLayout(gbl);
        JLabel filterIncludesLabel = new JLabel("including:");
        c.anchor = 17;
        c.fill = 0;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        result.add(filterIncludesLabel);
        gbl.setConstraints(filterIncludesLabel, c);
        JLabel filterExcludesLabel = new JLabel("excluding:");
        c.anchor = 17;
        c.fill = 0;
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        result.add(filterExcludesLabel);
        gbl.setConstraints(filterExcludesLabel, c);
        c.anchor = 17;
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        result.add(this.filterIncludes);
        gbl.setConstraints(this.filterIncludes, c);
        c.anchor = 17;
        c.fill = 2;
        c.gridx = 1;
        c.gridy = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        result.add(this.filterExcludes);
        gbl.setConstraints(this.filterExcludes, c);
        return result;
    }

    private JComponent buildSimpleFilterPanelCheckboxes() {
        JPanel result = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(0, 2, 0, 2);
        result.setLayout(gbl);
        c.anchor = 13;
        c.fill = 0;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        result.add(this.packageFilter);
        gbl.setConstraints(this.packageFilter, c);
        c.anchor = 10;
        c.fill = 0;
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        result.add(this.classFilter);
        gbl.setConstraints(this.classFilter, c);
        c.anchor = 17;
        c.fill = 0;
        c.gridx = 2;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        result.add(this.featureFilter);
        gbl.setConstraints(this.featureFilter, c);
        return result;
    }

    private JComponent buildAdvancedScopePanel() {
        JPanel result = new JPanel();
        result.setBorder(BorderFactory.createTitledBorder("Select programming elements"));
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 0, 2, 5);
        result.setLayout(gbl);
        c.anchor = 17;
        c.fill = 0;
        c.gridx = 0;
        c.gridy = 2;
        c.weightx = 0.0;
        c.weighty = 0.0;
        result.add(this.packageScope);
        gbl.setConstraints(this.packageScope, c);
        c.anchor = 17;
        c.fill = 0;
        c.gridx = 0;
        c.gridy = 3;
        c.weightx = 0.0;
        c.weighty = 0.0;
        result.add(this.classScope);
        gbl.setConstraints(this.classScope, c);
        c.anchor = 17;
        c.fill = 0;
        c.gridx = 0;
        c.gridy = 4;
        c.weightx = 0.0;
        c.weighty = 0.0;
        result.add(this.featureScope);
        gbl.setConstraints(this.featureScope, c);
        JLabel scopeIncludesLabel = new JLabel("including:");
        c.anchor = 17;
        c.fill = 0;
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        result.add(scopeIncludesLabel);
        gbl.setConstraints(scopeIncludesLabel, c);
        c.anchor = 17;
        c.fill = 2;
        c.gridx = 1;
        c.gridy = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        result.add(this.scopeIncludes);
        gbl.setConstraints(this.scopeIncludes, c);
        c.anchor = 17;
        c.fill = 2;
        c.gridx = 1;
        c.gridy = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        result.add(this.packageScopeIncludes);
        gbl.setConstraints(this.packageScopeIncludes, c);
        c.anchor = 17;
        c.fill = 2;
        c.gridx = 1;
        c.gridy = 3;
        c.weightx = 1.0;
        c.weighty = 0.0;
        result.add(this.classScopeIncludes);
        gbl.setConstraints(this.classScopeIncludes, c);
        c.anchor = 17;
        c.fill = 2;
        c.gridx = 1;
        c.gridy = 4;
        c.weightx = 1.0;
        c.weighty = 0.0;
        result.add(this.featureScopeIncludes);
        gbl.setConstraints(this.featureScopeIncludes, c);
        JLabel scopeExcludesLabel = new JLabel("excluding:");
        c.anchor = 17;
        c.fill = 0;
        c.gridx = 2;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        result.add(scopeExcludesLabel);
        gbl.setConstraints(scopeExcludesLabel, c);
        c.anchor = 17;
        c.fill = 2;
        c.gridx = 2;
        c.gridy = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        result.add(this.scopeExcludes);
        gbl.setConstraints(this.scopeExcludes, c);
        c.anchor = 17;
        c.fill = 2;
        c.gridx = 2;
        c.gridy = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        result.add(this.packageScopeExcludes);
        gbl.setConstraints(this.packageScopeExcludes, c);
        c.anchor = 17;
        c.fill = 2;
        c.gridx = 2;
        c.gridy = 3;
        c.weightx = 1.0;
        c.weighty = 0.0;
        result.add(this.classScopeExcludes);
        gbl.setConstraints(this.classScopeExcludes, c);
        c.anchor = 17;
        c.fill = 2;
        c.gridx = 2;
        c.gridy = 4;
        c.weightx = 1.0;
        c.weighty = 0.0;
        result.add(this.featureScopeExcludes);
        gbl.setConstraints(this.featureScopeExcludes, c);
        return result;
    }

    private JComponent buildAdvancedFilterPanel() {
        JPanel result = new JPanel();
        result.setBorder(BorderFactory.createTitledBorder("Show dependencies (stop for closure)"));
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 0, 2, 5);
        result.setLayout(gbl);
        c.anchor = 17;
        c.fill = 0;
        c.gridx = 0;
        c.gridy = 2;
        c.weightx = 0.0;
        c.weighty = 0.0;
        result.add(this.packageFilter);
        gbl.setConstraints(this.packageFilter, c);
        c.anchor = 17;
        c.fill = 0;
        c.gridx = 0;
        c.gridy = 3;
        c.weightx = 0.0;
        c.weighty = 0.0;
        result.add(this.classFilter);
        gbl.setConstraints(this.classFilter, c);
        c.anchor = 17;
        c.fill = 0;
        c.gridx = 0;
        c.gridy = 4;
        c.weightx = 0.0;
        c.weighty = 0.0;
        result.add(this.featureFilter);
        gbl.setConstraints(this.featureFilter, c);
        JLabel filterIncludesLabel = new JLabel("including:");
        c.anchor = 17;
        c.fill = 0;
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        result.add(filterIncludesLabel);
        gbl.setConstraints(filterIncludesLabel, c);
        c.anchor = 17;
        c.fill = 2;
        c.gridx = 1;
        c.gridy = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        result.add(this.filterIncludes);
        gbl.setConstraints(this.filterIncludes, c);
        c.anchor = 17;
        c.fill = 2;
        c.gridx = 1;
        c.gridy = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        result.add(this.packageFilterIncludes);
        gbl.setConstraints(this.packageFilterIncludes, c);
        c.anchor = 17;
        c.fill = 2;
        c.gridx = 1;
        c.gridy = 3;
        c.weightx = 1.0;
        c.weighty = 0.0;
        result.add(this.classFilterIncludes);
        gbl.setConstraints(this.classFilterIncludes, c);
        c.anchor = 17;
        c.fill = 2;
        c.gridx = 1;
        c.gridy = 4;
        c.weightx = 1.0;
        c.weighty = 0.0;
        result.add(this.featureFilterIncludes);
        gbl.setConstraints(this.featureFilterIncludes, c);
        JLabel filterExcludesLabel = new JLabel("excluding:");
        c.anchor = 17;
        c.fill = 0;
        c.gridx = 2;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        result.add(filterExcludesLabel);
        gbl.setConstraints(filterExcludesLabel, c);
        c.anchor = 17;
        c.fill = 2;
        c.gridx = 2;
        c.gridy = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        result.add(this.filterExcludes);
        gbl.setConstraints(this.filterExcludes, c);
        c.anchor = 17;
        c.fill = 2;
        c.gridx = 2;
        c.gridy = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        result.add(this.packageFilterExcludes);
        gbl.setConstraints(this.packageFilterExcludes, c);
        c.anchor = 17;
        c.fill = 2;
        c.gridx = 2;
        c.gridy = 3;
        c.weightx = 1.0;
        c.weighty = 0.0;
        result.add(this.classFilterExcludes);
        gbl.setConstraints(this.classFilterExcludes, c);
        c.anchor = 17;
        c.fill = 2;
        c.gridx = 2;
        c.gridy = 4;
        c.weightx = 1.0;
        c.weighty = 0.0;
        result.add(this.featureFilterExcludes);
        gbl.setConstraints(this.featureFilterExcludes, c);
        return result;
    }

    private JComponent buildResultPanel() {
        JTabbedPane result = new JTabbedPane();
        result.setBorder(BorderFactory.createTitledBorder("Results"));
        result.addTab("Dependencies", this.buildDependenciesPanel());
        result.addTab("Closure", this.buildClosurePanel());
        result.addTab("Metrics", this.buildMetricsPanel());
        return result;
    }

    private JComponent buildDependenciesPanel() {
        JPanel result = new JPanel();
        result.setLayout(new BorderLayout());
        result.add((Component)this.buildPrinterControlPanel(), "North");
        result.add((Component)this.buildDependenciesResultPanel(), "Center");
        return result;
    }

    private JComponent buildPrinterControlPanel() {
        JPanel result = new JPanel();
        result.add(new JLabel("Show "));
        result.add(this.showInbounds);
        result.add(this.showOutbounds);
        result.add(this.showEmptyNodes);
        result.add(this.copyOnly);
        PrinterControlAction action = new PrinterControlAction(this);
        this.showInbounds.addActionListener(action);
        this.showOutbounds.addActionListener(action);
        this.showEmptyNodes.addActionListener(action);
        return result;
    }

    private JComponent buildDependenciesResultPanel() {
        JScrollPane result = new JScrollPane(this.dependenciesResultArea);
        this.dependenciesResultArea.setEditable(false);
        this.dependenciesResultArea.setFont(this.getCodeFont(0, 12));
        return result;
    }

    private JComponent buildClosurePanel() {
        JPanel result = new JPanel();
        result.setLayout(new BorderLayout());
        result.add((Component)this.buildClosureControlPanel(), "North");
        result.add((Component)this.buildClosureResultPanel(), "Center");
        return result;
    }

    private JComponent buildClosureControlPanel() {
        JPanel result = new JPanel();
        result.add(new JLabel("Follow inbounds: "));
        result.add(this.maximumInboundDepth);
        result.add(new JLabel("Follow outbounds: "));
        result.add(this.maximumOutboundDepth);
        return result;
    }

    private JComponent buildClosureResultPanel() {
        JScrollPane result = new JScrollPane(this.closureResultArea);
        this.closureResultArea.setEditable(false);
        this.closureResultArea.setFont(this.getCodeFont(0, 12));
        return result;
    }

    private JComponent buildMetricsPanel() {
        return new JSplitPane(0, this.buildMetricsResultPanel(), this.buildMetricsChartPanel());
    }

    private JComponent buildMetricsResultPanel() {
        JScrollPane result = new JScrollPane(this.metricsResultArea);
        this.metricsResultArea.setEditable(false);
        return result;
    }

    private JComponent buildMetricsChartPanel() {
        JTable table = new JTable(this.metricsChartModel);
        table.setCellSelectionEnabled(true);
        table.setColumnSelectionAllowed(true);
        JScrollPane result = new JScrollPane(table);
        return result;
    }

    private JComponent buildStatusPanel() {
        JPanel result = new JPanel();
        Dimension size = this.getProgressBar().getPreferredSize();
        size.width = 100;
        this.getProgressBar().setPreferredSize(size);
        this.getProgressBar().setBorder(BorderFactory.createBevelBorder(1));
        result.setLayout(new BorderLayout());
        result.add((Component)this.getStatusLine(), "Center");
        result.add((Component)this.getProgressBar(), "East");
        return result;
    }

    public void resetQuery() {
        this.packageScope.setSelected(true);
        this.classScope.setSelected(false);
        this.featureScope.setSelected(false);
        this.scopeIncludes.setText("//");
        this.packageScopeIncludes.setText("");
        this.classScopeIncludes.setText("");
        this.featureScopeIncludes.setText("");
        this.scopeExcludes.setText("");
        this.packageScopeExcludes.setText("");
        this.classScopeExcludes.setText("");
        this.featureScopeExcludes.setText("");
        this.packageFilter.setSelected(true);
        this.classFilter.setSelected(false);
        this.featureFilter.setSelected(false);
        this.filterIncludes.setText("//");
        this.packageFilterIncludes.setText("");
        this.classFilterIncludes.setText("");
        this.featureFilterIncludes.setText("");
        this.filterExcludes.setText("");
        this.packageFilterExcludes.setText("");
        this.classFilterExcludes.setText("");
        this.featureFilterExcludes.setText("");
        this.showInbounds.setSelected(true);
        this.showOutbounds.setSelected(true);
        this.showEmptyNodes.setSelected(true);
        this.copyOnly.setSelected(false);
    }

    void clearDependencyResult() {
        this.dependenciesQuery = null;
        this.dependenciesResultArea.setText("");
    }

    void doDependencyQuery() {
        RegularExpressionSelectionCriteria scopeCriteria = new RegularExpressionSelectionCriteria();
        scopeCriteria.setMatchingPackages(this.packageScope.isSelected());
        scopeCriteria.setMatchingClasses(this.classScope.isSelected());
        scopeCriteria.setMatchingFeatures(this.featureScope.isSelected());
        scopeCriteria.setGlobalIncludes(this.scopeIncludes.getText());
        scopeCriteria.setGlobalExcludes(this.scopeExcludes.getText());
        if (this.isAdvancedMode()) {
            scopeCriteria.setPackageIncludes(this.packageScopeIncludes.getText());
            scopeCriteria.setClassIncludes(this.classScopeIncludes.getText());
            scopeCriteria.setFeatureIncludes(this.featureScopeIncludes.getText());
            scopeCriteria.setPackageExcludes(this.packageScopeExcludes.getText());
            scopeCriteria.setClassExcludes(this.classScopeExcludes.getText());
            scopeCriteria.setFeatureExcludes(this.featureScopeExcludes.getText());
        }
        RegularExpressionSelectionCriteria filterCriteria = new RegularExpressionSelectionCriteria();
        filterCriteria.setMatchingPackages(this.packageFilter.isSelected());
        filterCriteria.setMatchingClasses(this.classFilter.isSelected());
        filterCriteria.setMatchingFeatures(this.featureFilter.isSelected());
        filterCriteria.setGlobalIncludes(this.filterIncludes.getText());
        filterCriteria.setGlobalExcludes(this.filterExcludes.getText());
        if (this.isAdvancedMode()) {
            filterCriteria.setPackageIncludes(this.packageFilterIncludes.getText());
            filterCriteria.setClassIncludes(this.classFilterIncludes.getText());
            filterCriteria.setFeatureIncludes(this.featureFilterIncludes.getText());
            filterCriteria.setPackageExcludes(this.packageFilterExcludes.getText());
            filterCriteria.setClassExcludes(this.classFilterExcludes.getText());
            filterCriteria.setFeatureExcludes(this.featureFilterExcludes.getText());
        }
        if (this.isAdvancedMode() && this.copyOnly.isSelected() || this.getMaximize()) {
            SelectiveTraversalStrategy strategy = new SelectiveTraversalStrategy(scopeCriteria, filterCriteria);
            this.dependenciesQuery = new GraphCopier(strategy);
        } else {
            this.dependenciesQuery = new GraphSummarizer(scopeCriteria, filterCriteria);
        }
        this.dependenciesQuery.traverseNodes(this.getPackages());
        this.refreshDependenciesDisplay();
    }

    void refreshDependenciesDisplay() {
        if (this.dependenciesQuery != null) {
            StringWriter out = new StringWriter();
            TextPrinter printer = new TextPrinter(new PrintWriter(out));
            printer.setShowInbounds(this.showInbounds.isSelected());
            printer.setShowOutbounds(this.showOutbounds.isSelected());
            printer.setShowEmptyNodes(this.showEmptyNodes.isSelected());
            printer.traverseNodes(this.dependenciesQuery.getScopeFactory().getPackages().values());
            this.dependenciesResultArea.setText(out.toString());
        }
    }

    void clearClosureResult() {
        this.closureResultArea.setText("");
    }

    void doClosureQuery() {
        RegularExpressionSelectionCriteria startCriteria = new RegularExpressionSelectionCriteria();
        startCriteria.setGlobalIncludes(this.scopeIncludes.getText());
        startCriteria.setGlobalExcludes(this.scopeExcludes.getText());
        if (this.isAdvancedMode()) {
            startCriteria.setPackageIncludes(this.packageScopeIncludes.getText());
            startCriteria.setClassIncludes(this.classScopeIncludes.getText());
            startCriteria.setFeatureIncludes(this.featureScopeIncludes.getText());
            startCriteria.setPackageExcludes(this.packageScopeExcludes.getText());
            startCriteria.setClassExcludes(this.classScopeExcludes.getText());
            startCriteria.setFeatureExcludes(this.featureScopeExcludes.getText());
        }
        RegularExpressionSelectionCriteria stopCriteria = new RegularExpressionSelectionCriteria();
        stopCriteria.setGlobalIncludes(this.filterIncludes.getText());
        stopCriteria.setGlobalExcludes(this.filterExcludes.getText());
        if (this.isAdvancedMode()) {
            stopCriteria.setPackageIncludes(this.packageFilterIncludes.getText());
            stopCriteria.setClassIncludes(this.classFilterIncludes.getText());
            stopCriteria.setFeatureIncludes(this.featureFilterIncludes.getText());
            stopCriteria.setPackageExcludes(this.packageFilterExcludes.getText());
            stopCriteria.setClassExcludes(this.classFilterExcludes.getText());
            stopCriteria.setFeatureExcludes(this.featureFilterExcludes.getText());
        }
        TransitiveClosure selector = new TransitiveClosure(startCriteria, stopCriteria);
        try {
            selector.setMaximumInboundDepth(Long.parseLong(this.maximumInboundDepth.getText()));
        }
        catch (NumberFormatException ex) {
            selector.setMaximumInboundDepth(Long.MAX_VALUE);
        }
        try {
            selector.setMaximumOutboundDepth(Long.parseLong(this.maximumOutboundDepth.getText()));
        }
        catch (NumberFormatException ex) {
            selector.setMaximumOutboundDepth(Long.MAX_VALUE);
        }
        selector.traverseNodes(this.getPackages());
        RegularExpressionSelectionCriteria scopeCriteria = new RegularExpressionSelectionCriteria();
        scopeCriteria.setMatchingPackages(this.packageScope.isSelected());
        scopeCriteria.setMatchingClasses(this.classScope.isSelected());
        scopeCriteria.setMatchingFeatures(this.featureScope.isSelected());
        scopeCriteria.setGlobalIncludes("//");
        RegularExpressionSelectionCriteria filterCriteria = new RegularExpressionSelectionCriteria();
        filterCriteria.setMatchingPackages(this.packageFilter.isSelected());
        filterCriteria.setMatchingClasses(this.classFilter.isSelected());
        filterCriteria.setMatchingFeatures(this.featureFilter.isSelected());
        filterCriteria.setGlobalIncludes("//");
        GraphSummarizer summarizer = new GraphSummarizer(scopeCriteria, filterCriteria);
        summarizer.traverseNodes(selector.getFactory().getPackages().values());
        StringWriter out = new StringWriter();
        TextPrinter printer = new TextPrinter(new PrintWriter(out));
        printer.traverseNodes(summarizer.getScopeFactory().getPackages().values());
        this.closureResultArea.setText(out.toString());
    }

    void clearMetricsResult() {
        this.metricsResultArea.setText("");
    }

    void doMetricsQuery() {
        RegularExpressionSelectionCriteria scopeCriteria = new RegularExpressionSelectionCriteria();
        scopeCriteria.setMatchingPackages(this.packageScope.isSelected());
        scopeCriteria.setMatchingClasses(this.classScope.isSelected());
        scopeCriteria.setMatchingFeatures(this.featureScope.isSelected());
        scopeCriteria.setGlobalIncludes(this.scopeIncludes.getText());
        scopeCriteria.setGlobalExcludes(this.scopeExcludes.getText());
        if (this.isAdvancedMode()) {
            scopeCriteria.setPackageIncludes(this.packageScopeIncludes.getText());
            scopeCriteria.setClassIncludes(this.classScopeIncludes.getText());
            scopeCriteria.setFeatureIncludes(this.featureScopeIncludes.getText());
            scopeCriteria.setPackageExcludes(this.packageScopeExcludes.getText());
            scopeCriteria.setClassExcludes(this.classScopeExcludes.getText());
            scopeCriteria.setFeatureExcludes(this.featureScopeExcludes.getText());
        }
        RegularExpressionSelectionCriteria filterCriteria = new RegularExpressionSelectionCriteria();
        filterCriteria.setMatchingPackages(this.packageFilter.isSelected());
        filterCriteria.setMatchingClasses(this.classFilter.isSelected());
        filterCriteria.setMatchingFeatures(this.featureFilter.isSelected());
        filterCriteria.setGlobalIncludes(this.filterIncludes.getText());
        filterCriteria.setGlobalExcludes(this.filterExcludes.getText());
        if (this.isAdvancedMode()) {
            filterCriteria.setPackageIncludes(this.packageFilterIncludes.getText());
            filterCriteria.setClassIncludes(this.classFilterIncludes.getText());
            filterCriteria.setFeatureIncludes(this.featureFilterIncludes.getText());
            filterCriteria.setPackageExcludes(this.packageFilterExcludes.getText());
            filterCriteria.setClassExcludes(this.classFilterExcludes.getText());
            filterCriteria.setFeatureExcludes(this.featureFilterExcludes.getText());
        }
        SelectiveTraversalStrategy strategy = new SelectiveTraversalStrategy(scopeCriteria, filterCriteria);
        MetricsGatherer metrics = new MetricsGatherer(strategy);
        metrics.traverseNodes(this.getPackages());
        StringWriter out = new StringWriter();
        MetricsReport report = new MetricsReport(new PrintWriter(out));
        report.process(metrics);
        this.metricsResultArea.setText(out.toString());
        this.metricsChartModel.setMetrics(metrics);
    }

    void setNewDependencyGraph() {
        this.setInputFiles(new LinkedList<String>());
        this.setClassfileLoaderDispatcher(new ModifiedOnlyDispatcher(ClassfileLoaderEventSource.DEFAULT_DISPATCHER));
        NodeFactory factory = new NodeFactory();
        this.setNodeFactory(factory);
        CodeDependencyCollector collector = new CodeDependencyCollector(factory);
        DeletingVisitor deletingVisitor = new DeletingVisitor(factory);
        this.setMonitor(new Monitor(collector, deletingVisitor));
        this.resetQuery();
    }

    public static void showError(CommandLineUsage clu, String msg) {
        System.err.println(msg);
        DependencyFinder.showError(clu);
    }

    public static void showError(CommandLineUsage clu) {
        System.err.println(clu);
    }

    public static void main(String[] args) {
        CommandLine commandLine = new CommandLine(new NullParameterStrategy());
        commandLine.addToggleSwitch("minimize");
        commandLine.addToggleSwitch("maximize");
        commandLine.addSingleValueSwitch("encoding", "utf-8");
        commandLine.addSingleValueSwitch("dtd-prefix", "http://depfind.sourceforge.net/dtd");
        commandLine.addSingleValueSwitch("indent-text", "    ");
        commandLine.addToggleSwitch("help");
        CommandLineUsage usage = new CommandLineUsage("DependencyFinder");
        commandLine.accept(usage);
        try {
            commandLine.parse(args);
        }
        catch (IllegalArgumentException ex) {
            DependencyFinder.showError(usage, ex.toString());
            System.exit(1);
        }
        if (commandLine.getToggleSwitch("help")) {
            DependencyFinder.showError(usage);
            System.exit(1);
        }
        if (commandLine.getToggleSwitch("maximize") && commandLine.getToggleSwitch("minimize")) {
            DependencyFinder.showError(usage, "Only one of -maximize or -minimize allowed");
        }
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception ex) {
            // empty catch block
        }
        DependencyFinder model = new DependencyFinder(commandLine);
        model.setMaximize(commandLine.getToggleSwitch("maximize"));
        model.setMinimize(commandLine.getToggleSwitch("minimize"));
        model.setVisible(true);
    }
}

