/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.metrics;

import java.util.StringTokenizer;

public class WordCounter {
    public int countPackageName(String packageName) {
        return new StringTokenizer(packageName, ".").countTokens();
    }

    public int countIdentifier(String identifier) {
        int result = 0;
        int pos = identifier.lastIndexOf("$");
        identifier = identifier.substring(pos + 1);
        switch (identifier.length()) {
            case 0: {
                break;
            }
            case 1: {
                result = 1;
                break;
            }
            default: {
                result = 1;
                int p1 = 0;
                for (int p2 = 1; p2 < identifier.length(); ++p2) {
                    char ch2;
                    char ch1 = identifier.charAt(p1);
                    if (this.isBeginWordTransition(ch1, ch2 = identifier.charAt(p2))) {
                        if (p2 - p1 > 1) {
                            ++result;
                        }
                        p1 = p2;
                        continue;
                    }
                    if (this.isEndWordTransition(ch1, ch2)) {
                        ++result;
                    }
                    if (this.isUpperCase(ch1)) continue;
                    ++p1;
                }
            }
        }
        return result;
    }

    private boolean isBeginWordTransition(char ch1, char ch2) {
        return this.isUpperCase(ch1) && !this.isUpperCase(ch2) || ch1 == '_' && this.isUpperCase(ch2);
    }

    private boolean isEndWordTransition(char ch1, char ch2) {
        return !this.isUpperCase(ch1) && this.isUpperCase(ch2) || this.isUpperCase(ch1) && ch2 == '_';
    }

    private boolean isUpperCase(char ch) {
        return Character.isLetterOrDigit(ch) && Character.isUpperCase(ch);
    }
}

