/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.examples.resolution;

import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.NiftyEventSubscriber;
import de.lessvoid.nifty.controls.DropDown;
import de.lessvoid.nifty.controls.DropDownSelectionChangedEvent;
import de.lessvoid.nifty.controls.ListBox;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.screen.ScreenController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;

public class ResolutionScreen
implements ScreenController {
    private Nifty nifty;
    private Screen screen;
    private DropDown<DisplayMode> dropDown;
    private ListBox<String> listBox;

    public void bind(Nifty newNifty, Screen newScreen) {
        this.nifty = newNifty;
        this.screen = newScreen;
        this.dropDown = (DropDown)this.screen.findNiftyControl("resolutions", DropDown.class);
        this.listBox = (ListBox)this.screen.findNiftyControl("listBox", ListBox.class);
        this.fillResolutionDropDown(this.screen);
        this.dropDown.selectItem((Object)Display.getDisplayMode());
        this.listBox.addItem((Object)"Test");
        this.listBox.addItem((Object)"TestTestTestTestTestTestTestTestTestTestTestTest");
        this.listBox.selectItem((Object)"Test");
    }

    public void onStartScreen() {
    }

    public void onEndScreen() {
    }

    @NiftyEventSubscriber(id="resolutions")
    public void onResolution(String id, DropDownSelectionChangedEvent<DisplayMode> event) {
        DisplayMode displayMode = (DisplayMode)event.getSelection();
        try {
            Display.setDisplayMode((DisplayMode)displayMode);
            GL11.glMatrixMode((int)5889);
            GL11.glLoadIdentity();
            GL11.glOrtho((double)0.0, (double)displayMode.getWidth(), (double)displayMode.getHeight(), (double)0.0, (double)-9999.0, (double)9999.0);
            GL11.glMatrixMode((int)5888);
            this.nifty.resolutionChanged();
        }
        catch (LWJGLException e) {
            e.printStackTrace();
        }
    }

    private void fillResolutionDropDown(Screen screen) {
        try {
            DisplayMode currentMode = Display.getDisplayMode();
            ArrayList<DisplayMode> sorted = new ArrayList<DisplayMode>();
            DisplayMode[] modes = Display.getAvailableDisplayModes();
            for (int i = 0; i < modes.length; ++i) {
                DisplayMode mode = modes[i];
                if (mode.getBitsPerPixel() != 32 || mode.getFrequency() != currentMode.getFrequency()) continue;
                sorted.add(mode);
            }
            Collections.sort(sorted, new Comparator<DisplayMode>(){

                @Override
                public int compare(DisplayMode o1, DisplayMode o2) {
                    int widthCompare = Integer.valueOf(o1.getWidth()).compareTo(o2.getWidth());
                    if (widthCompare != 0) {
                        return widthCompare;
                    }
                    int heightCompare = Integer.valueOf(o1.getHeight()).compareTo(o2.getHeight());
                    if (heightCompare != 0) {
                        return heightCompare;
                    }
                    return o1.toString().compareTo(o2.toString());
                }
            });
            for (DisplayMode mode : sorted) {
                this.dropDown.addItem((Object)mode);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

