/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.helpers.v249;

import com.jme3.material.Material;
import com.jme3.math.FastMath;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.plugins.blender.data.Structure;
import com.jme3.scene.plugins.blender.exception.BlenderFileException;
import com.jme3.scene.plugins.blender.helpers.v249.ArmatureHelper;
import com.jme3.scene.plugins.blender.helpers.v249.MaterialHelper;
import com.jme3.scene.plugins.blender.helpers.v249.TextureHelper;
import com.jme3.scene.plugins.blender.utils.AbstractBlenderHelper;
import com.jme3.scene.plugins.blender.utils.DataRepository;
import com.jme3.scene.plugins.blender.utils.DynamicArray;
import com.jme3.scene.plugins.blender.utils.Pointer;
import com.jme3.texture.Texture;
import com.jme3.util.BufferUtils;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MeshHelper
extends AbstractBlenderHelper {
    protected static final int MAXIMUM_WEIGHTS_PER_VERTEX = 4;

    public MeshHelper(String blenderVersion) {
        super(blenderVersion);
    }

    public List<Geometry> toMesh(Structure structure, DataRepository dataRepository) throws BlenderFileException {
        ArrayList<Geometry> geometries = (ArrayList<Geometry>)dataRepository.getLoadedFeature(structure.getOldMemoryAddress(), DataRepository.LoadedFeatureDataType.LOADED_FEATURE);
        if (geometries != null) {
            ArrayList<Geometry> copiedGeometries = new ArrayList<Geometry>(geometries.size());
            for (Geometry geometry : geometries) {
                copiedGeometries.add(geometry.clone());
            }
            return copiedGeometries;
        }
        TextureHelper textureHelper = (TextureHelper)dataRepository.getHelper(TextureHelper.class);
        String name = structure.getName();
        Vector3f[] vertices = this.getVertices(structure, dataRepository);
        int verticesAmount = vertices.length;
        List<float[]> verticesColors = this.getVerticesColors(structure, dataRepository);
        HashMap meshesMap = new HashMap();
        Pointer pMFace = (Pointer)structure.getFieldValue("mface");
        List<Structure> mFaces = pMFace.fetchData(dataRepository.getInputStream());
        Pointer pMTFace = (Pointer)structure.getFieldValue("mtface");
        ArrayList<Vector2f> uvCoordinates = null;
        List<Structure> mtFaces = null;
        if (!pMTFace.isNull()) {
            mtFaces = pMTFace.fetchData(dataRepository.getInputStream());
            int facesAmount = ((Number)structure.getFieldValue("totface")).intValue();
            if (mtFaces.size() != facesAmount) {
                throw new BlenderFileException("The amount of faces uv coordinates is not equal to faces amount!");
            }
            uvCoordinates = new ArrayList<Vector2f>();
        }
        HashMap<Vector3f, Vector3f> normalMap = new HashMap<Vector3f, Vector3f>(verticesAmount);
        ArrayList normalList = new ArrayList();
        ArrayList<Vector3f> vertexList = new ArrayList<Vector3f>();
        HashMap<Integer, Texture> materialNumberToTexture = new HashMap<Integer, Texture>();
        HashMap<Integer, List<Integer>> vertexReferenceMap = new HashMap<Integer, List<Integer>>(verticesAmount);
        int vertexColorIndex = 0;
        for (int i = 0; i < mFaces.size(); ++i) {
            Texture texture;
            Structure mFace = mFaces.get(i);
            boolean smooth = (((Number)mFace.getFieldValue("flag")).byteValue() & 1) != 0;
            DynamicArray uvs = null;
            boolean materialWithoutTextures = false;
            Pointer pImage = null;
            if (mtFaces != null) {
                Structure mtFace = mtFaces.get(i);
                pImage = (Pointer)mtFace.getFieldValue("tpage");
                materialWithoutTextures = pImage.isNull();
                uvs = (DynamicArray)mtFace.getFieldValue("uv");
                uvCoordinates.add(new Vector2f(((Number)uvs.get(0, 0)).floatValue(), ((Number)uvs.get(0, 1)).floatValue()));
                uvCoordinates.add(new Vector2f(((Number)uvs.get(1, 0)).floatValue(), ((Number)uvs.get(1, 1)).floatValue()));
                uvCoordinates.add(new Vector2f(((Number)uvs.get(2, 0)).floatValue(), ((Number)uvs.get(2, 1)).floatValue()));
            }
            int matNr = ((Number)mFace.getFieldValue("mat_nr")).intValue();
            Integer materialNumber = materialWithoutTextures ? -1 * matNr - 1 : matNr;
            ArrayList<Integer> indexList = (ArrayList<Integer>)meshesMap.get(materialNumber);
            if (indexList == null) {
                indexList = new ArrayList<Integer>();
                meshesMap.put(materialNumber, indexList);
            }
            if (pImage != null && !pImage.isNull() && !materialNumberToTexture.containsKey(materialNumber) && (texture = textureHelper.getTextureFromImage(pImage.fetchData(dataRepository.getInputStream()).get(0), dataRepository)) != null) {
                materialNumberToTexture.put(materialNumber, texture);
            }
            int v1 = ((Number)mFace.getFieldValue("v1")).intValue();
            int v2 = ((Number)mFace.getFieldValue("v2")).intValue();
            int v3 = ((Number)mFace.getFieldValue("v3")).intValue();
            int v4 = ((Number)mFace.getFieldValue("v4")).intValue();
            Vector3f n = FastMath.computeNormal((Vector3f)vertices[v1], (Vector3f)vertices[v2], (Vector3f)vertices[v3]);
            this.addNormal(n, normalMap, smooth, vertices[v1], vertices[v2], vertices[v3]);
            normalList.add(normalMap.get(vertices[v1]));
            normalList.add(normalMap.get(vertices[v2]));
            normalList.add(normalMap.get(vertices[v3]));
            this.appendVertexReference(v1, vertexList.size(), vertexReferenceMap);
            indexList.add(vertexList.size());
            vertexList.add(vertices[v1]);
            this.appendVertexReference(v2, vertexList.size(), vertexReferenceMap);
            indexList.add(vertexList.size());
            vertexList.add(vertices[v2]);
            this.appendVertexReference(v3, vertexList.size(), vertexReferenceMap);
            indexList.add(vertexList.size());
            vertexList.add(vertices[v3]);
            if (v4 > 0) {
                if (uvs != null) {
                    uvCoordinates.add(new Vector2f(((Number)uvs.get(0, 0)).floatValue(), ((Number)uvs.get(0, 1)).floatValue()));
                    uvCoordinates.add(new Vector2f(((Number)uvs.get(2, 0)).floatValue(), ((Number)uvs.get(2, 1)).floatValue()));
                    uvCoordinates.add(new Vector2f(((Number)uvs.get(3, 0)).floatValue(), ((Number)uvs.get(3, 1)).floatValue()));
                }
                this.appendVertexReference(v1, vertexList.size(), vertexReferenceMap);
                indexList.add(vertexList.size());
                vertexList.add(vertices[v1]);
                this.appendVertexReference(v3, vertexList.size(), vertexReferenceMap);
                indexList.add(vertexList.size());
                vertexList.add(vertices[v3]);
                this.appendVertexReference(v4, vertexList.size(), vertexReferenceMap);
                indexList.add(vertexList.size());
                vertexList.add(vertices[v4]);
                this.addNormal(n, normalMap, smooth, vertices[v4]);
                normalList.add(normalMap.get(vertices[v1]));
                normalList.add(normalMap.get(vertices[v3]));
                normalList.add(normalMap.get(vertices[v4]));
                if (verticesColors != null) {
                    verticesColors.add(vertexColorIndex + 3, verticesColors.get(vertexColorIndex));
                    verticesColors.add(vertexColorIndex + 4, verticesColors.get(vertexColorIndex + 2));
                }
                vertexColorIndex += 6;
                continue;
            }
            if (verticesColors == null) continue;
            verticesColors.remove(vertexColorIndex + 3);
            vertexColorIndex += 3;
        }
        Vector3f[] normals = normalList.toArray(new Vector3f[normalList.size()]);
        Structure parent = dataRepository.peekParent();
        Structure defbase = (Structure)parent.getFieldValue("defbase");
        List<Structure> defs = defbase.evaluateListBase(dataRepository);
        String[] verticesGroups = new String[defs.size()];
        int defIndex = 0;
        for (Structure def : defs) {
            verticesGroups[defIndex++] = def.getFieldValue("name").toString();
        }
        ArmatureHelper armatureHelper = (ArmatureHelper)dataRepository.getHelper(ArmatureHelper.class);
        Structure defBase = (Structure)parent.getFieldValue("defbase");
        Map<Integer, Integer> groupToBoneIndexMap = armatureHelper.getGroupToBoneIndexMap(defBase, dataRepository);
        VertexBuffer verticesWeights = null;
        VertexBuffer verticesWeightsIndices = null;
        int[] bonesGroups = new int[]{0};
        VertexBuffer[] boneWeightsAndIndex = this.getBoneWeightAndIndexBuffer(structure, vertexList.size(), bonesGroups, vertexReferenceMap, groupToBoneIndexMap, dataRepository);
        verticesWeights = boneWeightsAndIndex[0];
        verticesWeightsIndices = boneWeightsAndIndex[1];
        MaterialHelper materialHelper = (MaterialHelper)dataRepository.getHelper(MaterialHelper.class);
        Material[] materials = null;
        Material[] nonTexturedMaterials = null;
        if ((dataRepository.getBlenderKey().getFeaturesToLoad() & 3) != 0) {
            materials = materialHelper.getMaterials(structure, dataRepository);
            nonTexturedMaterials = materials == null ? null : new Material[materials.length];
        }
        geometries = new ArrayList<Geometry>(meshesMap.size());
        VertexBuffer verticesBuffer = new VertexBuffer(VertexBuffer.Type.Position);
        verticesBuffer.setupData(VertexBuffer.Usage.Stream, 3, VertexBuffer.Format.Float, (Buffer)BufferUtils.createFloatBuffer((Vector3f[])vertexList.toArray(new Vector3f[vertexList.size()])));
        VertexBuffer verticesBind = new VertexBuffer(VertexBuffer.Type.BindPosePosition);
        verticesBind.setupData(VertexBuffer.Usage.CpuOnly, 3, VertexBuffer.Format.Float, BufferUtils.clone((Buffer)verticesBuffer.getData()));
        VertexBuffer normalsBuffer = new VertexBuffer(VertexBuffer.Type.Normal);
        normalsBuffer.setupData(VertexBuffer.Usage.Stream, 3, VertexBuffer.Format.Float, (Buffer)BufferUtils.createFloatBuffer((Vector3f[])normals));
        VertexBuffer normalsBind = new VertexBuffer(VertexBuffer.Type.BindPoseNormal);
        normalsBind.setupData(VertexBuffer.Usage.CpuOnly, 3, VertexBuffer.Format.Float, BufferUtils.clone((Buffer)normalsBuffer.getData()));
        VertexBuffer uvCoordsBuffer = null;
        if (uvCoordinates != null) {
            uvCoordsBuffer = new VertexBuffer(VertexBuffer.Type.TexCoord);
            uvCoordsBuffer.setupData(VertexBuffer.Usage.Static, 2, VertexBuffer.Format.Float, (Buffer)BufferUtils.createFloatBuffer((Vector2f[])uvCoordinates.toArray(new Vector2f[uvCoordinates.size()])));
        }
        FloatBuffer verticesColorsBuffer = this.createFloatBuffer(verticesColors);
        for (Map.Entry meshEntry : meshesMap.entrySet()) {
            Mesh mesh = new Mesh();
            List indexList = (List)meshEntry.getValue();
            int[] indices = new int[indexList.size()];
            for (int i = 0; i < indexList.size(); ++i) {
                indices[i] = (Integer)indexList.get(i);
            }
            mesh.setBuffer(VertexBuffer.Type.Index, 1, BufferUtils.createIntBuffer((int[])indices));
            mesh.setBuffer(verticesBuffer);
            mesh.setBuffer(verticesBind);
            if (verticesColorsBuffer != null) {
                mesh.setBuffer(VertexBuffer.Type.Color, 4, verticesColorsBuffer);
            }
            if (verticesWeights != null) {
                mesh.setMaxNumWeights(bonesGroups[0]);
                mesh.setBuffer(verticesWeights);
                mesh.setBuffer(verticesWeightsIndices);
            }
            mesh.setBuffer(normalsBuffer);
            mesh.setBuffer(normalsBind);
            if (uvCoordsBuffer != null) {
                mesh.setBuffer(uvCoordsBuffer);
            }
            Geometry geometry = new Geometry(name + (geometries.size() + 1), mesh);
            if (materials != null) {
                Material material;
                int materialNumber = (Integer)meshEntry.getKey();
                if (materialNumber >= 0) {
                    material = materials[materialNumber];
                    if (!materialHelper.hasTexture(material, "DiffuseMap") && materialNumberToTexture.containsKey(materialNumber)) {
                        material = material.clone();
                        material.setTexture("DiffuseMap", (Texture)materialNumberToTexture.get(materialNumber));
                    }
                } else {
                    if (nonTexturedMaterials[materialNumber = -1 * (materialNumber + 1)] == null) {
                        nonTexturedMaterials[materialNumber] = materialHelper.getNonTexturedMaterial(materials[materialNumber], 8);
                    }
                    material = nonTexturedMaterials[materialNumber];
                }
                geometry.setMaterial(material);
            } else {
                geometry.setMaterial(dataRepository.getDefaultMaterial());
            }
            geometries.add(geometry);
        }
        dataRepository.addLoadedFeatures(structure.getOldMemoryAddress(), structure.getName(), structure, geometries);
        return geometries;
    }

    protected void addNormal(Vector3f normalToAdd, Map<Vector3f, Vector3f> normalMap, boolean smooth, Vector3f ... vertices) {
        for (Vector3f v : vertices) {
            Vector3f n = normalMap.get(v);
            if (!smooth || n == null) {
                normalMap.put(v, normalToAdd.clone());
                continue;
            }
            n.addLocal(normalToAdd).normalizeLocal();
        }
    }

    protected void appendVertexReference(int basicVertexIndex, int resultIndex, Map<Integer, List<Integer>> vertexReferenceMap) {
        List<Integer> referenceList = vertexReferenceMap.get(basicVertexIndex);
        if (referenceList == null) {
            referenceList = new ArrayList<Integer>();
            vertexReferenceMap.put(basicVertexIndex, referenceList);
        }
        referenceList.add(resultIndex);
    }

    public List<float[]> getVerticesColors(Structure meshStructure, DataRepository dataRepository) throws BlenderFileException {
        Pointer pMCol = (Pointer)meshStructure.getFieldValue("mcol");
        LinkedList<float[]> verticesColors = null;
        List<Structure> mCol = null;
        if (!pMCol.isNull()) {
            verticesColors = new LinkedList<float[]>();
            mCol = pMCol.fetchData(dataRepository.getInputStream());
            for (Structure color : mCol) {
                float r = (float)((Number)color.getFieldValue("r")).byteValue() / 256.0f;
                float g = (float)((Number)color.getFieldValue("g")).byteValue() / 256.0f;
                float b = (float)((Number)color.getFieldValue("b")).byteValue() / 256.0f;
                float a = (float)((Number)color.getFieldValue("a")).byteValue() / 256.0f;
                verticesColors.add(new float[]{b, g, r, a});
            }
        }
        return verticesColors;
    }

    public Vector3f[] getVertices(Structure meshStructure, DataRepository dataRepository) throws BlenderFileException {
        int verticesAmount = ((Number)meshStructure.getFieldValue("totvert")).intValue();
        Vector3f[] vertices = new Vector3f[verticesAmount];
        Pointer pMVert = (Pointer)meshStructure.getFieldValue("mvert");
        List<Structure> mVerts = pMVert.fetchData(dataRepository.getInputStream());
        for (int i = 0; i < verticesAmount; ++i) {
            DynamicArray coordinates = (DynamicArray)mVerts.get(i).getFieldValue("co");
            vertices[i] = new Vector3f(((Number)coordinates.get(0)).floatValue(), ((Number)coordinates.get(1)).floatValue(), ((Number)coordinates.get(2)).floatValue());
        }
        return vertices;
    }

    public VertexBuffer[] getBoneWeightAndIndexBuffer(Structure meshStructure, int vertexListSize, int[] bonesGroups, Map<Integer, List<Integer>> vertexReferenceMap, Map<Integer, Integer> groupToBoneIndexMap, DataRepository dataRepository) throws BlenderFileException {
        Pointer pDvert = (Pointer)meshStructure.getFieldValue("dvert");
        FloatBuffer weightsFloatData = BufferUtils.createFloatBuffer((int)(vertexListSize * 4));
        ByteBuffer indicesData = BufferUtils.createByteBuffer((int)(vertexListSize * 4));
        if (!pDvert.isNull()) {
            List<Structure> dverts = pDvert.fetchData(dataRepository.getInputStream());
            int vertexIndex = 0;
            for (Structure dvert : dverts) {
                int totweight = ((Number)dvert.getFieldValue("totweight")).intValue();
                Pointer pDW = (Pointer)dvert.getFieldValue("dw");
                List<Integer> vertexIndices = vertexReferenceMap.get(vertexIndex);
                if (totweight > 0 && !pDW.isNull()) {
                    int weightIndex = 0;
                    List<Structure> dw = pDW.fetchData(dataRepository.getInputStream());
                    for (Structure deformWeight : dw) {
                        Integer boneIndex = groupToBoneIndexMap.get(((Number)deformWeight.getFieldValue("def_nr")).intValue());
                        if (boneIndex != null) {
                            float weight = ((Number)deformWeight.getFieldValue("weight")).floatValue();
                            if (weight == 0.0f) {
                                weight = 1.0f;
                                boneIndex = 0;
                            }
                            for (Integer index : vertexIndices) {
                                weightsFloatData.put(index * 4 + weightIndex, weight);
                                indicesData.put(index * 4 + weightIndex, boneIndex.byteValue());
                            }
                        }
                        ++weightIndex;
                    }
                } else {
                    for (Integer index : vertexIndices) {
                        weightsFloatData.put(index * 4, 1.0f);
                        indicesData.put(index * 4, (byte)0);
                    }
                }
                ++vertexIndex;
            }
        } else {
            for (List<Integer> vertexIndexList : vertexReferenceMap.values()) {
                for (Integer index : vertexIndexList) {
                    weightsFloatData.put(index * 4, 1.0f);
                    indicesData.put(index * 4, (byte)0);
                }
            }
        }
        bonesGroups[0] = this.endBoneAssigns(vertexListSize, weightsFloatData);
        VertexBuffer verticesWeights = new VertexBuffer(VertexBuffer.Type.BoneWeight);
        verticesWeights.setupData(VertexBuffer.Usage.CpuOnly, bonesGroups[0], VertexBuffer.Format.Float, (Buffer)weightsFloatData);
        VertexBuffer verticesWeightsIndices = new VertexBuffer(VertexBuffer.Type.BoneIndex);
        verticesWeightsIndices.setupData(VertexBuffer.Usage.CpuOnly, bonesGroups[0], VertexBuffer.Format.UnsignedByte, (Buffer)indicesData);
        return new VertexBuffer[]{verticesWeights, verticesWeightsIndices};
    }

    protected int endBoneAssigns(int vertCount, FloatBuffer weightsFloatData) {
        int maxWeightsPerVert = 0;
        weightsFloatData.rewind();
        for (int v = 0; v < vertCount; ++v) {
            float w0 = weightsFloatData.get();
            float w1 = weightsFloatData.get();
            float w2 = weightsFloatData.get();
            float w3 = weightsFloatData.get();
            if (w3 != 0.0f) {
                maxWeightsPerVert = Math.max(maxWeightsPerVert, 4);
            } else if (w2 != 0.0f) {
                maxWeightsPerVert = Math.max(maxWeightsPerVert, 3);
            } else if (w1 != 0.0f) {
                maxWeightsPerVert = Math.max(maxWeightsPerVert, 2);
            } else if (w0 != 0.0f) {
                maxWeightsPerVert = Math.max(maxWeightsPerVert, 1);
            }
            float sum = w0 + w1 + w2 + w3;
            if (sum == 1.0f || sum == 0.0f) continue;
            weightsFloatData.position(weightsFloatData.position() - 4);
            float sumToB = 1.0f / sum;
            weightsFloatData.put(w0 * sumToB);
            weightsFloatData.put(w1 * sumToB);
            weightsFloatData.put(w2 * sumToB);
            weightsFloatData.put(w3 * sumToB);
        }
        weightsFloatData.rewind();
        return maxWeightsPerVert;
    }

    @Override
    public void clearState() {
    }
}

