/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.helpers.v249;

import com.jme3.animation.AnimControl;
import com.jme3.animation.Bone;
import com.jme3.animation.BoneAnimation;
import com.jme3.animation.BoneTrack;
import com.jme3.animation.Skeleton;
import com.jme3.animation.SkeletonControl;
import com.jme3.bounding.BoundingBox;
import com.jme3.bounding.BoundingSphere;
import com.jme3.bounding.BoundingVolume;
import com.jme3.math.Matrix4f;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.Control;
import com.jme3.scene.plugins.blender.data.FileBlockHeader;
import com.jme3.scene.plugins.blender.data.Structure;
import com.jme3.scene.plugins.blender.exception.BlenderFileException;
import com.jme3.scene.plugins.blender.helpers.v249.ArmatureHelper;
import com.jme3.scene.plugins.blender.helpers.v249.ConstraintHelper;
import com.jme3.scene.plugins.blender.helpers.v249.ObjectHelper;
import com.jme3.scene.plugins.blender.structures.Constraint;
import com.jme3.scene.plugins.blender.structures.Modifier;
import com.jme3.scene.plugins.blender.utils.AbstractBlenderHelper;
import com.jme3.scene.plugins.blender.utils.DataRepository;
import com.jme3.scene.plugins.blender.utils.DynamicArray;
import com.jme3.scene.plugins.blender.utils.Pointer;
import com.jme3.scene.plugins.ogre.AnimData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class ModifierHelper
extends AbstractBlenderHelper {
    private static final Logger LOGGER = Logger.getLogger(ModifierHelper.class.getName());

    public ModifierHelper(String blenderVersion) {
        super(blenderVersion);
    }

    public Node applyModifier(Node node, Modifier modifier, DataRepository dataRepository) {
        if ("ArmatureModifierData".equals(modifier.getType())) {
            return this.applyArmatureModifierData(node, modifier, dataRepository);
        }
        if ("ArrayModifierData".equals(modifier.getType())) {
            return this.applyArrayModifierData(node, modifier, dataRepository);
        }
        LOGGER.warning("Modifier: " + modifier.getType() + " not yet implemented!!!");
        return node;
    }

    public void readModifiers(Structure objectStructure, DataRepository dataRepository) throws BlenderFileException {
        Structure modifiersListBase = (Structure)objectStructure.getFieldValue("modifiers");
        List<Structure> modifiers = modifiersListBase.evaluateListBase(dataRepository);
        for (Structure modifier : modifiers) {
            AnimData loadedModifier = null;
            Long modifierAdditionalData = null;
            if ("ArrayModifierData".equals(modifier.getType())) {
                Pointer pEndCap;
                Pointer pStartCap;
                Pointer pOffsetObject;
                AnimData params = new HashMap();
                Number fittype = (Number)modifier.getFieldValue("fit_type");
                params.put("fittype", fittype);
                switch (fittype.intValue()) {
                    case 0: {
                        params.put("count", modifier.getFieldValue("count"));
                        break;
                    }
                    case 1: {
                        params.put("length", modifier.getFieldValue("length"));
                        break;
                    }
                    case 2: {
                        break;
                    }
                    default: {
                        assert (false) : "Unknown array modifier fit type: " + fittype;
                        break;
                    }
                }
                int offsettype = ((Number)modifier.getFieldValue("offset_type")).intValue();
                if ((offsettype & 1) != 0) {
                    DynamicArray offsetArray = (DynamicArray)modifier.getFieldValue("offset");
                    float[] offset = new float[]{((Number)offsetArray.get(0)).floatValue(), ((Number)offsetArray.get(1)).floatValue(), ((Number)offsetArray.get(2)).floatValue()};
                    params.put("offset", offset);
                }
                if ((offsettype & 2) != 0) {
                    DynamicArray scaleArray = (DynamicArray)modifier.getFieldValue("scale");
                    float[] scale = new float[]{((Number)scaleArray.get(0)).floatValue(), ((Number)scaleArray.get(1)).floatValue(), ((Number)scaleArray.get(2)).floatValue()};
                    params.put("scale", scale);
                }
                if ((offsettype & 4) != 0 && !(pOffsetObject = (Pointer)modifier.getFieldValue("offset_ob")).isNull()) {
                    params.put("offsetob", pOffsetObject);
                }
                if (!(pStartCap = (Pointer)modifier.getFieldValue("start_cap")).isNull()) {
                    params.put("startcap", pStartCap);
                }
                if (!(pEndCap = (Pointer)modifier.getFieldValue("end_cap")).isNull()) {
                    params.put("endcap", pEndCap);
                }
                loadedModifier = params;
            } else if ("ArmatureModifierData".equals(modifier.getType())) {
                Pointer pArmatureObject = (Pointer)modifier.getFieldValue("object");
                if (!pArmatureObject.isNull()) {
                    ObjectHelper objectHelper = (ObjectHelper)dataRepository.getHelper(ObjectHelper.class);
                    Structure armatureObject = (Structure)dataRepository.getLoadedFeature(pArmatureObject.getOldMemoryAddress(), DataRepository.LoadedFeatureDataType.LOADED_STRUCTURE);
                    if (armatureObject == null) {
                        armatureObject = pArmatureObject.fetchData(dataRepository.getInputStream()).get(0);
                        objectHelper.toObject(armatureObject, dataRepository);
                    }
                    modifierAdditionalData = armatureObject.getOldMemoryAddress();
                    ArmatureHelper armatureHelper = (ArmatureHelper)dataRepository.getHelper(ArmatureHelper.class);
                    Matrix4f armatureObjectMatrix = objectHelper.getTransformationMatrix(armatureObject);
                    Matrix4f inverseMeshObjectMatrix = objectHelper.getTransformationMatrix(objectStructure).invert();
                    Matrix4f additionalRootBoneTransformation = inverseMeshObjectMatrix.multLocal(armatureObjectMatrix);
                    Bone[] bones = armatureHelper.buildBonesStructure(0L, additionalRootBoneTransformation);
                    String objectName = objectStructure.getName();
                    Set<String> animationNames = dataRepository.getBlenderKey().getAnimationNames(objectName);
                    if (animationNames != null && animationNames.size() > 0) {
                        ArrayList<BoneAnimation> animations = new ArrayList<BoneAnimation>();
                        List<FileBlockHeader> actionHeaders = dataRepository.getFileBlocks(1094909952);
                        for (FileBlockHeader header : actionHeaders) {
                            Structure actionStructure = header.getStructure(dataRepository);
                            String actionName = actionStructure.getName();
                            if (!animationNames.contains(actionName)) continue;
                            int[] animationFrames = dataRepository.getBlenderKey().getAnimationFrames(objectName, actionName);
                            int fps = dataRepository.getBlenderKey().getFps();
                            float start = (float)animationFrames[0] / (float)fps;
                            float stop = (float)animationFrames[1] / (float)fps;
                            BoneAnimation boneAnimation = new BoneAnimation(actionName, stop - start);
                            boneAnimation.setTracks(armatureHelper.getTracks(actionStructure, dataRepository, objectName, actionName));
                            animations.add(boneAnimation);
                        }
                        loadedModifier = new AnimData(new Skeleton(bones), animations);
                    }
                } else {
                    LOGGER.warning("Unsupported modifier type: " + modifier.getType());
                }
            }
            if (loadedModifier == null) continue;
            dataRepository.addModifier(objectStructure.getOldMemoryAddress(), modifier.getType(), loadedModifier, modifierAdditionalData);
            modifierAdditionalData = null;
        }
    }

    protected Node applyArmatureModifierData(Node node, Modifier modifier, DataRepository dataRepository) {
        AnimData ad = (AnimData)modifier.getJmeModifierRepresentation();
        ArrayList animList = ad.anims;
        Long modifierArmatureObject = (Long)modifier.getAdditionalData();
        if (animList != null && animList.size() > 0) {
            ConstraintHelper constraintHelper = (ConstraintHelper)dataRepository.getHelper(ConstraintHelper.class);
            Constraint[] constraints = constraintHelper.getConstraints(modifierArmatureObject);
            HashMap<String, BoneAnimation> anims = new HashMap<String, BoneAnimation>();
            for (int i = 0; i < animList.size(); ++i) {
                BoneAnimation boneAnimation = this.cloneBoneAnimation((BoneAnimation)animList.get(i));
                if (constraints != null && constraints.length > 0) {
                    for (Constraint constraint : constraints) {
                        constraint.affectAnimation(ad.skeleton, boneAnimation);
                    }
                }
                anims.put(boneAnimation.getName(), boneAnimation);
            }
            Mesh[] meshes = null;
            ArrayList<Mesh> meshesList = new ArrayList<Mesh>();
            List children = node.getChildren();
            for (Spatial child : children) {
                if (!(child instanceof Geometry)) continue;
                meshesList.add(((Geometry)child).getMesh());
            }
            if (meshesList.size() > 0) {
                meshes = meshesList.toArray(new Mesh[meshesList.size()]);
            }
            SkeletonControl skeletonControl = new SkeletonControl(meshes, ad.skeleton);
            AnimControl control = (AnimControl)node.getControl(AnimControl.class);
            if (control == null) {
                control = new AnimControl(ad.skeleton);
            } else {
                Skeleton controlSkeleton = control.getSkeleton();
                int boneIndexIncrease = controlSkeleton.getBoneCount();
                Skeleton skeleton = this.merge(controlSkeleton, ad.skeleton);
                HashMap<String, Object> animations = new HashMap<String, Object>();
                for (String string : control.getAnimationNames()) {
                    animations.put(string, control.getAnim(string));
                }
                for (Map.Entry entry : anims.entrySet()) {
                    BoneAnimation ba = (BoneAnimation)entry.getValue();
                    for (int i = 0; i < ba.getTracks().length; ++i) {
                        BoneTrack bt = ba.getTracks()[i];
                        int newBoneIndex = bt.getTargetBoneIndex() + boneIndexIncrease;
                        ba.getTracks()[i] = new BoneTrack(newBoneIndex, bt.getTimes(), bt.getTranslations(), bt.getRotations(), bt.getScales());
                    }
                    animations.put((String)entry.getKey(), entry.getValue());
                }
                node.removeControl((Control)control);
                control = new AnimControl(skeleton);
            }
            control.setAnimations(anims);
            node.addControl((Control)control);
            node.addControl((Control)skeletonControl);
        }
        return node;
    }

    protected Node applyArrayModifierData(Node node, Modifier modifier, DataRepository dataRepository) {
        float[] scale;
        Map modifierData = (Map)modifier.getJmeModifierRepresentation();
        int fittype = ((Number)modifierData.get("fittype")).intValue();
        float[] offset = (float[])modifierData.get("offset");
        if (offset == null) {
            offset = new float[]{0.0f, 0.0f, 0.0f};
        }
        if ((scale = (float[])modifierData.get("scale")) == null) {
            scale = new float[]{0.0f, 0.0f, 0.0f};
        } else {
            node.updateModelBound();
            BoundingVolume boundingVolume = node.getWorldBound();
            if (boundingVolume instanceof BoundingBox) {
                scale[0] = scale[0] * (((BoundingBox)boundingVolume).getXExtent() * 2.0f);
                scale[1] = scale[1] * (((BoundingBox)boundingVolume).getYExtent() * 2.0f);
                scale[2] = scale[2] * (((BoundingBox)boundingVolume).getZExtent() * 2.0f);
            } else if (boundingVolume instanceof BoundingSphere) {
                float radius = ((BoundingSphere)boundingVolume).getRadius();
                scale[0] = scale[0] * (radius * 2.0f);
                scale[1] = scale[1] * (radius * 2.0f);
                scale[2] = scale[2] * (radius * 2.0f);
            } else {
                throw new IllegalStateException("Unknown bounding volume type: " + boundingVolume.getClass().getName());
            }
        }
        float[] objectOffset = new float[]{0.0f, 0.0f, 0.0f};
        Pointer pOffsetObject = (Pointer)modifierData.get("offsetob");
        if (pOffsetObject != null) {
            FileBlockHeader offsetObjectBlock = dataRepository.getFileBlock(pOffsetObject.getOldMemoryAddress());
            ObjectHelper objectHelper = (ObjectHelper)dataRepository.getHelper(ObjectHelper.class);
            try {
                Structure offsetStructure = offsetObjectBlock.getStructure(dataRepository);
                Vector3f translation = objectHelper.getTransformation(offsetStructure).getTranslation();
                objectOffset[0] = translation.x;
                objectOffset[1] = translation.y;
                objectOffset[2] = translation.z;
            }
            catch (BlenderFileException e) {
                LOGGER.warning("Problems in blender file structure! Object offset cannot be applied! The problem: " + e.getMessage());
            }
        }
        Node[] caps = new Node[]{null, null};
        Pointer[] pCaps = new Pointer[]{(Pointer)modifierData.get("startcap"), (Pointer)modifierData.get("endcap")};
        for (int i = 0; i < pCaps.length; ++i) {
            if (pCaps[i] == null) continue;
            caps[i] = (Node)dataRepository.getLoadedFeature(pCaps[i].getOldMemoryAddress(), DataRepository.LoadedFeatureDataType.LOADED_FEATURE);
            if (caps[i] != null) {
                caps[i] = (Node)caps[i].clone();
                continue;
            }
            FileBlockHeader capBlock = dataRepository.getFileBlock(pOffsetObject.getOldMemoryAddress());
            try {
                Structure capStructure = capBlock.getStructure(dataRepository);
                ObjectHelper objectHelper = (ObjectHelper)dataRepository.getHelper(ObjectHelper.class);
                caps[i] = (Node)objectHelper.toObject(capStructure, dataRepository);
                if (caps[i] != null) continue;
                LOGGER.warning("Cap object '" + capStructure.getName() + "' couldn't be loaded!");
                continue;
            }
            catch (BlenderFileException e) {
                LOGGER.warning("Problems in blender file structure! Cap object cannot be applied! The problem: " + e.getMessage());
            }
        }
        Vector3f translationVector = new Vector3f(offset[0] + scale[0] + objectOffset[0], offset[1] + scale[1] + objectOffset[1], offset[2] + scale[2] + objectOffset[2]);
        int count = 0;
        if (fittype == 0) {
            count = ((Number)modifierData.get("count")).intValue() - 1;
        } else if (fittype == 1) {
            float length = ((Number)modifierData.get("length")).floatValue();
            if (translationVector.length() > 0.0f) {
                count = (int)(length / translationVector.length()) - 1;
            }
        } else if (fittype == 2) {
            LOGGER.warning("Fit curve mode in array modifier not yet implemented!");
        } else {
            throw new IllegalStateException("Unknown fit type: " + fittype);
        }
        if (count > 0) {
            Node[] arrayNodes = new Node[count];
            Vector3f newTranslation = node.getLocalTranslation().clone();
            for (int i = 0; i < count; ++i) {
                newTranslation.addLocal(translationVector);
                Node nodeClone = (Node)node.clone();
                nodeClone.setLocalTranslation(newTranslation);
                arrayNodes[i] = nodeClone;
            }
            for (Node nodeClone : arrayNodes) {
                node.attachChild((Spatial)nodeClone);
            }
            if (caps[0] != null) {
                caps[0].getLocalTranslation().set(node.getLocalTranslation()).subtractLocal(translationVector);
                node.attachChild((Spatial)caps[0]);
            }
            if (caps[1] != null) {
                caps[1].getLocalTranslation().set(newTranslation).addLocal(translationVector);
                node.attachChild((Spatial)caps[1]);
            }
        }
        return node;
    }

    protected BoneAnimation cloneBoneAnimation(BoneAnimation source) {
        BoneAnimation result = new BoneAnimation(source.getName(), source.getLength());
        BoneTrack[] sourceTracks = source.getTracks();
        BoneTrack[] boneTracks = new BoneTrack[sourceTracks.length];
        for (int i = 0; i < sourceTracks.length; ++i) {
            int tablesLength = sourceTracks[i].getTimes().length;
            Vector3f[] sourceTranslations = sourceTracks[i].getTranslations();
            Quaternion[] sourceRotations = sourceTracks[i].getRotations();
            Vector3f[] sourceScales = sourceTracks[i].getScales();
            Vector3f[] translations = new Vector3f[tablesLength];
            Quaternion[] rotations = new Quaternion[tablesLength];
            Vector3f[] scales = sourceScales == null ? null : new Vector3f[tablesLength];
            for (int j = 0; j < tablesLength; ++j) {
                translations[j] = sourceTranslations[j].clone();
                rotations[j] = sourceRotations[j].clone();
                if (sourceScales == null) continue;
                scales[j] = sourceScales[j].clone();
            }
            boneTracks[i] = new BoneTrack(sourceTracks[i].getTargetBoneIndex(), sourceTracks[i].getTimes(), translations, rotations, scales);
        }
        result.setTracks(boneTracks);
        return result;
    }

    protected Skeleton merge(Skeleton s1, Skeleton s2) {
        int i;
        ArrayList<Bone> bones = new ArrayList<Bone>(s1.getBoneCount() + s2.getBoneCount());
        for (i = 0; i < s1.getBoneCount(); ++i) {
            bones.add(s1.getBone(i));
        }
        for (i = 1; i < s2.getBoneCount(); ++i) {
            bones.add(s2.getBone(i));
        }
        return new Skeleton(bones.toArray(new Bone[bones.size()]));
    }

    public void clearState() {
    }
}

