/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.structures;

import com.jme3.animation.Bone;
import com.jme3.animation.BoneAnimation;
import com.jme3.animation.BoneTrack;
import com.jme3.animation.Skeleton;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.plugins.blender.data.Structure;
import com.jme3.scene.plugins.blender.structures.Constraint;
import com.jme3.scene.plugins.blender.structures.ConstraintType;
import com.jme3.scene.plugins.blender.utils.DataRepository;
import com.jme3.scene.plugins.blender.utils.Pointer;
import java.util.logging.Logger;

public abstract class AbstractInfluenceFunction {
    protected static final Logger LOGGER = Logger.getLogger(AbstractInfluenceFunction.class.getName());
    protected static final float IK_SOLVER_ERROR = 0.5f;
    protected static final int LIMITDIST_INSIDE = 0;
    protected static final int LIMITDIST_OUTSIDE = 1;
    protected static final int LIMITDIST_ONSURFACE = 2;
    protected static final int LOCLIKE_X = 1;
    protected static final int LOCLIKE_Y = 2;
    protected static final int LOCLIKE_Z = 4;
    protected static final int ROTLIKE_X = 1;
    protected static final int ROTLIKE_Y = 2;
    protected static final int ROTLIKE_Z = 4;
    protected static final int ROTLIKE_X_INVERT = 16;
    protected static final int ROTLIKE_Y_INVERT = 32;
    protected static final int ROTLIKE_Z_INVERT = 64;
    protected static final int ROTLIKE_OFFSET = 128;
    protected static final int SIZELIKE_X = 1;
    protected static final int SIZELIKE_Y = 2;
    protected static final int SIZELIKE_Z = 4;
    protected static final int SIZELIKE_OFFSET = 128;
    protected static final int LOCLIKE_X_INVERT = 16;
    protected static final int LOCLIKE_Y_INVERT = 32;
    protected static final int LOCLIKE_Z_INVERT = 64;
    protected static final int LOCLIKE_OFFSET = 128;
    protected static final int LIMIT_XMIN = 1;
    protected static final int LIMIT_XMAX = 2;
    protected static final int LIMIT_YMIN = 4;
    protected static final int LIMIT_YMAX = 8;
    protected static final int LIMIT_ZMIN = 16;
    protected static final int LIMIT_ZMAX = 32;
    protected static final int LIMIT_XROT = 1;
    protected static final int LIMIT_YROT = 2;
    protected static final int LIMIT_ZROT = 4;
    protected ConstraintType constraintType;
    protected DataRepository dataRepository;

    public AbstractInfluenceFunction(ConstraintType constraintType, DataRepository dataRepository) {
        this.constraintType = constraintType;
        this.dataRepository = dataRepository;
    }

    protected void validateConstraintType(Structure constraintStructure) {
        if (!this.constraintType.getClassName().equalsIgnoreCase(constraintStructure.getType())) {
            throw new IllegalArgumentException("Invalud structure type (" + constraintStructure.getType() + ") for the constraint: " + this.constraintType.getClassName() + '!');
        }
    }

    public void affectAnimation(Skeleton skeleton, BoneAnimation boneAnimation, Constraint constraint) {
    }

    protected BoneTrack getBoneTrack(Skeleton skeleton, BoneAnimation boneAnimation, Constraint constraint) {
        Long boneOMA = constraint.getBoneOMA();
        Bone bone = (Bone)this.dataRepository.getLoadedFeature(boneOMA, DataRepository.LoadedFeatureDataType.LOADED_FEATURE);
        int boneIndex = skeleton.getBoneIndex(bone);
        if (boneIndex != -1) {
            for (BoneTrack boneTrack : boneAnimation.getTracks()) {
                if (boneTrack.getTargetBoneIndex() != boneIndex) continue;
                return boneTrack;
            }
        }
        return null;
    }

    protected Object getTarget(Constraint constraint, DataRepository.LoadedFeatureDataType loadedFeatureDataType) {
        Long targetOMA = ((Pointer)constraint.getData().getFieldValue("tar")).getOldMemoryAddress();
        Object targetObject = this.dataRepository.getLoadedFeature(targetOMA, loadedFeatureDataType);
        String subtargetName = constraint.getData().getFieldValue("subtarget").toString();
        if (subtargetName.length() > 0) {
            return this.dataRepository.getLoadedFeature(subtargetName, loadedFeatureDataType);
        }
        return targetObject;
    }

    protected Vector3f getTargetLocation(Constraint constraint) {
        Long targetOMA = ((Pointer)constraint.getData().getFieldValue("tar")).getOldMemoryAddress();
        Constraint.Space targetSpace = constraint.getTargetSpace();
        Node targetObject = (Node)this.dataRepository.getLoadedFeature(targetOMA, DataRepository.LoadedFeatureDataType.LOADED_FEATURE);
        switch (targetSpace) {
            case CONSTRAINT_SPACE_LOCAL: {
                return targetObject.getLocalTranslation();
            }
            case CONSTRAINT_SPACE_WORLD: {
                return targetObject.getWorldTranslation();
            }
        }
        throw new IllegalStateException("Invalid space type for target object: " + targetSpace.toString());
    }

    protected Vector3f getTargetLocation(Constraint constraint, int frame) {
        return this.getTargetLocation(constraint);
    }

    protected Quaternion getTargetRotation(Constraint constraint) {
        Long targetOMA = ((Pointer)constraint.getData().getFieldValue("tar")).getOldMemoryAddress();
        Constraint.Space targetSpace = constraint.getTargetSpace();
        Node targetObject = (Node)this.dataRepository.getLoadedFeature(targetOMA, DataRepository.LoadedFeatureDataType.LOADED_FEATURE);
        switch (targetSpace) {
            case CONSTRAINT_SPACE_LOCAL: {
                return targetObject.getLocalRotation();
            }
            case CONSTRAINT_SPACE_WORLD: {
                return targetObject.getWorldRotation();
            }
        }
        throw new IllegalStateException("Invalid space type for target object: " + targetSpace.toString());
    }

    protected Vector3f getTargetScale(Constraint constraint) {
        Long targetOMA = ((Pointer)constraint.getData().getFieldValue("tar")).getOldMemoryAddress();
        Constraint.Space targetSpace = constraint.getTargetSpace();
        Node targetObject = (Node)this.dataRepository.getLoadedFeature(targetOMA, DataRepository.LoadedFeatureDataType.LOADED_FEATURE);
        switch (targetSpace) {
            case CONSTRAINT_SPACE_LOCAL: {
                return targetObject.getLocalScale();
            }
            case CONSTRAINT_SPACE_WORLD: {
                return targetObject.getWorldScale();
            }
        }
        throw new IllegalStateException("Invalid space type for target object: " + targetSpace.toString());
    }
}

