/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.test;

import com.jme3.animation.Bone;
import com.jme3.animation.Skeleton;
import com.jme3.app.SimpleApplication;
import com.jme3.asset.AssetInfo;
import com.jme3.asset.AssetKey;
import com.jme3.asset.AssetManager;
import com.jme3.asset.BlenderKey;
import com.jme3.asset.plugins.FileLocator;
import com.jme3.light.DirectionalLight;
import com.jme3.light.Light;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.plugins.blender.BlenderLoader;
import com.jme3.scene.plugins.blender.BlenderModelLoader;
import com.jme3.scene.plugins.ogre.MaterialLoader;
import com.jme3.scene.plugins.ogre.MeshLoader;
import com.jme3.scene.shape.Line;
import com.jme3.scene.shape.Sphere;
import com.jme3.texture.plugins.AWTLoader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BlenderTester
extends SimpleApplication {
    private static final Logger LOGGER = Logger.getLogger(BlenderTester.class.getName());

    public static void main(String[] args) {
        new BlenderTester().start();
    }

    public void simpleInitApp() {
        Logger.getLogger("").setLevel(Level.SEVERE);
        this.assetManager.registerLocator(".", FileLocator.class);
        this.assetManager.registerLoader(MeshLoader.class, new String[]{"mesh.xml"});
        this.assetManager.registerLoader(MaterialLoader.class, new String[]{"material"});
        this.assetManager.registerLoader(AWTLoader.class, new String[]{"png"});
        this.viewPort.setBackgroundColor(ColorRGBA.Gray);
        this.flyCam.setMoveSpeed(20.0f);
        this.cam.setFrustumFar(1000.0f);
        this.cam.setFrustumNear(1.0f);
        String assetName = "TestAssets/animtest/animtest";
        BlenderKey key = new BlenderKey(assetName + ".blend");
        key.setFps(25);
        key.setFixUpAxis(false);
        AssetInfo ai = new AssetInfo(this.assetManager, (AssetKey)key){

            public InputStream openStream() {
                try {
                    return new FileInputStream(this.key.getName());
                }
                catch (FileNotFoundException e) {
                    LOGGER.log(Level.SEVERE, e.getMessage(), e);
                    return null;
                }
            }
        };
        this.rootNode.attachChild((Spatial)new Pivot(this.assetManager));
        Node blenderModel = this.testBlenderModelLoader(ai);
        DirectionalLight sun = new DirectionalLight();
        sun.setDirection(new Vector3f(1.0f, 0.0f, -2.0f).normalizeLocal());
        sun.setColor(ColorRGBA.White);
        this.rootNode.addLight((Light)sun);
    }

    private Node testBlenderLoader(AssetInfo assetInfo) {
        Node blenderModel = null;
        BlenderLoader blenderLoader = new BlenderLoader();
        try {
            BlenderKey.LoadingResults loadingResults = blenderLoader.load(assetInfo);
            for (Node object : loadingResults.getObjects()) {
                this.rootNode.attachChild((Spatial)object);
                blenderModel = object;
            }
            for (Light light : loadingResults.getLights()) {
                this.rootNode.addLight(light);
            }
            for (Camera camera : loadingResults.getCameras()) {
                System.out.println("camera: " + camera.toString());
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
        return blenderModel;
    }

    private Node testBlenderModelLoader(AssetInfo assetInfo) {
        BlenderModelLoader blenderLoader = new BlenderModelLoader();
        try {
            Spatial loadingResults = blenderLoader.load(assetInfo);
            this.rootNode.attachChild(loadingResults);
            if (loadingResults instanceof Node) {
                return (Node)loadingResults;
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
        return null;
    }

    private void saveSkeletonData(Skeleton s, String filename) {
        Properties p = new Properties();
        for (int i = 0; i < s.getBoneCount(); ++i) {
            Bone bone = s.getBone(i);
            p.put(bone.getName(), bone.getWorldBindInversePosition() + " : " + bone.getWorldBindInverseRotation());
        }
        try {
            FileOutputStream fos = new FileOutputStream(filename);
            p.save(fos, "");
            fos.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static class VisibleBone
    extends Node {
        private Vector3f globalPosition;

        public VisibleBone(Bone bone, Vector3f parentLocation, Quaternion parentRotation, AssetManager assetManager) {
            Material redMat = new Material(assetManager, "Common/MatDefs/Misc/SolidColor.j3md");
            redMat.setColor("m_Color", ColorRGBA.Red);
            Material whiteMat = new Material(assetManager, "Common/MatDefs/Misc/SolidColor.j3md");
            whiteMat.setColor("m_Color", ColorRGBA.White);
            Geometry g = new Geometry(bone.getName(), (Mesh)new Sphere(9, 9, 0.01f));
            this.globalPosition = bone.getLocalPosition().add(parentLocation);
            g.setLocalTranslation(this.globalPosition);
            g.setLocalRotation(bone.getLocalRotation().mult(parentRotation));
            g.setMaterial(redMat);
            this.attachChild((Spatial)g);
            if (bone.getChildren() != null) {
                for (Bone child : bone.getChildren()) {
                    VisibleBone vb = new VisibleBone(child, bone.getLocalPosition(), bone.getLocalRotation(), assetManager);
                    this.attachChild((Spatial)vb);
                    Line line = new Line(this.globalPosition, vb.globalPosition);
                    line.setLineWidth(2.0f);
                    Geometry geom = new Geometry("", (Mesh)line);
                    geom.setMaterial(whiteMat);
                    this.attachChild((Spatial)geom);
                }
            }
        }
    }

    private class Pivot
    extends Node {
        public Pivot(AssetManager assetManager) {
            this.attachChild((Spatial)this.getAxis("x", new Vector3f(10.0f, 0.0f, 0.0f), ColorRGBA.Red, assetManager));
            this.attachChild((Spatial)this.getAxis("y", new Vector3f(0.0f, 10.0f, 0.0f), ColorRGBA.Green, assetManager));
            this.attachChild((Spatial)this.getAxis("z", new Vector3f(0.0f, 0.0f, 10.0f), ColorRGBA.Blue, assetManager));
            this.assignPoints();
        }

        private void assignPoints() {
            Material defaultMaterial = new Material(BlenderTester.this.assetManager, "Common/MatDefs/Misc/SolidColor.j3md");
            defaultMaterial.setColor("m_Color", ColorRGBA.DarkGray);
            for (int i = -10; i <= 10; ++i) {
                Geometry g = new Geometry("", (Mesh)new Sphere(3, 3, 0.05f));
                g.setLocalTranslation((float)i, 0.0f, 0.0f);
                g.setMaterial(defaultMaterial);
                this.attachChild((Spatial)g);
                g = new Geometry("", (Mesh)new Sphere(3, 3, 0.05f));
                g.setLocalTranslation(0.0f, (float)i, 0.0f);
                g.setMaterial(defaultMaterial);
                this.attachChild((Spatial)g);
                g = new Geometry("", (Mesh)new Sphere(3, 3, 0.05f));
                g.setLocalTranslation(0.0f, 0.0f, (float)i);
                g.setMaterial(defaultMaterial);
                this.attachChild((Spatial)g);
            }
        }

        private Geometry getAxis(String name, Vector3f endPoint, ColorRGBA color, AssetManager assetManager) {
            Line axis = new Line(new Vector3f(0.0f, 0.0f, 0.0f), endPoint);
            Material mat = new Material(assetManager, "Common/MatDefs/Misc/SolidColor.j3md");
            mat.setColor("m_Color", color);
            Geometry geom = new Geometry(name, (Mesh)axis);
            geom.setMaterial(mat);
            return geom;
        }
    }
}

