/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.utils;

import com.jme3.asset.BlenderKey;
import com.jme3.light.AmbientLight;
import com.jme3.light.Light;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.renderer.Camera;
import com.jme3.scene.Geometry;
import com.jme3.scene.Node;
import com.jme3.scene.plugins.blender.data.Structure;
import com.jme3.scene.plugins.blender.exception.BlenderFileException;
import com.jme3.scene.plugins.blender.helpers.CameraHelper;
import com.jme3.scene.plugins.blender.helpers.LightHelper;
import com.jme3.scene.plugins.blender.helpers.MaterialHelper;
import com.jme3.scene.plugins.blender.helpers.MeshHelper;
import com.jme3.scene.plugins.blender.helpers.ObjectHelper;
import com.jme3.scene.plugins.blender.utils.DataRepository;
import com.jme3.scene.plugins.blender.utils.IBlenderConverter;
import java.util.List;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmeConverter
implements IBlenderConverter<Node, Camera, Light, Object, List<Geometry>, Material> {
    private static final Logger LOGGER = Logger.getLogger(JmeConverter.class.getName());
    private final DataRepository dataRepository;

    public JmeConverter(DataRepository dataRepository) {
        if (dataRepository.getAssetManager() == null) {
            throw new IllegalArgumentException("Cannot find asset manager!");
        }
        if (dataRepository.getBlenderKey() == null) {
            throw new IllegalArgumentException("Cannot find blender key!");
        }
        if (dataRepository.getDnaBlockData() == null) {
            throw new IllegalArgumentException("Cannot find dna block!");
        }
        if (dataRepository.getInputStream() == null) {
            throw new IllegalArgumentException("Cannot find blender file stream!");
        }
        this.dataRepository = dataRepository;
    }

    @Override
    public Node toScene(Structure structure) {
        if ((this.dataRepository.getBlenderKey().getFeaturesToLoad() & 0xFFFF) == 0) {
            return null;
        }
        Structure id = (Structure)structure.getFieldValue("id");
        String sceneName = id.getFieldValue("name").toString();
        Node result = new Node(sceneName);
        return result;
    }

    @Override
    public Camera toCamera(Structure structure) throws BlenderFileException {
        if ((this.dataRepository.getBlenderKey().getFeaturesToLoad() & 0x20) == 0) {
            return null;
        }
        CameraHelper cameraHelper = (CameraHelper)this.dataRepository.getHelper(CameraHelper.class);
        return cameraHelper.toCamera(structure);
    }

    @Override
    public Light toLight(Structure structure) throws BlenderFileException {
        if ((this.dataRepository.getBlenderKey().getFeaturesToLoad() & 0x10) == 0) {
            return null;
        }
        LightHelper lightHelper = (LightHelper)this.dataRepository.getHelper(LightHelper.class);
        return lightHelper.toLight(structure, this.dataRepository);
    }

    @Override
    public Object toObject(Structure structure) throws BlenderFileException {
        if ((this.dataRepository.getBlenderKey().getFeaturesToLoad() & 0xB) == 0) {
            return null;
        }
        ObjectHelper objectHelper = (ObjectHelper)this.dataRepository.getHelper(ObjectHelper.class);
        return objectHelper.toObject(structure, this.dataRepository);
    }

    @Override
    public List<Geometry> toMesh(Structure structure) throws BlenderFileException {
        MeshHelper meshHelper = (MeshHelper)this.dataRepository.getHelper(MeshHelper.class);
        return meshHelper.toMesh(structure, this.dataRepository);
    }

    @Override
    public Material toMaterial(Structure structure) throws BlenderFileException {
        if ((this.dataRepository.getBlenderKey().getFeaturesToLoad() & 3) == 0) {
            return null;
        }
        MaterialHelper materialHelper = (MaterialHelper)this.dataRepository.getHelper(MaterialHelper.class);
        return materialHelper.toMaterial(structure, this.dataRepository);
    }

    public BlenderKey.WorldData toWorldData(Structure structure) {
        BlenderKey.WorldData result = new BlenderKey.WorldData();
        AmbientLight ambientLight = new AmbientLight();
        float ambr = ((Number)structure.getFieldValue("ambr")).floatValue();
        float ambg = ((Number)structure.getFieldValue("ambg")).floatValue();
        float ambb = ((Number)structure.getFieldValue("ambb")).floatValue();
        ambientLight.setColor(new ColorRGBA(ambr, ambg, ambb, 0.0f));
        result.setAmbientLight(ambientLight);
        return result;
    }
}

