/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import proguard.ArgumentWordReader;
import proguard.ClassPath;
import proguard.ClassPathEntry;
import proguard.ClassSpecification;
import proguard.Configuration;
import proguard.ConfigurationConstants;
import proguard.FileWordReader;
import proguard.KeepClassSpecification;
import proguard.MemberSpecification;
import proguard.ParseException;
import proguard.WordReader;
import proguard.classfile.util.ClassUtil;
import proguard.util.ListUtil;

public class ConfigurationParser {
    private WordReader reader;
    private String nextWord;
    private String lastComments;

    public ConfigurationParser(String[] stringArray) throws IOException {
        this(stringArray, null);
    }

    public ConfigurationParser(String[] stringArray, File file) throws IOException {
        this.reader = new ArgumentWordReader(stringArray, file);
        this.readNextWord();
    }

    public ConfigurationParser(File file) throws IOException {
        this.reader = new FileWordReader(file);
        this.readNextWord();
    }

    public ConfigurationParser(URL uRL) throws IOException {
        this.reader = new FileWordReader(uRL);
        this.readNextWord();
    }

    public void parse(Configuration configuration) throws ParseException, IOException {
        while (this.nextWord != null) {
            this.lastComments = this.reader.lastComments();
            if ("@".startsWith(this.nextWord) || "-include".startsWith(this.nextWord)) {
                configuration.lastModified = this.parseIncludeArgument(configuration.lastModified);
                continue;
            }
            if ("-basedirectory".startsWith(this.nextWord)) {
                this.parseBaseDirectoryArgument();
                continue;
            }
            if ("-injars".startsWith(this.nextWord)) {
                configuration.programJars = this.parseClassPathArgument(configuration.programJars, false);
                continue;
            }
            if ("-outjars".startsWith(this.nextWord)) {
                configuration.programJars = this.parseClassPathArgument(configuration.programJars, true);
                continue;
            }
            if ("-libraryjars".startsWith(this.nextWord)) {
                configuration.libraryJars = this.parseClassPathArgument(configuration.libraryJars, false);
                continue;
            }
            if ("-resourcejars".startsWith(this.nextWord)) {
                throw new ParseException("The '-resourcejars' option is no longer supported. Please use the '-injars' option for all input");
            }
            if ("-skipnonpubliclibraryclasses".startsWith(this.nextWord)) {
                configuration.skipNonPublicLibraryClasses = this.parseNoArgument(true);
                continue;
            }
            if ("-dontskipnonpubliclibraryclasses".startsWith(this.nextWord)) {
                configuration.skipNonPublicLibraryClasses = this.parseNoArgument(false);
                continue;
            }
            if ("-dontskipnonpubliclibraryclassmembers".startsWith(this.nextWord)) {
                configuration.skipNonPublicLibraryClassMembers = this.parseNoArgument(false);
                continue;
            }
            if ("-target".startsWith(this.nextWord)) {
                configuration.targetClassVersion = this.parseClassVersion();
                continue;
            }
            if ("-forceprocessing".startsWith(this.nextWord)) {
                configuration.lastModified = this.parseNoArgument(Long.MAX_VALUE);
                continue;
            }
            if ("-keep".startsWith(this.nextWord)) {
                configuration.keep = this.parseKeepClassSpecificationArguments(configuration.keep, true, false, false);
                continue;
            }
            if ("-keepclassmembers".startsWith(this.nextWord)) {
                configuration.keep = this.parseKeepClassSpecificationArguments(configuration.keep, false, false, false);
                continue;
            }
            if ("-keepclasseswithmembers".startsWith(this.nextWord)) {
                configuration.keep = this.parseKeepClassSpecificationArguments(configuration.keep, false, true, false);
                continue;
            }
            if ("-keepnames".startsWith(this.nextWord)) {
                configuration.keep = this.parseKeepClassSpecificationArguments(configuration.keep, true, false, true);
                continue;
            }
            if ("-keepclassmembernames".startsWith(this.nextWord)) {
                configuration.keep = this.parseKeepClassSpecificationArguments(configuration.keep, false, false, true);
                continue;
            }
            if ("-keepclasseswithmembernames".startsWith(this.nextWord)) {
                configuration.keep = this.parseKeepClassSpecificationArguments(configuration.keep, false, true, true);
                continue;
            }
            if ("-printseeds".startsWith(this.nextWord)) {
                configuration.printSeeds = this.parseOptionalFile();
                continue;
            }
            if ("-keepdirectories".startsWith(this.nextWord)) {
                configuration.keepDirectories = this.parseCommaSeparatedList("directory name", true, true, false, false, true, false, false, configuration.keepDirectories);
                continue;
            }
            if ("-dontshrink".startsWith(this.nextWord)) {
                configuration.shrink = this.parseNoArgument(false);
                continue;
            }
            if ("-printusage".startsWith(this.nextWord)) {
                configuration.printUsage = this.parseOptionalFile();
                continue;
            }
            if ("-whyareyoukeeping".startsWith(this.nextWord)) {
                configuration.whyAreYouKeeping = this.parseClassSpecificationArguments(configuration.whyAreYouKeeping);
                continue;
            }
            if ("-dontoptimize".startsWith(this.nextWord)) {
                configuration.optimize = this.parseNoArgument(false);
                continue;
            }
            if ("-optimizationpasses".startsWith(this.nextWord)) {
                configuration.optimizationPasses = this.parseIntegerArgument();
                continue;
            }
            if ("-optimizations".startsWith(this.nextWord)) {
                configuration.optimizations = this.parseCommaSeparatedList("optimization name", true, false, false, false, false, false, false, configuration.optimizations);
                continue;
            }
            if ("-assumenosideeffects".startsWith(this.nextWord)) {
                configuration.assumeNoSideEffects = this.parseClassSpecificationArguments(configuration.assumeNoSideEffects);
                continue;
            }
            if ("-allowaccessmodification".startsWith(this.nextWord)) {
                configuration.allowAccessModification = this.parseNoArgument(true);
                continue;
            }
            if ("-mergeinterfacesaggressively".startsWith(this.nextWord)) {
                configuration.mergeInterfacesAggressively = this.parseNoArgument(true);
                continue;
            }
            if ("-dontobfuscate".startsWith(this.nextWord)) {
                configuration.obfuscate = this.parseNoArgument(false);
                continue;
            }
            if ("-printmapping".startsWith(this.nextWord)) {
                configuration.printMapping = this.parseOptionalFile();
                continue;
            }
            if ("-applymapping".startsWith(this.nextWord)) {
                configuration.applyMapping = this.parseFile();
                continue;
            }
            if ("-obfuscationdictionary".startsWith(this.nextWord)) {
                configuration.obfuscationDictionary = this.parseFile();
                continue;
            }
            if ("-classobfuscationdictionary".startsWith(this.nextWord)) {
                configuration.classObfuscationDictionary = this.parseFile();
                continue;
            }
            if ("-packageobfuscationdictionary".startsWith(this.nextWord)) {
                configuration.packageObfuscationDictionary = this.parseFile();
                continue;
            }
            if ("-overloadaggressively".startsWith(this.nextWord)) {
                configuration.overloadAggressively = this.parseNoArgument(true);
                continue;
            }
            if ("-useuniqueclassmembernames".startsWith(this.nextWord)) {
                configuration.useUniqueClassMemberNames = this.parseNoArgument(true);
                continue;
            }
            if ("-dontusemixedcaseclassnames".startsWith(this.nextWord)) {
                configuration.useMixedCaseClassNames = this.parseNoArgument(false);
                continue;
            }
            if ("-keeppackagenames".startsWith(this.nextWord)) {
                configuration.keepPackageNames = this.parseCommaSeparatedList("package name", true, true, false, true, false, true, false, configuration.keepPackageNames);
                continue;
            }
            if ("-flattenpackagehierarchy".startsWith(this.nextWord)) {
                configuration.flattenPackageHierarchy = ClassUtil.internalClassName(this.parseOptionalArgument());
                continue;
            }
            if ("-repackageclasses".startsWith(this.nextWord)) {
                configuration.repackageClasses = ClassUtil.internalClassName(this.parseOptionalArgument());
                continue;
            }
            if ("-defaultpackage".startsWith(this.nextWord)) {
                configuration.repackageClasses = ClassUtil.internalClassName(this.parseOptionalArgument());
                continue;
            }
            if ("-keepattributes".startsWith(this.nextWord)) {
                configuration.keepAttributes = this.parseCommaSeparatedList("attribute name", true, true, false, true, false, false, false, configuration.keepAttributes);
                continue;
            }
            if ("-keepparameternames".startsWith(this.nextWord)) {
                configuration.keepParameterNames = this.parseNoArgument(true);
                continue;
            }
            if ("-renamesourcefileattribute".startsWith(this.nextWord)) {
                configuration.newSourceFileAttribute = this.parseOptionalArgument();
                continue;
            }
            if ("-adaptclassstrings".startsWith(this.nextWord)) {
                configuration.adaptClassStrings = this.parseCommaSeparatedList("class name", true, true, false, true, false, true, false, configuration.adaptClassStrings);
                continue;
            }
            if ("-adaptresourcefilenames".startsWith(this.nextWord)) {
                configuration.adaptResourceFileNames = this.parseCommaSeparatedList("resource file name", true, true, false, false, false, false, false, configuration.adaptResourceFileNames);
                continue;
            }
            if ("-adaptresourcefilecontents".startsWith(this.nextWord)) {
                configuration.adaptResourceFileContents = this.parseCommaSeparatedList("resource file name", true, true, false, false, false, false, false, configuration.adaptResourceFileContents);
                continue;
            }
            if ("-dontpreverify".startsWith(this.nextWord)) {
                configuration.preverify = this.parseNoArgument(false);
                continue;
            }
            if ("-microedition".startsWith(this.nextWord)) {
                configuration.microEdition = this.parseNoArgument(true);
                continue;
            }
            if ("-verbose".startsWith(this.nextWord)) {
                configuration.verbose = this.parseNoArgument(true);
                continue;
            }
            if ("-dontnote".startsWith(this.nextWord)) {
                configuration.note = this.parseCommaSeparatedList("class name", true, true, false, true, false, true, false, configuration.note);
                continue;
            }
            if ("-dontwarn".startsWith(this.nextWord)) {
                configuration.warn = this.parseCommaSeparatedList("class name", true, true, false, true, false, true, false, configuration.warn);
                continue;
            }
            if ("-ignorewarnings".startsWith(this.nextWord)) {
                configuration.ignoreWarnings = this.parseNoArgument(true);
                continue;
            }
            if ("-printconfiguration".startsWith(this.nextWord)) {
                configuration.printConfiguration = this.parseOptionalFile();
                continue;
            }
            if ("-dump".startsWith(this.nextWord)) {
                configuration.dump = this.parseOptionalFile();
                continue;
            }
            throw new ParseException("Unknown option " + this.reader.locationDescription());
        }
    }

    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
    }

    private long parseIncludeArgument(long l) throws ParseException, IOException {
        this.readNextWord("configuration file name");
        File file = this.file(this.nextWord);
        this.reader.includeWordReader(new FileWordReader(file));
        this.readNextWord();
        return Math.max(l, file.lastModified());
    }

    private void parseBaseDirectoryArgument() throws ParseException, IOException {
        this.readNextWord("base directory name");
        this.reader.setBaseDir(this.file(this.nextWord));
        this.readNextWord();
    }

    private ClassPath parseClassPathArgument(ClassPath classPath, boolean bl) throws ParseException, IOException {
        if (classPath == null) {
            classPath = new ClassPath();
        }
        do {
            this.readNextWord("jar or directory name");
            ClassPathEntry classPathEntry = new ClassPathEntry(this.file(this.nextWord), bl);
            this.readNextWord();
            if (!this.configurationEnd() && "(".equals(this.nextWord)) {
                List[] listArray = new List[5];
                int n = 0;
                do {
                    listArray[n++] = this.parseCommaSeparatedList("filter", true, false, true, false, true, false, false, null);
                } while (n < listArray.length && ";".equals(this.nextWord));
                if (!")".equals(this.nextWord)) {
                    throw new ParseException("Expecting separating ',' or ';', or closing ')' before " + this.reader.locationDescription());
                }
                classPathEntry.setFilter(listArray[--n]);
                if (n > 0) {
                    classPathEntry.setJarFilter(listArray[--n]);
                    if (n > 0) {
                        classPathEntry.setWarFilter(listArray[--n]);
                        if (n > 0) {
                            classPathEntry.setEarFilter(listArray[--n]);
                            if (n > 0) {
                                classPathEntry.setZipFilter(listArray[--n]);
                            }
                        }
                    }
                }
                this.readNextWord();
            }
            classPath.add(classPathEntry);
            if (!this.configurationEnd()) continue;
            return classPath;
        } while (this.nextWord.equals(ConfigurationConstants.JAR_SEPARATOR_KEYWORD));
        throw new ParseException("Expecting class path separator '" + ConfigurationConstants.JAR_SEPARATOR_KEYWORD + "' before " + this.reader.locationDescription());
    }

    private int parseClassVersion() throws ParseException, IOException {
        this.readNextWord("java version");
        int n = ClassUtil.internalClassVersion(this.nextWord);
        if (n == 0) {
            throw new ParseException("Unsupported java version " + this.reader.locationDescription());
        }
        this.readNextWord();
        return n;
    }

    private int parseIntegerArgument() throws ParseException, IOException {
        try {
            this.readNextWord("integer");
            int n = Integer.parseInt(this.nextWord);
            this.readNextWord();
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("Expecting integer argument instead of '" + this.nextWord + "' before " + this.reader.locationDescription());
        }
    }

    private File parseFile() throws ParseException, IOException {
        this.readNextWord("file name");
        File file = this.file(this.nextWord);
        this.readNextWord();
        return file;
    }

    private File parseOptionalFile() throws ParseException, IOException {
        this.readNextWord();
        if (this.configurationEnd()) {
            return new File("");
        }
        File file = this.file(this.nextWord);
        this.readNextWord();
        return file;
    }

    private String parseOptionalArgument() throws IOException {
        this.readNextWord();
        if (this.configurationEnd()) {
            return "";
        }
        String string = this.nextWord;
        this.readNextWord();
        return string;
    }

    private boolean parseNoArgument(boolean bl) throws IOException {
        this.readNextWord();
        return bl;
    }

    private long parseNoArgument(long l) throws IOException {
        this.readNextWord();
        return l;
    }

    private List parseKeepClassSpecificationArguments(List arrayList, boolean bl, boolean bl2, boolean bl3) throws ParseException, IOException {
        boolean bl4;
        boolean bl5;
        block4: {
            if (arrayList == null) {
                arrayList = new ArrayList<KeepClassSpecification>();
            }
            bl5 = false;
            bl4 = false;
            while (true) {
                this.readNextWord("keyword 'class', 'interface', or 'enum'", true);
                if (!",".equals(this.nextWord)) break block4;
                this.readNextWord("keyword 'allowshrinking', 'allowoptimization', or 'allowobfuscation'");
                if ("allowshrinking".startsWith(this.nextWord)) {
                    bl3 = true;
                    continue;
                }
                if ("allowoptimization".startsWith(this.nextWord)) {
                    bl5 = true;
                    continue;
                }
                if (!"allowobfuscation".startsWith(this.nextWord)) break;
                bl4 = true;
            }
            throw new ParseException("Expecting keyword 'allowshrinking', 'allowoptimization', or 'allowobfuscation' before " + this.reader.locationDescription());
        }
        ClassSpecification classSpecification = this.parseClassSpecificationArguments();
        arrayList.add(new KeepClassSpecification(bl, bl2, bl3, bl5, bl4, classSpecification));
        return arrayList;
    }

    private List parseClassSpecificationArguments(List arrayList) throws ParseException, IOException {
        if (arrayList == null) {
            arrayList = new ArrayList<ClassSpecification>();
        }
        this.readNextWord("keyword 'class', 'interface', or 'enum'", true);
        arrayList.add(this.parseClassSpecificationArguments());
        return arrayList;
    }

    private ClassSpecification parseClassSpecificationArguments() throws ParseException, IOException {
        Object object;
        String string;
        String string2 = null;
        int n = 0;
        int n2 = 0;
        while (!"class".equals(this.nextWord)) {
            int n3;
            String string3 = string = this.nextWord.startsWith("!") ? this.nextWord.substring(1) : this.nextWord;
            int n4 = string.equals("public") ? 1 : (string.equals("final") ? 16 : (string.equals("interface") ? 512 : (string.equals("abstract") ? 1024 : (string.equals("synthetic") ? 4096 : (string.equals("@") ? 8192 : (n3 = string.equals("enum") ? 16384 : this.unknownAccessFlag()))))));
            if (n3 == 8192) {
                this.readNextWord("annotation type or keyword 'interface'", false);
                if (!(this.nextWord.equals("interface") || this.nextWord.equals("enum") || this.nextWord.equals("class"))) {
                    string2 = ListUtil.commaSeparatedString(this.parseCommaSeparatedList("annotation type", false, false, false, true, false, false, true, null), false);
                    continue;
                }
            }
            if (string.equals(this.nextWord)) {
                n |= n3;
            } else {
                n2 |= n3;
            }
            if ((n & n2) != 0) {
                throw new ParseException("Conflicting class access modifiers for '" + string + "' before " + this.reader.locationDescription());
            }
            if (string.equals("interface") || string.equals("enum") || string.equals("class")) break;
            this.readNextWord("keyword 'class', 'interface', or 'enum'", true);
        }
        String string4 = "*".equals(string = ListUtil.commaSeparatedString(this.parseCommaSeparatedList("class name or interface name", true, false, false, true, false, false, false, null), false)) ? null : ClassUtil.internalClassName(string);
        String string5 = null;
        String string6 = null;
        if (!this.configurationEnd() && ("implements".equals(this.nextWord) || "extends".equals(this.nextWord))) {
            this.readNextWord("class name or interface name", true);
            if ("@".equals(this.nextWord)) {
                string5 = ListUtil.commaSeparatedString(this.parseCommaSeparatedList("annotation type", true, false, false, true, false, false, true, null), false);
            }
            string6 = "*".equals(object = ListUtil.commaSeparatedString(this.parseCommaSeparatedList("class name or interface name", false, false, false, true, false, false, false, null), false)) ? null : ClassUtil.internalClassName((String)object);
        }
        object = new ClassSpecification(this.lastComments, n, n2, string2, string4, string5, string6);
        if (!this.configurationEnd()) {
            if (!"{".equals(this.nextWord)) {
                throw new ParseException("Expecting opening '{' at " + this.reader.locationDescription());
            }
            while (true) {
                this.readNextWord("class member description or closing '}'", true);
                if (this.nextWord.equals("}")) {
                    this.readNextWord();
                    break;
                }
                this.parseMemberSpecificationArguments(string, (ClassSpecification)object);
            }
        }
        return object;
    }

    private void parseMemberSpecificationArguments(String string, ClassSpecification classSpecification) throws ParseException, IOException {
        String string2;
        String string3 = null;
        int n = 0;
        int n2 = 0;
        while (!this.configurationEnd(true)) {
            int n3;
            if ("@".equals(this.nextWord)) {
                string3 = ListUtil.commaSeparatedString(this.parseCommaSeparatedList("annotation type", true, false, false, true, false, false, true, null), false);
                continue;
            }
            String string4 = string2 = this.nextWord.startsWith("!") ? this.nextWord.substring(1) : this.nextWord;
            int n4 = string2.equals("public") ? 1 : (string2.equals("private") ? 2 : (string2.equals("protected") ? 4 : (string2.equals("static") ? 8 : (string2.equals("final") ? 16 : (string2.equals("synchronized") ? 32 : (string2.equals("volatile") ? 64 : (string2.equals("transient") ? 128 : (string2.equals("bridge") ? 64 : (string2.equals("varargs") ? 128 : (string2.equals("native") ? 256 : (string2.equals("abstract") ? 1024 : (string2.equals("strictfp") ? 2048 : (n3 = string2.equals("synthetic") ? 4096 : 0)))))))))))));
            if (n3 == 0) break;
            if (string2.equals(this.nextWord)) {
                n |= n3;
            } else {
                n2 |= n3;
            }
            if ((n & n2) != 0) {
                throw new ParseException("Conflicting class member access modifiers for " + this.reader.locationDescription());
            }
            this.readNextWord("class member description");
        }
        if ("*".equals(this.nextWord) || "<fields>".equals(this.nextWord) || "<methods>".equals(this.nextWord)) {
            if ("*".equals(this.nextWord)) {
                this.checkFieldAccessFlags(n, n2);
                this.checkMethodAccessFlags(n, n2);
                classSpecification.addField(new MemberSpecification(n, n2, string3, null, null));
                classSpecification.addMethod(new MemberSpecification(n, n2, string3, null, null));
            } else if ("<fields>".equals(this.nextWord)) {
                this.checkFieldAccessFlags(n, n2);
                classSpecification.addField(new MemberSpecification(n, n2, string3, null, null));
            } else if ("<methods>".equals(this.nextWord)) {
                this.checkMethodAccessFlags(n, n2);
                classSpecification.addMethod(new MemberSpecification(n, n2, string3, null, null));
            }
            this.readNextWord("separator ';'");
            if (!";".equals(this.nextWord)) {
                throw new ParseException("Expecting separator ';' before " + this.reader.locationDescription());
            }
        } else {
            this.checkJavaIdentifier("java type");
            string2 = this.nextWord;
            this.readNextWord("class member name");
            String string5 = this.nextWord;
            if ("(".equals(string5)) {
                if (!(string2.equals("<init>") || string2.equals(string) || string2.equals(ClassUtil.externalShortClassName(string)))) {
                    throw new ParseException("Expecting type and name instead of just '" + string2 + "' before " + this.reader.locationDescription());
                }
                string2 = "void";
                string5 = "<init>";
            } else {
                this.checkJavaIdentifier("class member name");
                this.readNextWord("opening '(' or separator ';'");
            }
            if (";".equals(this.nextWord)) {
                this.checkFieldAccessFlags(n, n2);
                String string6 = ClassUtil.internalType(string2);
                classSpecification.addField(new MemberSpecification(n, n2, string3, string5, string6));
            } else if ("(".equals(this.nextWord)) {
                this.checkMethodAccessFlags(n, n2);
                String string7 = ClassUtil.internalMethodDescriptor(string2, this.parseCommaSeparatedList("argument", true, true, true, true, false, false, false, null));
                if (!")".equals(this.nextWord)) {
                    throw new ParseException("Expecting separating ',' or closing ')' before " + this.reader.locationDescription());
                }
                this.readNextWord("separator ';'");
                if (!";".equals(this.nextWord)) {
                    throw new ParseException("Expecting separator ';' before " + this.reader.locationDescription());
                }
                classSpecification.addMethod(new MemberSpecification(n, n2, string3, string5, string7));
            } else {
                throw new ParseException("Expecting opening '(' or separator ';' before " + this.reader.locationDescription());
            }
        }
    }

    private List parseCommaSeparatedList(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, List arrayList) throws ParseException, IOException {
        if (arrayList == null) {
            arrayList = new ArrayList<String>();
        }
        if (bl) {
            if (bl3 || !bl2) {
                this.readNextWord(string);
            } else {
                this.readNextWord();
                if (this.configurationEnd() || this.nextWord.equals("*")) {
                    return arrayList;
                }
            }
        }
        while (!bl3 || arrayList.size() != 0 || !")".equals(this.nextWord) && !";".equals(this.nextWord)) {
            if (bl4) {
                this.checkJavaIdentifier("java type");
            }
            if (bl5) {
                this.nextWord = this.replaceSystemProperties(this.nextWord);
            }
            if (bl6) {
                this.nextWord = ClassUtil.internalClassName(this.nextWord);
            }
            if (bl7) {
                this.nextWord = ClassUtil.internalType(this.nextWord);
            }
            arrayList.add(this.nextWord);
            if (bl3) {
                this.readNextWord("separating ',' or closing ')'");
            } else {
                this.readNextWord();
            }
            if (!",".equals(this.nextWord)) break;
            this.readNextWord(string);
        }
        return arrayList;
    }

    private int unknownAccessFlag() throws ParseException {
        throw new ParseException("Unexpected keyword " + this.reader.locationDescription());
    }

    private File file(String string) throws ParseException {
        String string2 = this.replaceSystemProperties(string);
        File file = new File(string2);
        if (!file.isAbsolute()) {
            file = new File(this.reader.getBaseDir(), string2);
        }
        return file;
    }

    private String replaceSystemProperties(String string) throws ParseException {
        int n = 0;
        while ((n = string.indexOf(60, n)) >= 0) {
            int n2 = string.indexOf(62, n + 1);
            if (n2 < 0) {
                throw new ParseException("Expecting closing '>' after opening '<' in " + this.reader.locationDescription());
            }
            String string2 = string.substring(n + 1, n2);
            String string3 = System.getProperty(string2);
            if (string3 == null) {
                throw new ParseException("Value of system property '" + string2 + "' is undefined in " + this.reader.locationDescription());
            }
            string = string.substring(0, n) + string3 + string.substring(n2 + 1);
        }
        return string;
    }

    private void readNextWord(String string) throws ParseException, IOException {
        this.readNextWord(string, false);
    }

    private void readNextWord(String string, boolean bl) throws ParseException, IOException {
        this.readNextWord();
        if (this.configurationEnd(bl)) {
            throw new ParseException("Expecting " + string + " before " + this.reader.locationDescription());
        }
    }

    private void readNextWord() throws IOException {
        this.nextWord = this.reader.nextWord();
    }

    private boolean configurationEnd() {
        return this.configurationEnd(false);
    }

    private boolean configurationEnd(boolean bl) {
        return this.nextWord == null || this.nextWord.startsWith("-") || !bl && this.nextWord.equals("@");
    }

    private void checkJavaIdentifier(String string) throws ParseException {
        if (!this.isJavaIdentifier(this.nextWord)) {
            throw new ParseException("Expecting " + string + " before " + this.reader.locationDescription());
        }
    }

    private boolean isJavaIdentifier(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isJavaIdentifierPart(c) || c == '.' || c == '[' || c == ']' || c == '<' || c == '>' || c == '-' || c == '!' || c == '*' || c == '?' || c == '%') continue;
            return false;
        }
        return true;
    }

    private void checkFieldAccessFlags(int n, int n2) throws ParseException {
        if (((n | n2) & 0xFFFFAF20) != 0) {
            throw new ParseException("Invalid method access modifier for field before " + this.reader.locationDescription());
        }
    }

    private void checkMethodAccessFlags(int n, int n2) throws ParseException {
        if (((n | n2) & 0xFFFFE200) != 0) {
            throw new ParseException("Invalid field access modifier for method before " + this.reader.locationDescription());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        try {
            ConfigurationParser configurationParser = new ConfigurationParser(stringArray);
            try {
                configurationParser.parse(new Configuration());
            }
            catch (ParseException parseException) {
                parseException.printStackTrace();
            }
            finally {
                configurationParser.close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

