/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.jtiger;

import com.fluendo.jkate.Event;
import com.fluendo.jkate.Tracker;
import com.fluendo.jtiger.TextRenderer;
import com.fluendo.jtiger.TigerBitmap;
import com.fluendo.utils.Debug;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;

public class Item {
    private Tracker kin = null;
    private boolean alive = false;
    private Font font = null;
    private int font_size = 0;
    private String text = null;
    private TigerBitmap background_image = null;
    private int width = -1;
    private int height = -1;
    private Rectangle region = new Rectangle();
    private boolean dirty = true;
    private static TextRenderer textRenderer = Item.detectTextRenderer();

    private static TextRenderer detectTextRenderer() {
        TextRenderer tr = null;
        try {
            Class<?> c = Class.forName("com.fluendo.jtiger.BasicTextRenderer");
            tr = (TextRenderer)c.newInstance();
            Debug.info("jtiger.Item: detecting Graphics2D");
            Class.forName("java.awt.Graphics2D");
            Debug.info("jtiger.Item: detecting TextLayout");
            Class.forName("java.awt.font.TextLayout");
            Debug.info("jtiger.Item: detecting AttributedString");
            Class.forName("java.text.AttributedString");
            c = Class.forName("com.fluendo.jtiger.FancyTextRenderer");
            tr = (TextRenderer)c.newInstance();
            Debug.info("jtiger.Item: We can use the fancy text renderer");
        }
        catch (Throwable e) {
            if (tr == null) {
                Debug.info("jtiger.Item: We cannot use any text renderer: " + e.toString());
            }
            Debug.info("jtiger.Item: We have to use the basic text renderer: " + e.toString());
        }
        return tr;
    }

    public Item(Event ev) {
        this.kin = new Tracker(ev);
        this.text = null;
        if (ev.text != null && ev.text.length > 0) {
            try {
                this.text = new String(ev.text, "UTF8");
            }
            catch (Exception e) {
                Debug.warning("Failed to convert text from UTF-8 - text will not display");
                this.text = null;
            }
        }
        this.dirty = false;
    }

    protected void createFont(Component c, Image img) {
        this.font_size = img.getWidth(null) / 32;
        if (this.font_size < 12) {
            this.font_size = 12;
        }
        this.font = new Font("sansserif", 1, this.font_size);
    }

    protected void updateCachedData(Component c, Image img) {
        int img_width = img.getWidth(null);
        int img_height = img.getHeight(null);
        if (img_width == this.width && img_height == this.height) {
            return;
        }
        this.createFont(c, img);
        this.width = img_width;
        this.height = img_height;
        this.dirty = true;
    }

    public boolean update(Component c, Dimension d, double t) {
        Event ev = this.kin.ev;
        if (ev == null) {
            return false;
        }
        if (t < ev.start_time) {
            return true;
        }
        if (t >= ev.end_time) {
            this.alive = false;
            this.dirty = true;
            return false;
        }
        if (!this.alive) {
            this.alive = true;
            this.dirty = true;
        }
        return this.kin.update(t - ev.start_time, d, d);
    }

    public void setupRegion(Component c, Image img) {
        if (this.kin.has[0]) {
            this.region.x = (int)(this.kin.region_x + 0.5f);
            this.region.y = (int)(this.kin.region_y + 0.5f);
            this.region.width = (int)(this.kin.region_w + 0.5f);
            this.region.height = (int)(this.kin.region_h + 0.5f);
        } else {
            Dimension d = new Dimension(img.getWidth(null), img.getHeight(null));
            this.region.x = (int)((float)d.width * 0.1f + 0.5f);
            this.region.y = (int)((float)d.height * 0.8f + 0.5f);
            this.region.width = (int)((float)d.width * 0.8f + 0.5f);
            this.region.height = (int)((float)d.height * 0.1f + 0.5f);
        }
    }

    public void render(Component c, Image img) {
        if (!this.alive) {
            return;
        }
        this.updateCachedData(c, img);
        this.setupRegion(c, img);
        this.renderBackground(c, img);
        this.renderText(img);
        this.dirty = false;
    }

    public void renderBackground(Component c, Image img) {
        if (this.kin.ev.bitmap != null) {
            if (this.background_image == null) {
                this.background_image = new TigerBitmap(c, this.kin.ev.bitmap, this.kin.ev.palette);
            }
            Graphics g = img.getGraphics();
            g.drawImage(this.background_image.getScaled(this.region.width, this.region.height), this.region.x, this.region.y, null);
            g.dispose();
        }
    }

    public void renderText(Image img) {
        if (this.text == null) {
            return;
        }
        Graphics g = img.getGraphics();
        if (textRenderer != null) {
            textRenderer.renderText(g, this.region, this.font, this.text);
        }
        g.dispose();
    }

    public boolean isDirty() {
        return this.dirty;
    }
}

