
/*
 * NewJPanel.java <p/> Created on 20 juil. 2011, 14:50:22
 */
package com.jme3.gde.core.scene.controller.toolbars;

import com.jme3.gde.core.sceneviewer.SceneViewerTopComponent;
import com.jme3.gde.core.sceneviewer.actions.SwitchBackViewAction;
import com.jme3.gde.core.sceneviewer.actions.SwitchBottomViewAction;
import com.jme3.gde.core.sceneviewer.actions.SwitchFrontViewAction;
import com.jme3.gde.core.sceneviewer.actions.SwitchLeftViewAction;
import com.jme3.gde.core.sceneviewer.actions.SwitchRightViewAction;
import com.jme3.gde.core.sceneviewer.actions.SwitchTopViewAction;
import com.jme3.gde.core.sceneviewer.actions.ToggleOrthoPerspAction;
import com.jme3.gde.core.util.CameraUtil.View;
import javax.swing.ImageIcon;
import org.openide.util.NbBundle;

/**
 *
 * @author Nehon
 */
public class CameraToolbar extends javax.swing.JToolBar {

    protected boolean isUserView = true;
    private static CameraToolbar instance;
    ImageIcon userIcon = new ImageIcon(getClass().getResource("/com/jme3/gde/core/scene/controller/toolbars/user.png"));
    //toolbar actions
    private ToggleOrthoPerspAction toggleOrthoPerspAction;
    private SwitchFrontViewAction switchFrontViewAction;
    private SwitchLeftViewAction switchLeftViewAction;
    private SwitchRightViewAction switchRightViewAction;
    private SwitchTopViewAction switchTopViewAction;
    private SwitchBackViewAction switchBackViewAction;
    private SwitchBottomViewAction switchBottomViewAction;

    /**
     * Creates new form NewJPanel
     */
    protected CameraToolbar() {
        toggleOrthoPerspAction = new ToggleOrthoPerspAction();
        switchFrontViewAction = new SwitchFrontViewAction();
        switchLeftViewAction = new SwitchLeftViewAction();
        switchBackViewAction = new SwitchBackViewAction();
        switchBottomViewAction = new SwitchBottomViewAction();
        switchTopViewAction = new SwitchTopViewAction();
        switchRightViewAction = new SwitchRightViewAction();
        initComponents();
    }

    public static CameraToolbar getInstance() {
        if (instance == null) {
            instance = new CameraToolbar();
        }
        return instance;
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        viewMenu = new javax.swing.JPopupMenu();
        frontMenuItem = new javax.swing.JMenuItem();
        leftMenuItem = new javax.swing.JMenuItem();
        rightMenuItem = new javax.swing.JMenuItem();
        topMenuItem = new javax.swing.JMenuItem();
        backMenuItem = new javax.swing.JMenuItem();
        bottomMenuItem = new javax.swing.JMenuItem();
        viewButton = new javax.swing.JButton();
        enableOrtho = new javax.swing.JToggleButton();

        frontMenuItem.setIcon(new javax.swing.ImageIcon(getClass().getResource("/com/jme3/gde/core/scene/controller/toolbars/front.png"))); // NOI18N
        frontMenuItem.setText(org.openide.util.NbBundle.getMessage(CameraToolbar.class, "CameraToolbar.frontMenuItem.text")); // NOI18N
        frontMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                frontMenuItemActionPerformed(evt);
            }
        });
        viewMenu.add(frontMenuItem);

        leftMenuItem.setIcon(new javax.swing.ImageIcon(getClass().getResource("/com/jme3/gde/core/scene/controller/toolbars/left.png"))); // NOI18N
        leftMenuItem.setText(org.openide.util.NbBundle.getMessage(CameraToolbar.class, "CameraToolbar.leftMenuItem.text")); // NOI18N
        leftMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                leftMenuItemActionPerformed(evt);
            }
        });
        viewMenu.add(leftMenuItem);

        rightMenuItem.setIcon(new javax.swing.ImageIcon(getClass().getResource("/com/jme3/gde/core/scene/controller/toolbars/right.png"))); // NOI18N
        rightMenuItem.setText(org.openide.util.NbBundle.getMessage(CameraToolbar.class, "CameraToolbar.rightMenuItem.text")); // NOI18N
        rightMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                rightMenuItemActionPerformed(evt);
            }
        });
        viewMenu.add(rightMenuItem);

        topMenuItem.setIcon(new javax.swing.ImageIcon(getClass().getResource("/com/jme3/gde/core/scene/controller/toolbars/top.png"))); // NOI18N
        topMenuItem.setText(org.openide.util.NbBundle.getMessage(CameraToolbar.class, "CameraToolbar.topMenuItem.text")); // NOI18N
        topMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                topMenuItemActionPerformed(evt);
            }
        });
        viewMenu.add(topMenuItem);

        backMenuItem.setIcon(new javax.swing.ImageIcon(getClass().getResource("/com/jme3/gde/core/scene/controller/toolbars/back.png"))); // NOI18N
        backMenuItem.setText(org.openide.util.NbBundle.getMessage(CameraToolbar.class, "CameraToolbar.backMenuItem.text")); // NOI18N
        backMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                backMenuItemActionPerformed(evt);
            }
        });
        viewMenu.add(backMenuItem);

        bottomMenuItem.setIcon(new javax.swing.ImageIcon(getClass().getResource("/com/jme3/gde/core/scene/controller/toolbars/bottom.png"))); // NOI18N
        bottomMenuItem.setText(org.openide.util.NbBundle.getMessage(CameraToolbar.class, "CameraToolbar.bottomMenuItem.text")); // NOI18N
        bottomMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bottomMenuItemActionPerformed(evt);
            }
        });
        viewMenu.add(bottomMenuItem);

        viewButton.setFont(new java.awt.Font("Tahoma", 0, 8));
        viewButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/com/jme3/gde/core/scene/controller/toolbars/user.png"))); // NOI18N
        viewButton.setText(org.openide.util.NbBundle.getMessage(CameraToolbar.class, "CameraToolbar.viewButton.text")); // NOI18N
        viewButton.setFocusable(false);
        viewButton.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        viewButton.setHorizontalTextPosition(javax.swing.SwingConstants.RIGHT);
        viewButton.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        viewButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                viewButtonActionPerformed(evt);
            }
        });

        enableOrtho.setFont(new java.awt.Font("Tahoma", 0, 8));
        enableOrtho.setIcon(new javax.swing.ImageIcon(getClass().getResource("/com/jme3/gde/core/sceneviewer/icons/persp.png"))); // NOI18N
        enableOrtho.setText(org.openide.util.NbBundle.getMessage(CameraToolbar.class, "CameraToolbar.enableOrtho.text")); // NOI18N
        enableOrtho.setToolTipText(org.openide.util.NbBundle.getMessage(CameraToolbar.class, "CameraToolbar.enableOrtho.toolTipText")); // NOI18N
        enableOrtho.setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
        enableOrtho.setFocusable(false);
        enableOrtho.setHorizontalTextPosition(javax.swing.SwingConstants.RIGHT);
        enableOrtho.setMaximumSize(new java.awt.Dimension(27, 23));
        enableOrtho.setMinimumSize(new java.awt.Dimension(27, 23));
        enableOrtho.setPreferredSize(new java.awt.Dimension(50, 23));
        enableOrtho.setSelectedIcon(new javax.swing.ImageIcon(getClass().getResource("/com/jme3/gde/core/sceneviewer/icons/ortho.png"))); // NOI18N
        enableOrtho.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        enableOrtho.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                enableOrthoActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(viewButton)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(enableOrtho, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(96, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(viewButton, javax.swing.GroupLayout.PREFERRED_SIZE, 23, javax.swing.GroupLayout.PREFERRED_SIZE)
            .addComponent(enableOrtho, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
        );
    }// </editor-fold>//GEN-END:initComponents

private void viewButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_viewButtonActionPerformed
    viewMenu.show(viewButton, 0, -viewMenu.getHeight());
}//GEN-LAST:event_viewButtonActionPerformed

private void frontMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_frontMenuItemActionPerformed
    SceneViewerTopComponent.findInstance().requestActive();
    final java.awt.event.ActionEvent e = evt;
    java.awt.EventQueue.invokeLater(new Runnable() {

        public void run() {
            switchFrontViewAction.actionPerformed(e);
        }
    });

}//GEN-LAST:event_frontMenuItemActionPerformed

private void leftMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_leftMenuItemActionPerformed
    SceneViewerTopComponent.findInstance().requestActive();
    final java.awt.event.ActionEvent e = evt;
    java.awt.EventQueue.invokeLater(new Runnable() {

        public void run() {
            switchLeftViewAction.actionPerformed(e);
        }
    });
}//GEN-LAST:event_leftMenuItemActionPerformed

private void rightMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_rightMenuItemActionPerformed
    SceneViewerTopComponent.findInstance().requestActive();
    final java.awt.event.ActionEvent e = evt;
    java.awt.EventQueue.invokeLater(new Runnable() {

        public void run() {
            switchRightViewAction.actionPerformed(e);
        }
    });
}//GEN-LAST:event_rightMenuItemActionPerformed

private void topMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_topMenuItemActionPerformed
    SceneViewerTopComponent.findInstance().requestActive();
    final java.awt.event.ActionEvent e = evt;
    java.awt.EventQueue.invokeLater(new Runnable() {

        public void run() {
            switchTopViewAction.actionPerformed(e);
        }
    });
}//GEN-LAST:event_topMenuItemActionPerformed

private void backMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_backMenuItemActionPerformed
    SceneViewerTopComponent.findInstance().requestActive();
    final java.awt.event.ActionEvent e = evt;
    java.awt.EventQueue.invokeLater(new Runnable() {

        public void run() {
            switchBackViewAction.actionPerformed(e);
        }
    });
}//GEN-LAST:event_backMenuItemActionPerformed

private void bottomMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bottomMenuItemActionPerformed
    SceneViewerTopComponent.findInstance().requestActive();
    final java.awt.event.ActionEvent e = evt;
    java.awt.EventQueue.invokeLater(new Runnable() {

        public void run() {
            switchBottomViewAction.actionPerformed(e);
        }
    });
}//GEN-LAST:event_bottomMenuItemActionPerformed

private void enableOrthoActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_enableOrthoActionPerformed
    SceneViewerTopComponent.findInstance().requestActive();
    final java.awt.event.ActionEvent e = evt;
    java.awt.EventQueue.invokeLater(new Runnable() {

        public void run() {
            toggleOrthoPerspAction.actionPerformed(e);
        }
    });

}//GEN-LAST:event_enableOrthoActionPerformed
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JMenuItem backMenuItem;
    private javax.swing.JMenuItem bottomMenuItem;
    private javax.swing.JToggleButton enableOrtho;
    private javax.swing.JMenuItem frontMenuItem;
    private javax.swing.JMenuItem leftMenuItem;
    private javax.swing.JMenuItem rightMenuItem;
    private javax.swing.JMenuItem topMenuItem;
    private javax.swing.JButton viewButton;
    private javax.swing.JPopupMenu viewMenu;
    // End of variables declaration//GEN-END:variables

    public void switchToView(View view) {

        switch (view) {
            case Front:
                viewButton.setIcon(frontMenuItem.getIcon());
                viewButton.setText(frontMenuItem.getText());
                isUserView = false;
                break;
            case Left:
                viewButton.setIcon(leftMenuItem.getIcon());
                viewButton.setText(leftMenuItem.getText());
                isUserView = false;
                break;
            case Right:
                viewButton.setIcon(rightMenuItem.getIcon());
                viewButton.setText(rightMenuItem.getText());
                isUserView = false;
                break;
            case Back:
                viewButton.setIcon(backMenuItem.getIcon());
                viewButton.setText(backMenuItem.getText());
                isUserView = false;
                break;
            case Top:
                viewButton.setIcon(topMenuItem.getIcon());
                viewButton.setText(topMenuItem.getText());
                isUserView = false;
                break;
            case Bottom:
                viewButton.setIcon(bottomMenuItem.getIcon());
                viewButton.setText(bottomMenuItem.getText());
                isUserView = false;
                break;
            case User:
            default:
                if (!isUserView) {
                    viewButton.setIcon(userIcon);
                    viewButton.setText(NbBundle.getMessage(CameraToolbar.class, "CameraToolbar.viewButton.label"));
                    isUserView = true;
                }
        }
    }

    public void toggleOrthoMode(boolean enabled) {
        enableOrtho.setText(NbBundle.getMessage(CameraToolbar.class, "CameraToolbar.enableOrtho.text" + (enabled ? "O" : "")));
        enableOrtho.setSelected(enabled);
    }
}
