/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * MaterialPreviewWidget.java
 *
 * Created on 1 août 2011, 10:27:05
 */
package com.jme3.gde.materials.multiview.widgets;

import com.jme3.asset.MaterialKey;
import com.jme3.gde.core.assets.ProjectAssetManager;
import com.jme3.gde.core.scene.PreviewRequest;
import com.jme3.gde.core.scene.SceneApplication;
import com.jme3.gde.core.scene.SceneListener;
import com.jme3.gde.core.scene.SceneRequest;
import com.jme3.material.Material;
import com.jme3.math.FastMath;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.shape.Box;
import com.jme3.scene.shape.Quad;
import com.jme3.scene.shape.Sphere;
import com.jme3.util.TangentBinormalGenerator;
import javax.swing.ImageIcon;

/**
 *
 * @author Nehon
 */
public class MaterialPreviewWidget extends javax.swing.JPanel implements SceneListener {

    private Geometry sphere;
    private Geometry box;
    private Geometry quad;
    private Geometry currentGeom;
    private Material currentMaterial;
    private boolean init=false;

    /** Creates new form MaterialPreviewWidget */
    public MaterialPreviewWidget() {
        initComponents();        
    }

    private  void initWidget() {
        SceneApplication.getApplication().addSceneListener(this);
        Sphere sphMesh = new Sphere(32, 32, 2.5f);
        sphMesh.setTextureMode(Sphere.TextureMode.Projected);
        sphMesh.updateGeometry(32, 32, 2.5f, false, false);
        TangentBinormalGenerator.generate(sphMesh);
        sphere = new Geometry("previewSphere", sphMesh);
        sphere.setLocalRotation(new Quaternion().fromAngleAxis(FastMath.QUARTER_PI, Vector3f.UNIT_X));

        Box boxMesh = new Box(new Vector3f(0, 0, 0), 1.75f, 1.75f, 1.75f);
        TangentBinormalGenerator.generate(boxMesh);
        box = new Geometry("previewBox", boxMesh);
        box.setLocalRotation(new Quaternion().fromAngleAxis(-FastMath.DEG_TO_RAD * 30, Vector3f.UNIT_X).multLocal(new Quaternion().fromAngleAxis(FastMath.QUARTER_PI, Vector3f.UNIT_Y)));

        Quad quadMesh = new Quad(4.5f, 4.5f);
        TangentBinormalGenerator.generate(quadMesh);
        quad = new Geometry("previewQuad", quadMesh);
        quad.setLocalTranslation(new Vector3f(-2.25f, -2.25f, 0));

        currentGeom = sphere;
        sphereButton.setSelected(true);
        init=true;
    }

    @SuppressWarnings("unchecked")
    public void showMaterial(ProjectAssetManager assetManager, String materialFileName) {
        if(!init){
            initWidget();
        }
        try {
            MaterialKey key = new MaterialKey(assetManager.getRelativeAssetPath(materialFileName));
            assetManager.deleteFromCache(key);
            Material mat = (Material) assetManager.loadAsset(key);
            if (mat != null) {
                currentMaterial = mat;
                doShowMaterial(mat);
            }
        } catch (Exception e) {
        }
    }

    private void doShowMaterial(Material m) {

//        geom.setLocalTranslation(-2.5f, -2.5f, 0);
//        geom.lookAt(new Vector3f(5, 5, 5), Vector3f.UNIT_Y);
        currentGeom.setMaterial(m);
        if (currentGeom.getMaterial() != null) {
            PreviewRequest request = new PreviewRequest(this, currentGeom);
            request.getCameraRequest().setLocation(new Vector3f(0, 0, 7));
            request.getCameraRequest().setLookAt(new Vector3f(0, 0, 0), Vector3f.UNIT_Y);
            SceneApplication.getApplication().createPreview(request);
        }
    }

    public void clear() {
        previewLabel.setIcon(null);
    }

    public void sceneRequested(SceneRequest request) {
    }

    public boolean sceneClose(SceneRequest request) {
        return true;
    }

    public void cleanUp(){
         SceneApplication.getApplication().removeSceneListener(this);
    }
    
    public void previewRequested(PreviewRequest request) {        
        if (request.getRequester() == this) {
            final ImageIcon icon = new ImageIcon(request.getImage());
            java.awt.EventQueue.invokeLater(new Runnable() {

                public void run() {
                    previewLabel.setIcon(icon);
                }
            });
        }
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        toggleButtonGroup = new javax.swing.ButtonGroup();
        previewLabel = new javax.swing.JLabel();
        jToolBar1 = new javax.swing.JToolBar();
        sphereButton = new javax.swing.JToggleButton();
        cubeButton = new javax.swing.JToggleButton();
        planeButton = new javax.swing.JToggleButton();

        previewLabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        previewLabel.setText(org.openide.util.NbBundle.getMessage(MaterialPreviewWidget.class, "MaterialPreviewWidget.previewLabel.text")); // NOI18N

        jToolBar1.setFloatable(false);
        jToolBar1.setRollover(true);

        toggleButtonGroup.add(sphereButton);
        sphereButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/com/jme3/gde/materials/multiview/widgets/icons/sphere.png"))); // NOI18N
        sphereButton.setSelected(true);
        sphereButton.setText(org.openide.util.NbBundle.getMessage(MaterialPreviewWidget.class, "MaterialPreviewWidget.sphereButton.text")); // NOI18N
        sphereButton.setToolTipText(org.openide.util.NbBundle.getMessage(MaterialPreviewWidget.class, "MaterialPreviewWidget.sphereButton.toolTipText")); // NOI18N
        sphereButton.setFocusable(false);
        sphereButton.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        sphereButton.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        sphereButton.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        sphereButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                sphereButtonActionPerformed(evt);
            }
        });
        jToolBar1.add(sphereButton);

        toggleButtonGroup.add(cubeButton);
        cubeButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/com/jme3/gde/materials/multiview/widgets/icons/box.png"))); // NOI18N
        cubeButton.setText(org.openide.util.NbBundle.getMessage(MaterialPreviewWidget.class, "MaterialPreviewWidget.cubeButton.text")); // NOI18N
        cubeButton.setToolTipText(org.openide.util.NbBundle.getMessage(MaterialPreviewWidget.class, "MaterialPreviewWidget.cubeButton.toolTipText")); // NOI18N
        cubeButton.setFocusable(false);
        cubeButton.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        cubeButton.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        cubeButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cubeButtonActionPerformed(evt);
            }
        });
        jToolBar1.add(cubeButton);

        toggleButtonGroup.add(planeButton);
        planeButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/com/jme3/gde/materials/multiview/widgets/icons/plane.png"))); // NOI18N
        planeButton.setText(org.openide.util.NbBundle.getMessage(MaterialPreviewWidget.class, "MaterialPreviewWidget.planeButton.text")); // NOI18N
        planeButton.setToolTipText(org.openide.util.NbBundle.getMessage(MaterialPreviewWidget.class, "MaterialPreviewWidget.planeButton.toolTipText")); // NOI18N
        planeButton.setFocusable(false);
        planeButton.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        planeButton.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        planeButton.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        planeButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                planeButtonActionPerformed(evt);
            }
        });
        jToolBar1.add(planeButton);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(previewLabel, javax.swing.GroupLayout.DEFAULT_SIZE, 120, Short.MAX_VALUE)
            .addComponent(jToolBar1, javax.swing.GroupLayout.DEFAULT_SIZE, 120, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addComponent(previewLabel, javax.swing.GroupLayout.DEFAULT_SIZE, 120, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jToolBar1, javax.swing.GroupLayout.PREFERRED_SIZE, 25, javax.swing.GroupLayout.PREFERRED_SIZE))
        );
    }// </editor-fold>//GEN-END:initComponents

private void sphereButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_sphereButtonActionPerformed
    currentGeom = sphere;
    doShowMaterial(currentMaterial);
}//GEN-LAST:event_sphereButtonActionPerformed

private void cubeButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cubeButtonActionPerformed
    currentGeom = box;
    doShowMaterial(currentMaterial);
}//GEN-LAST:event_cubeButtonActionPerformed

private void planeButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_planeButtonActionPerformed
    currentGeom = quad;
    doShowMaterial(currentMaterial);
}//GEN-LAST:event_planeButtonActionPerformed
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JToggleButton cubeButton;
    private javax.swing.JToolBar jToolBar1;
    private javax.swing.JToggleButton planeButton;
    private javax.swing.JLabel previewLabel;
    private javax.swing.JToggleButton sphereButton;
    private javax.swing.ButtonGroup toggleButtonGroup;
    // End of variables declaration//GEN-END:variables
}
