/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.newt.event.awt;

import com.jogamp.newt.Window;
import com.jogamp.newt.event.WindowEvent;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.event.awt.AWTAdapter;
import com.jogamp.newt.event.awt.AWTNewtEventFactory;
import java.awt.Component;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;

public class AWTWindowAdapter
extends AWTAdapter
implements ComponentListener,
java.awt.event.WindowListener,
FocusListener {
    WindowClosingListener windowClosingListener;

    public AWTWindowAdapter(WindowListener windowListener) {
        super(windowListener);
    }

    public AWTWindowAdapter(WindowListener windowListener, Window window) {
        super(windowListener, window);
    }

    public AWTWindowAdapter(Window window) {
        super(window);
    }

    @Override
    public AWTAdapter addTo(Component component) {
        java.awt.Window window = AWTWindowAdapter.getWindow(component);
        component.addComponentListener(this);
        component.addFocusListener(this);
        if (null == this.windowClosingListener) {
            this.windowClosingListener = new WindowClosingListener();
        }
        if (null != window) {
            window.addWindowListener(this.windowClosingListener);
        }
        if (component instanceof java.awt.Window) {
            ((java.awt.Window)component).addWindowListener(this);
        }
        return this;
    }

    @Override
    public AWTAdapter removeFrom(Component component) {
        component.removeFocusListener(this);
        component.removeComponentListener(this);
        java.awt.Window window = AWTWindowAdapter.getWindow(component);
        if (null != window && null != this.windowClosingListener) {
            window.removeWindowListener(this.windowClosingListener);
        }
        if (component instanceof java.awt.Window) {
            ((java.awt.Window)component).removeWindowListener(this);
        }
        return this;
    }

    static java.awt.Window getWindow(Component component) {
        while (null != component && !(component instanceof java.awt.Window)) {
            component = component.getParent();
        }
        if (component instanceof java.awt.Window) {
            return (java.awt.Window)component;
        }
        return null;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        WindowEvent windowEvent = AWTNewtEventFactory.createWindowEvent(focusEvent, this.newtWindow);
        if (null != this.newtListener) {
            ((WindowListener)this.newtListener).windowGainedFocus(windowEvent);
        } else {
            this.enqueueEvent(false, windowEvent);
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        WindowEvent windowEvent = AWTNewtEventFactory.createWindowEvent(focusEvent, this.newtWindow);
        if (null != this.newtListener) {
            ((WindowListener)this.newtListener).windowLostFocus(windowEvent);
        } else {
            this.enqueueEvent(false, windowEvent);
        }
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        WindowEvent windowEvent = AWTNewtEventFactory.createWindowEvent(componentEvent, this.newtWindow);
        if (null != this.newtListener) {
            ((WindowListener)this.newtListener).windowResized(windowEvent);
        } else {
            this.enqueueEvent(false, windowEvent);
        }
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
        WindowEvent windowEvent = AWTNewtEventFactory.createWindowEvent(componentEvent, this.newtWindow);
        if (null != this.newtListener) {
            ((WindowListener)this.newtListener).windowMoved(windowEvent);
        } else {
            this.enqueueEvent(false, windowEvent);
        }
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
        Component component = componentEvent.getComponent();
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("AWT: componentShown: " + component);
        }
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
        Component component = componentEvent.getComponent();
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("AWT: componentHidden: " + component);
        }
    }

    @Override
    public void windowActivated(java.awt.event.WindowEvent windowEvent) {
        WindowEvent windowEvent2 = AWTNewtEventFactory.createWindowEvent(windowEvent, this.newtWindow);
        if (null != this.newtListener) {
            ((WindowListener)this.newtListener).windowGainedFocus(windowEvent2);
        } else {
            this.enqueueEvent(false, windowEvent2);
        }
    }

    @Override
    public void windowClosed(java.awt.event.WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(java.awt.event.WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(java.awt.event.WindowEvent windowEvent) {
        WindowEvent windowEvent2 = AWTNewtEventFactory.createWindowEvent(windowEvent, this.newtWindow);
        if (null != this.newtListener) {
            ((WindowListener)this.newtListener).windowLostFocus(windowEvent2);
        } else {
            this.enqueueEvent(false, windowEvent2);
        }
    }

    @Override
    public void windowDeiconified(java.awt.event.WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(java.awt.event.WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(java.awt.event.WindowEvent windowEvent) {
    }

    class WindowClosingListener
    implements java.awt.event.WindowListener {
        WindowClosingListener() {
        }

        @Override
        public void windowClosing(java.awt.event.WindowEvent windowEvent) {
            WindowEvent windowEvent2 = AWTNewtEventFactory.createWindowEvent(windowEvent, AWTWindowAdapter.this.newtWindow);
            if (null != AWTWindowAdapter.this.newtListener) {
                ((WindowListener)AWTWindowAdapter.this.newtListener).windowDestroyNotify(windowEvent2);
            } else {
                AWTWindowAdapter.this.enqueueEvent(true, windowEvent2);
            }
        }

        @Override
        public void windowActivated(java.awt.event.WindowEvent windowEvent) {
        }

        @Override
        public void windowClosed(java.awt.event.WindowEvent windowEvent) {
        }

        @Override
        public void windowDeactivated(java.awt.event.WindowEvent windowEvent) {
        }

        @Override
        public void windowDeiconified(java.awt.event.WindowEvent windowEvent) {
        }

        @Override
        public void windowIconified(java.awt.event.WindowEvent windowEvent) {
        }

        @Override
        public void windowOpened(java.awt.event.WindowEvent windowEvent) {
        }
    }
}

