/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt.windows;

import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.GraphicsConfigurationFactory;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.util.Insets;
import javax.media.nativewindow.util.Point;
import jogamp.nativewindow.windows.GDI;
import jogamp.newt.WindowImpl;
import jogamp.newt.windows.WindowsDisplay;
import jogamp.newt.windows.WindowsScreen;

public class WindowsWindow
extends WindowImpl {
    private long hmon;
    private long hdc;
    private long windowHandleClose;
    private final Insets insets = new Insets(0, 0, 0, 0);

    @Override
    protected int lockSurfaceImpl() {
        if (0L != this.getWindowHandle() && 0L == this.hdc) {
            this.hdc = GDI.GetDC((long)this.getWindowHandle());
            this.hmon = this.MonitorFromWindow0(this.getWindowHandle());
        }
        return 0L != this.hdc ? 3 : 1;
    }

    @Override
    protected void unlockSurfaceImpl() {
        if (0L != this.hdc && 0L != this.getWindowHandle() && this.getWindowLockRecursionCount() == 0) {
            GDI.ReleaseDC((long)this.getWindowHandle(), (long)this.hdc);
            this.hdc = 0L;
        }
    }

    @Override
    public final long getSurfaceHandle() {
        return this.hdc;
    }

    @Override
    public boolean hasDeviceChanged() {
        long l;
        if (0L != this.getWindowHandle() && this.hmon != (l = this.MonitorFromWindow0(this.getWindowHandle()))) {
            if (DEBUG_IMPLEMENTATION || DEBUG_WINDOW_EVENT) {
                Exception exception = new Exception("Info: Window Device Changed " + Thread.currentThread().getName() + ", HMON " + WindowsWindow.toHexString(this.hmon) + " -> " + WindowsWindow.toHexString(l));
                exception.printStackTrace();
            }
            this.hmon = l;
            return true;
        }
        return false;
    }

    @Override
    protected void createNativeImpl() {
        WindowsScreen windowsScreen = (WindowsScreen)this.getScreen();
        WindowsDisplay windowsDisplay = (WindowsDisplay)windowsScreen.getDisplay();
        this.config = GraphicsConfigurationFactory.getFactory((AbstractGraphicsDevice)windowsDisplay.getGraphicsDevice()).chooseGraphicsConfiguration(this.capsRequested, this.capsRequested, this.capabilitiesChooser, windowsScreen.getGraphicsScreen());
        if (this.config == null) {
            throw new NativeWindowException("Error choosing GraphicsConfiguration creating window: " + this);
        }
        this.setWindowHandle(this.CreateWindow0(windowsDisplay.getHInstance(), windowsDisplay.getWindowClassName(), windowsDisplay.getWindowClassName(), this.getParentWindowHandle(), 0L, this.undecorated, this.x, this.y, this.width, this.height));
        if (this.getWindowHandle() == 0L) {
            throw new NativeWindowException("Error creating window");
        }
        this.windowHandleClose = this.getWindowHandle();
        if (DEBUG_IMPLEMENTATION || DEBUG_WINDOW_EVENT) {
            Exception exception = new Exception("Info: Window new window handle " + Thread.currentThread().getName() + " (Parent HWND " + WindowsWindow.toHexString(this.getParentWindowHandle()) + ") : HWND " + WindowsWindow.toHexString(this.getWindowHandle()) + ", " + Thread.currentThread());
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void closeNativeImpl() {
        Exception exception;
        if (this.hdc != 0L) {
            block11: {
                if (this.windowHandleClose != 0L) {
                    try {
                        GDI.ReleaseDC((long)this.windowHandleClose, (long)this.hdc);
                    }
                    catch (Throwable throwable) {
                        if (!DEBUG_IMPLEMENTATION) break block11;
                        exception = new Exception("Warning: closeNativeImpl failed - " + Thread.currentThread().getName(), throwable);
                        exception.printStackTrace();
                    }
                }
            }
            this.hdc = 0L;
        }
        if (this.windowHandleClose != 0L) {
            try {
                GDI.DestroyWindow((long)this.windowHandleClose);
            }
            catch (Throwable throwable) {
                if (DEBUG_IMPLEMENTATION) {
                    exception = new Exception("Warning: closeNativeImpl failed - " + Thread.currentThread().getName(), throwable);
                    exception.printStackTrace();
                }
            }
            finally {
                this.windowHandleClose = 0L;
            }
        }
    }

    @Override
    protected void setVisibleImpl(boolean bl, int n, int n2, int n3, int n4) {
        this.setVisible0(this.getWindowHandle(), bl, this.getParentWindowHandle() == 0L, n, n2, n3, n4);
        this.visibleChanged(bl);
    }

    @Override
    protected boolean reconfigureWindowImpl(int n, int n2, int n3, int n4, boolean bl, int n5, int n6) {
        this.reconfigureWindow0(n5 > 0 ? 0L : this.getParentWindowHandle(), this.getWindowHandle(), n, n2, n3, n4, this.isVisible(), bl, n5, n6);
        return true;
    }

    @Override
    protected void requestFocusImpl(boolean bl) {
        this.requestFocus0(this.getWindowHandle(), bl);
    }

    @Override
    protected void setTitleImpl(String string) {
        WindowsWindow.setTitle0(this.getWindowHandle(), string);
    }

    @Override
    public Insets getInsets() {
        return (Insets)this.insets.clone();
    }

    @Override
    protected Point getLocationOnScreenImpl(int n, int n2) {
        return GDI.GetRelativeLocation((long)this.getWindowHandle(), (long)0L, (int)n, (int)n2);
    }

    protected static native boolean initIDs0();

    protected static native long getNewtWndProc0();

    private native long CreateWindow0(long var1, String var3, String var4, long var5, long var7, boolean var9, int var10, int var11, int var12, int var13);

    private native long MonitorFromWindow0(long var1);

    private native void setVisible0(long var1, boolean var3, boolean var4, int var5, int var6, int var7, int var8);

    private native void reconfigureWindow0(long var1, long var3, int var5, int var6, int var7, int var8, boolean var9, boolean var10, int var11, int var12);

    private static native void setTitle0(long var0, String var2);

    private native void requestFocus0(long var1, boolean var3);

    private void insetsChanged(int n, int n2, int n3, int n4) {
        if (n != -1 && n2 != -1 && n3 != -1 && n4 != -1 && (n != this.insets.left || n2 != this.insets.top || n3 != this.insets.right || n4 != this.insets.bottom)) {
            this.insets.left = n;
            this.insets.top = n2;
            this.insets.right = n3;
            this.insets.bottom = n4;
            if (DEBUG_IMPLEMENTATION) {
                System.err.println("Window.insetsChanged: " + this.insets);
            }
        }
    }

    static {
        WindowsDisplay.initSingleton();
    }
}

