/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util.texture.spi;

import com.jogamp.opengl.util.FileUtil;
import com.jogamp.opengl.util.texture.TextureData;
import com.jogamp.opengl.util.texture.spi.TextureWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.media.opengl.GLException;

public class NetPbmTextureWriter
implements TextureWriter {
    int magic;
    public static final String PPM = "ppm";
    public static final String PAM = "pam";

    public NetPbmTextureWriter() {
        this(0);
    }

    public NetPbmTextureWriter(int n) {
        switch (n) {
            case 0: 
            case 6: 
            case 7: {
                break;
            }
            default: {
                throw new GLException("Unsupported magic: " + n + ", should be 0 (auto), 6 (PPM) or 7 (PAM)");
            }
        }
        this.magic = n;
    }

    public int getMagic() {
        return this.magic;
    }

    public String getSuffix() {
        return this.magic == 6 ? PPM : PAM;
    }

    @Override
    public boolean write(File file, TextureData textureData) throws IOException {
        if (0 == this.magic) {
            if (PPM.equals(FileUtil.getFileSuffix(file))) {
                this.magic = 6;
            } else if (PAM.equals(FileUtil.getFileSuffix(file))) {
                this.magic = 7;
            } else {
                return false;
            }
        }
        int n = textureData.getPixelFormat();
        int n2 = textureData.getPixelType();
        if (!(n != 6407 && n != 6408 || n2 != 5120 && n2 != 5121)) {
            int n3;
            int n4 = n3 = n == 6408 ? 4 : 3;
            if (this.magic == 6 && n3 == 4) {
                throw new IOException("NetPbmTextureWriter magic 6 (PPM) doesn't RGBA pixel format, use magic 7 (PAM)");
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("P");
            stringBuffer.append(this.magic);
            stringBuffer.append("\n");
            if (7 == this.magic) {
                stringBuffer.append("WIDTH ");
            }
            stringBuffer.append(textureData.getWidth());
            if (7 == this.magic) {
                stringBuffer.append("\nHEIGHT ");
            } else {
                stringBuffer.append(" ");
            }
            stringBuffer.append(textureData.getHeight());
            if (7 == this.magic) {
                stringBuffer.append("\nDEPTH ");
                stringBuffer.append(n3);
                stringBuffer.append("\nMAXVAL 255\nTUPLTYPE ");
                if (n == 6408) {
                    stringBuffer.append("RGB_ALPHA");
                } else {
                    stringBuffer.append("RGB");
                }
                stringBuffer.append("\nENDHDR\n");
            } else {
                stringBuffer.append("\n255\n");
            }
            fileOutputStream.write(stringBuffer.toString().getBytes());
            ByteBuffer byteBuffer = (ByteBuffer)textureData.getBuffer();
            if (byteBuffer == null) {
                byteBuffer = (ByteBuffer)textureData.getMipmapData()[0];
            }
            byteBuffer.rewind();
            byte[] byArray = null;
            try {
                byArray = byteBuffer.array();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (null == byArray) {
                byArray = new byte[textureData.getWidth() * textureData.getHeight() * n3];
                byteBuffer.get(byArray);
                byteBuffer.rewind();
            }
            fileOutputStream.write(byArray);
            fileOutputStream.close();
            return true;
        }
        throw new IOException("NetPbmTextureWriter writer doesn't support this pixel format / type (only GL_RGB/A + bytes)");
    }
}

