/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.windows.wgl;

import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.AbstractGraphicsScreen;
import javax.media.nativewindow.DefaultGraphicsScreen;
import javax.media.nativewindow.NativeSurface;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;
import jogamp.nativewindow.ProxySurface;
import jogamp.nativewindow.windows.GDI;
import jogamp.opengl.GLContextShareSet;
import jogamp.opengl.windows.wgl.WGL;
import jogamp.opengl.windows.wgl.WindowsWGLContext;
import jogamp.opengl.windows.wgl.WindowsWGLDrawable;
import jogamp.opengl.windows.wgl.WindowsWGLGraphicsConfiguration;

public class WindowsExternalWGLContext
extends WindowsWGLContext {
    private boolean firstMakeCurrent = true;
    private GLContext lastContext;

    private WindowsExternalWGLContext(Drawable drawable, long l, WindowsWGLGraphicsConfiguration windowsWGLGraphicsConfiguration) {
        super(drawable, null);
        this.contextHandle = l;
        if (DEBUG) {
            System.err.println(WindowsExternalWGLContext.getThreadName() + ": !!! Created external OpenGL context " + WindowsExternalWGLContext.toHexString(l) + " for " + this);
        }
        GLContextShareSet.contextCreated(this);
        this.setGLFunctionAvailability(false, 0, 0, 34);
        this.getGLStateTracker().setEnabled(false);
    }

    protected static WindowsExternalWGLContext create(GLDrawableFactory gLDrawableFactory, GLProfile gLProfile) {
        long l = WGL.wglGetCurrentDC();
        if (0L == l) {
            throw new GLException("Error: attempted to make an external GLDrawable without a drawable current, werr " + GDI.GetLastError());
        }
        long l2 = WGL.wglGetCurrentContext();
        if (l2 == 0L) {
            throw new GLException("Error: attempted to make an external GLContext without a context current, werr " + GDI.GetLastError());
        }
        int n = GDI.GetPixelFormat((long)l);
        if (n == 0) {
            throw new GLException("Error: attempted to make an external GLContext without a valid pixelformat, werr " + GDI.GetLastError());
        }
        AbstractGraphicsScreen abstractGraphicsScreen = DefaultGraphicsScreen.createDefault((String)"Windows");
        WindowsWGLGraphicsConfiguration windowsWGLGraphicsConfiguration = WindowsWGLGraphicsConfiguration.createFromCurrent(gLDrawableFactory, l, n, gLProfile, abstractGraphicsScreen, true, true);
        return new WindowsExternalWGLContext(new Drawable(gLDrawableFactory, (NativeSurface)new ProxySurface((AbstractGraphicsConfiguration)windowsWGLGraphicsConfiguration, l)), l2, windowsWGLGraphicsConfiguration);
    }

    @Override
    public int makeCurrent() throws GLException {
        GLContext gLContext = WindowsExternalWGLContext.getCurrent();
        if (gLContext != null && gLContext != this) {
            this.lastContext = gLContext;
            WindowsExternalWGLContext.setCurrent(null);
        }
        return super.makeCurrent();
    }

    @Override
    public void release() throws GLException {
        super.release();
        WindowsExternalWGLContext.setCurrent(this.lastContext);
        this.lastContext = null;
    }

    @Override
    protected void makeCurrentImpl(boolean bl) throws GLException {
        if (this.firstMakeCurrent) {
            this.firstMakeCurrent = false;
        }
    }

    @Override
    protected void releaseImpl() throws GLException {
    }

    @Override
    protected void destroyImpl() throws GLException {
    }

    static class Drawable
    extends WindowsWGLDrawable {
        Drawable(GLDrawableFactory gLDrawableFactory, NativeSurface nativeSurface) {
            super(gLDrawableFactory, nativeSurface, true);
        }

        @Override
        public GLContext createContext(GLContext gLContext) {
            throw new GLException("Should not call this");
        }

        @Override
        public int getWidth() {
            throw new GLException("Should not call this");
        }

        @Override
        public int getHeight() {
            throw new GLException("Should not call this");
        }

        public void setSize(int n, int n2) {
            throw new GLException("Should not call this");
        }
    }
}

