/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.classreader;

import com.jeantessier.classreader.ClassfileLoaderAction;
import com.jeantessier.classreader.ClassfileLoaderDispatcher;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ModifiedOnlyDispatcher
implements ClassfileLoaderDispatcher {
    private ClassfileLoaderDispatcher delegate;
    private Map<String, Long> timestamps = new HashMap<String, Long>();

    public ModifiedOnlyDispatcher(ClassfileLoaderDispatcher delegate) {
        this.delegate = delegate;
    }

    @Override
    public ClassfileLoaderAction dispatch(String filename) {
        ClassfileLoaderAction result = this.delegate.dispatch(filename);
        if (result == ClassfileLoaderAction.CLASS) {
            Long timestamp = this.timestamps.get(filename);
            Logger.getLogger(this.getClass()).debug((Object)(filename + " has timestamp " + timestamp));
            File file = new File(filename);
            if (timestamp != null && timestamp >= file.lastModified()) {
                Logger.getLogger(this.getClass()).debug((Object)("Already dispatched \"" + filename + "\": IGNORE"));
                result = ClassfileLoaderAction.IGNORE;
            } else {
                Logger.getLogger(this.getClass()).debug((Object)"Delegating ...");
                timestamp = file.lastModified();
                this.timestamps.put(filename, timestamp);
            }
        } else {
            Logger.getLogger(this.getClass()).debug((Object)"Delegating ...");
        }
        return result;
    }
}

