/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.classreader;

import com.jeantessier.classreader.ClassfileLoaderAction;
import com.jeantessier.classreader.ClassfileLoaderDispatcher;
import java.io.File;
import org.apache.log4j.Logger;

public class PermissiveDispatcher
implements ClassfileLoaderDispatcher {
    @Override
    public ClassfileLoaderAction dispatch(String filename) {
        ClassfileLoaderAction result;
        if (filename.endsWith(".zip")) {
            result = ClassfileLoaderAction.ZIP;
            Logger.getLogger(this.getClass()).debug((Object)("Dispatching \"" + filename + "\": ACTION_ZIP"));
        } else if (filename.endsWith(".jar")) {
            result = ClassfileLoaderAction.JAR;
            Logger.getLogger(this.getClass()).debug((Object)("Dispatching \"" + filename + "\": ACTION_JAR"));
        } else if (filename.endsWith(".class")) {
            result = ClassfileLoaderAction.CLASS;
            Logger.getLogger(this.getClass()).debug((Object)("Dispatching \"" + filename + "\": ACTION_CLASS"));
        } else if (new File(filename).isDirectory()) {
            result = ClassfileLoaderAction.DIRECTORY;
            Logger.getLogger(this.getClass()).debug((Object)("Dispatching \"" + filename + "\": ACTION_DIRECTORY"));
        } else if (filename.endsWith("/") || filename.endsWith(".bat") || filename.endsWith(".css") || filename.endsWith(".dtd") || filename.endsWith(".gif") || filename.endsWith(".htm") || filename.endsWith(".html") || filename.endsWith(".java") || filename.endsWith(".jpeg") || filename.endsWith(".jpg") || filename.endsWith(".js") || filename.endsWith(".jsp") || filename.endsWith("MANIFEST.MF") || filename.endsWith(".properties") || filename.endsWith(".ps") || filename.endsWith(".txt") || filename.endsWith(".xml") || filename.endsWith(".xsl")) {
            result = ClassfileLoaderAction.IGNORE;
            Logger.getLogger(this.getClass()).debug((Object)("Dispatching \"" + filename + "\": ACTION_IGNORE"));
        } else {
            result = ClassfileLoaderAction.ZIP;
            Logger.getLogger(this.getClass()).debug((Object)("Dispatching \"" + filename + "\": ACTION_ZIP"));
        }
        return result;
    }
}

