/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.classreader.impl;

import com.jeantessier.classreader.Visitable;
import com.jeantessier.classreader.impl.AttributeType;
import com.jeantessier.classreader.impl.Attribute_info;
import com.jeantessier.classreader.impl.ConstantPool;
import com.jeantessier.classreader.impl.Custom_attribute;
import com.jeantessier.classreader.impl.UTF8_info;
import java.io.DataInput;
import java.io.IOException;
import org.apache.log4j.Logger;

public class AttributeFactory {
    public Attribute_info create(ConstantPool constantPool, Visitable owner, DataInput in) throws IOException {
        Attribute_info result;
        int nameIndex = in.readUnsignedShort();
        if (nameIndex > 0) {
            Object entry = constantPool.get(nameIndex);
            if (entry instanceof UTF8_info) {
                String name = ((UTF8_info)entry).getValue();
                Logger.getLogger(AttributeFactory.class).debug((Object)("Attribute name index: " + nameIndex + " (" + name + ")"));
                AttributeType attributeType = AttributeType.forName(name);
                if (attributeType != null) {
                    result = attributeType.create(constantPool, owner, in);
                } else {
                    Logger.getLogger(AttributeFactory.class).warn((Object)("Unknown attribute name \"" + name + "\""));
                    result = new Custom_attribute(name, constantPool, owner, in);
                }
            } else {
                Logger.getLogger(AttributeFactory.class).debug((Object)("Attribute name: " + entry));
                Logger.getLogger(AttributeFactory.class).warn((Object)("Unknown attribute with invalid name \"" + entry + "\""));
                result = new Custom_attribute(constantPool, owner, in);
            }
        } else {
            Logger.getLogger(AttributeFactory.class).debug((Object)("Attribute name index: " + nameIndex));
            Logger.getLogger(AttributeFactory.class).warn((Object)("Unknown attribute with no name (name index = " + nameIndex + ")"));
            result = new Custom_attribute(constantPool, owner, in);
        }
        return result;
    }
}

