/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.classreader.impl;

import com.jeantessier.classreader.impl.Class_info;
import com.jeantessier.classreader.impl.ConstantPool;
import com.jeantessier.classreader.impl.ConstantPoolEntry;
import com.jeantessier.classreader.impl.NameAndType_info;
import java.io.DataInput;
import java.io.IOException;

public abstract class FeatureRef_info
extends ConstantPoolEntry
implements com.jeantessier.classreader.FeatureRef_info {
    private int classIndex;
    private int nameAndTypeIndex;

    public FeatureRef_info(ConstantPool constantPool, DataInput in) throws IOException {
        super(constantPool);
        this.classIndex = in.readUnsignedShort();
        this.nameAndTypeIndex = in.readUnsignedShort();
    }

    @Override
    public int getClassIndex() {
        return this.classIndex;
    }

    @Override
    public Class_info getRawClass() {
        return (Class_info)this.getConstantPool().get(this.getClassIndex());
    }

    @Override
    public String getClassName() {
        return this.getRawClass().getName();
    }

    @Override
    public String getClassSimpleName() {
        return this.getRawClass().getSimpleName();
    }

    @Override
    public int getNameAndTypeIndex() {
        return this.nameAndTypeIndex;
    }

    @Override
    public NameAndType_info getRawNameAndType() {
        return (NameAndType_info)this.getConstantPool().get(this.getNameAndTypeIndex());
    }

    @Override
    public String getNameAndType() {
        NameAndType_info nat = this.getRawNameAndType();
        return nat.getName() + nat.getType();
    }

    @Override
    public abstract String getName();

    @Override
    public String getFullName() {
        return this.getClassName() + "." + this.getName();
    }

    @Override
    public abstract String getSignature();

    @Override
    public String getFullSignature() {
        return this.getClassName() + "." + this.getSignature();
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        Class_info c = this.getRawClass();
        NameAndType_info nat = this.getRawNameAndType();
        result.append(c).append(".").append(nat.getName()).append(nat.getType());
        return result.toString();
    }

    public int hashCode() {
        return this.getRawClass().hashCode() ^ this.getRawNameAndType().hashCode();
    }

    public boolean equals(Object object) {
        boolean result = false;
        if (this == object) {
            result = true;
        } else if (object != null && this.getClass().equals(object.getClass())) {
            FeatureRef_info other = (FeatureRef_info)object;
            result = this.getRawClass().equals(other.getRawClass()) && this.getRawNameAndType().equals(other.getRawNameAndType());
        }
        return result;
    }
}

