/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependency;

import com.jeantessier.dependency.ClassNode;
import com.jeantessier.dependency.FeatureNode;
import com.jeantessier.dependency.Node;
import com.jeantessier.dependency.PackageNode;
import com.jeantessier.dependency.Visitor;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import org.apache.oro.text.perl.Perl5Util;

public class LCOM4Gatherer
implements Visitor {
    private static final Perl5Util perl = new Perl5Util();
    private Map<ClassNode, Collection<Collection<FeatureNode>>> results = new HashMap<ClassNode, Collection<Collection<FeatureNode>>>();
    private Collection<FeatureNode> currentComponent;
    private ClassNode currentClass;
    private LinkedList<FeatureNode> unvisitedNodes;
    private HashSet<Collection<FeatureNode>> currentComponents;

    public Map<ClassNode, Collection<Collection<FeatureNode>>> getResults() {
        return this.results;
    }

    @Override
    public void traverseNodes(Collection<? extends Node> nodes) {
        for (Node node : nodes) {
            if (!node.isConfirmed()) continue;
            node.accept(this);
        }
    }

    @Override
    public void visitPackageNode(PackageNode node) {
        this.traverseNodes(node.getClasses());
    }

    @Override
    public void visitInboundPackageNode(PackageNode node) {
    }

    @Override
    public void visitOutboundPackageNode(PackageNode node) {
    }

    @Override
    public void visitClassNode(ClassNode node) {
        this.currentClass = node;
        this.currentComponents = new HashSet();
        this.results.put(this.currentClass, this.currentComponents);
        this.unvisitedNodes = this.filterOutConstructors(this.currentClass.getFeatures());
        while (!this.unvisitedNodes.isEmpty()) {
            this.unvisitedNodes.removeFirst().accept(this);
        }
    }

    @Override
    public void visitInboundClassNode(ClassNode node) {
    }

    @Override
    public void visitOutboundClassNode(ClassNode node) {
    }

    @Override
    public void visitFeatureNode(FeatureNode node) {
        this.currentComponent = new HashSet<FeatureNode>();
        this.currentComponents.add(this.currentComponent);
        this.currentComponent.add(node);
        this.traverseInbound(node.getInboundDependencies());
        this.traverseOutbound(node.getOutboundDependencies());
    }

    @Override
    public void traverseInbound(Collection<? extends Node> inboundDependencies) {
        for (Node node : inboundDependencies) {
            node.acceptInbound(this);
        }
    }

    @Override
    public void traverseOutbound(Collection<? extends Node> outboundDependencies) {
        for (Node node : outboundDependencies) {
            node.acceptOutbound(this);
        }
    }

    @Override
    public void visitInboundFeatureNode(FeatureNode node) {
        this.visitFeatureDependency(node);
    }

    @Override
    public void visitOutboundFeatureNode(FeatureNode node) {
        this.visitFeatureDependency(node);
    }

    private void visitFeatureDependency(FeatureNode node) {
        if (this.currentClass.equals(node.getClassNode()) && this.unvisitedNodes.contains(node)) {
            this.unvisitedNodes.remove(node);
            this.currentComponent.add(node);
            this.traverseInbound(node.getInboundDependencies());
            this.traverseOutbound(node.getOutboundDependencies());
        }
    }

    private LinkedList<FeatureNode> filterOutConstructors(Collection<FeatureNode> featureNodes) {
        LinkedList<FeatureNode> result = new LinkedList<FeatureNode>();
        for (FeatureNode featureNode : featureNodes) {
            if (!featureNode.isConfirmed() || this.isConstructor(featureNode)) continue;
            result.add(featureNode);
        }
        return result;
    }

    private boolean isConstructor(FeatureNode node) {
        return perl.match("/(\\w+)\\.\\1\\(/", node.getName());
    }
}

