/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependencyfinder.ant;

import com.jeantessier.classreader.ClassfileLoader;
import com.jeantessier.classreader.LoadListenerVisitorAdapter;
import com.jeantessier.classreader.TransientClassfileLoader;
import com.jeantessier.dependency.CodeDependencyCollector;
import com.jeantessier.dependency.CollectionSelectionCriteria;
import com.jeantessier.dependency.ComprehensiveSelectionCriteria;
import com.jeantessier.dependency.LinkMaximizer;
import com.jeantessier.dependency.LinkMinimizer;
import com.jeantessier.dependency.NodeFactory;
import com.jeantessier.dependency.Printer;
import com.jeantessier.dependency.RegularExpressionSelectionCriteria;
import com.jeantessier.dependency.SelectionCriteria;
import com.jeantessier.dependency.TextPrinter;
import com.jeantessier.dependency.XMLPrinter;
import com.jeantessier.dependencyfinder.ant.VerboseListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.apache.log4j.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;

public class DependencyExtractor
extends Task {
    private String filterIncludes = "//";
    private String filterExcludes = "";
    private boolean packageFilter = false;
    private String packageFilterIncludes = "";
    private String packageFilterExcludes = "";
    private boolean classFilter = false;
    private String classFilterIncludes = "";
    private String classFilterExcludes = "";
    private boolean featureFilter = false;
    private String featureFilterIncludes = "";
    private String featureFilterExcludes = "";
    private Path filterIncludesList;
    private Path filterExcludesList;
    private boolean xml = false;
    private boolean minimize = false;
    private boolean maximize = false;
    private String encoding = "utf-8";
    private String dtdPrefix = "http://depfind.sourceforge.net/dtd";
    private String indentText;
    private File destfile;
    private Path path;

    public String getFilterincludes() {
        return this.filterIncludes;
    }

    public void setFilterincludes(String filterIncludes) {
        this.filterIncludes = filterIncludes;
    }

    public String getFilterexcludes() {
        return this.filterExcludes;
    }

    public void setFilterexcludes(String filterExcludes) {
        this.filterExcludes = filterExcludes;
    }

    public boolean getPackagefilter() {
        return this.packageFilter;
    }

    public void setPackagefilter(boolean packageFilter) {
        this.packageFilter = packageFilter;
    }

    public String getPackagefilterincludes() {
        return this.packageFilterIncludes;
    }

    public void setPackagefilterincludes(String packageFilterIncludes) {
        this.packageFilterIncludes = packageFilterIncludes;
    }

    public String getPackagefilterexcludes() {
        return this.packageFilterExcludes;
    }

    public void setPackagefilterexcludes(String packageFilterExcludes) {
        this.packageFilterExcludes = packageFilterExcludes;
    }

    public boolean getClassfilter() {
        return this.classFilter;
    }

    public void setClassfilter(boolean classFilter) {
        this.classFilter = classFilter;
    }

    public String getClassfilterincludes() {
        return this.classFilterIncludes;
    }

    public void setClassfilterincludes(String classFilterIncludes) {
        this.classFilterIncludes = classFilterIncludes;
    }

    public String getClassfilterexcludes() {
        return this.classFilterExcludes;
    }

    public void setClassfilterexcludes(String classFilterExcludes) {
        this.classFilterExcludes = classFilterExcludes;
    }

    public boolean getFeaturefilter() {
        return this.featureFilter;
    }

    public void setFeaturefilter(boolean featureFilter) {
        this.featureFilter = featureFilter;
    }

    public String getFeaturefilterincludes() {
        return this.featureFilterIncludes;
    }

    public void setFeaturefilterincludes(String featureFilterIncludes) {
        this.featureFilterIncludes = featureFilterIncludes;
    }

    public String getFeaturefilterexcludes() {
        return this.featureFilterExcludes;
    }

    public void setFeaturefilterexcludes(String featureFilterExcludes) {
        this.featureFilterExcludes = featureFilterExcludes;
    }

    public Path createFilterincludeslist() {
        if (this.filterIncludesList == null) {
            this.filterIncludesList = new Path(this.getProject());
        }
        return this.filterIncludesList;
    }

    public Path getFilterincludeslist() {
        return this.filterIncludesList;
    }

    public Path createFilterexcludeslist() {
        if (this.filterExcludesList == null) {
            this.filterExcludesList = new Path(this.getProject());
        }
        return this.filterExcludesList;
    }

    public Path getFilterexcludeslist() {
        return this.filterExcludesList;
    }

    public boolean getXml() {
        return this.xml;
    }

    public void setXml(boolean xml) {
        this.xml = xml;
    }

    public boolean getMinimize() {
        return this.minimize;
    }

    public void setMinimize(boolean minimize) {
        this.minimize = minimize;
    }

    public boolean getMaximize() {
        return this.maximize;
    }

    public void setMaximize(boolean maximize) {
        this.maximize = maximize;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getDtdprefix() {
        return this.dtdPrefix;
    }

    public void setDtdprefix(String dtdPrefix) {
        this.dtdPrefix = dtdPrefix;
    }

    public String getIndenttext() {
        return this.indentText;
    }

    public void setIntenttext(String indentText) {
        this.indentText = indentText;
    }

    public File getDestfile() {
        return this.destfile;
    }

    public void setDestfile(File destfile) {
        this.destfile = destfile;
    }

    public Path createPath() {
        if (this.path == null) {
            this.path = new Path(this.getProject());
        }
        return this.path;
    }

    public Path getPath() {
        return this.path;
    }

    public void execute() throws BuildException {
        if (this.getPath() == null) {
            throw new BuildException("path must be set!");
        }
        if (this.getDestfile() == null) {
            throw new BuildException("destfile must be set!");
        }
        if (this.hasFilterRegularExpressionSwitches() && this.hasFilterListSwitches()) {
            throw new BuildException("Cannot have filter attributes for regular expressions and lists at the same time!");
        }
        this.log("Reading classes from path " + this.getPath());
        VerboseListener verboseListener = new VerboseListener(this);
        NodeFactory factory = new NodeFactory();
        CodeDependencyCollector collector = new CodeDependencyCollector(factory, this.getFilterCriteria());
        TransientClassfileLoader loader = new TransientClassfileLoader();
        ((ClassfileLoader)loader).addLoadListener(new LoadListenerVisitorAdapter(collector));
        ((ClassfileLoader)loader).addLoadListener(verboseListener);
        loader.load(Arrays.asList(this.getPath().list()));
        if (this.getMinimize()) {
            LinkMinimizer minimizer = new LinkMinimizer();
            minimizer.traverseNodes(factory.getPackages().values());
        } else if (this.getMaximize()) {
            LinkMaximizer maximizer = new LinkMaximizer();
            maximizer.traverseNodes(factory.getPackages().values());
        }
        this.log("Saving dependency graph to " + this.getDestfile().getAbsolutePath());
        try {
            PrintWriter out = new PrintWriter(new FileWriter(this.getDestfile()));
            Printer printer = this.getXml() ? new XMLPrinter(out, this.getEncoding(), this.getDtdprefix()) : new TextPrinter(out);
            if (this.getIndenttext() != null) {
                printer.setIndentText(this.getIndenttext());
            }
            printer.traverseNodes(factory.getPackages().values());
            out.close();
        }
        catch (IOException ex) {
            throw new BuildException((Throwable)ex);
        }
    }

    protected SelectionCriteria getFilterCriteria() throws BuildException {
        SelectionCriteria result = new ComprehensiveSelectionCriteria();
        if (this.hasFilterRegularExpressionSwitches()) {
            result = this.createRegularExpressionFilterCriteria();
        } else if (this.hasFilterListSwitches()) {
            result = this.createCollectionSelectionCriteria(this.getFilterincludeslist(), this.getFilterexcludeslist());
        }
        return result;
    }

    protected RegularExpressionSelectionCriteria createRegularExpressionFilterCriteria() throws BuildException {
        RegularExpressionSelectionCriteria result = new RegularExpressionSelectionCriteria();
        if (this.getPackagefilter() || this.getClassfilter() || this.getFeaturefilter()) {
            result.setMatchingPackages(this.getPackagefilter());
            result.setMatchingClasses(this.getClassfilter());
            result.setMatchingFeatures(this.getFeaturefilter());
        }
        result.setGlobalIncludes(this.getFilterincludes());
        result.setGlobalExcludes(this.getFilterexcludes());
        result.setPackageIncludes(this.getPackagefilterincludes());
        result.setPackageExcludes(this.getPackagefilterexcludes());
        result.setClassIncludes(this.getClassfilterincludes());
        result.setClassExcludes(this.getClassfilterexcludes());
        result.setFeatureIncludes(this.getFeaturefilterincludes());
        result.setFeatureExcludes(this.getFeaturefilterexcludes());
        return result;
    }

    private boolean hasFilterRegularExpressionSwitches() {
        return !this.getFilterincludes().equals("//") || !this.getFilterexcludes().equals("") || this.getPackagefilter() || !this.getPackagefilterincludes().equals("") || !this.getPackagefilterexcludes().equals("") || this.getClassfilter() || !this.getClassfilterincludes().equals("") || !this.getClassfilterexcludes().equals("") || this.getFeaturefilter() || !this.getFeaturefilterincludes().equals("") || !this.getFeaturefilterexcludes().equals("");
    }

    private boolean hasFilterListSwitches() {
        return this.getFilterincludeslist() != null || this.getFilterexcludeslist() != null;
    }

    private CollectionSelectionCriteria createCollectionSelectionCriteria(Path includes, Path excludes) {
        return new CollectionSelectionCriteria(this.loadCollection(includes), this.loadCollection(excludes));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<String> loadCollection(Path path) {
        HashSet<String> result = null;
        if (path != null) {
            result = new HashSet<String>();
            String[] filenames = path.list();
            for (int i = 0; i < filenames.length; ++i) {
                BufferedReader reader = null;
                try {
                    String line;
                    reader = new BufferedReader(new FileReader(filenames[i]));
                    while ((line = reader.readLine()) != null) {
                        result.add(line);
                    }
                    continue;
                }
                catch (IOException ex) {
                    Logger.getLogger(((Object)((Object)this)).getClass()).error((Object)("Couldn't read file " + filenames[i]), (Throwable)ex);
                    continue;
                }
                finally {
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    catch (IOException ex) {
                        Logger.getLogger(((Object)((Object)this)).getClass()).error((Object)("Couldn't close file " + filenames[i]), (Throwable)ex);
                    }
                }
            }
        }
        return result;
    }
}

