/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependencyfinder.ant;

import com.jeantessier.classreader.AggregatingClassfileLoader;
import com.jeantessier.classreader.ClassfileLoader;
import com.jeantessier.classreader.DeprecationPrinter;
import com.jeantessier.classreader.LoadListenerVisitorAdapter;
import com.jeantessier.dependencyfinder.ant.VerboseListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;

public class ListDeprecatedElements
extends Task {
    private File destfile;
    private Path path;

    public File getDestfile() {
        return this.destfile;
    }

    public void setDestfile(File destfile) {
        this.destfile = destfile;
    }

    public Path createPath() {
        if (this.path == null) {
            this.path = new Path(this.getProject());
        }
        return this.path;
    }

    public Path getPath() {
        return this.path;
    }

    public void execute() throws BuildException {
        if (this.getPath() == null) {
            throw new BuildException("path must be set!");
        }
        if (this.getDestfile() == null) {
            throw new BuildException("destfile must be set!");
        }
        this.log("Saving elements to " + this.getDestfile().getAbsolutePath());
        try {
            PrintWriter out = new PrintWriter(new FileWriter(this.getDestfile()));
            this.log("Reading classes from path " + this.getPath());
            VerboseListener verboseListener = new VerboseListener(this);
            DeprecationPrinter printer = new DeprecationPrinter(out);
            AggregatingClassfileLoader loader = new AggregatingClassfileLoader();
            ((ClassfileLoader)loader).addLoadListener(verboseListener);
            ((ClassfileLoader)loader).addLoadListener(new LoadListenerVisitorAdapter(printer));
            loader.load(Arrays.asList(this.getPath().list()));
            out.close();
        }
        catch (IOException ex) {
            throw new BuildException((Throwable)ex);
        }
    }
}

