/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependencyfinder.cli;

import com.jeantessier.classreader.AttributeType;
import com.jeantessier.classreader.Classfile;
import com.jeantessier.classreader.ClassfileLoader;
import com.jeantessier.classreader.Custom_attribute;
import com.jeantessier.classreader.Field_info;
import com.jeantessier.classreader.InnerClass;
import com.jeantessier.classreader.LoadListenerVisitorAdapter;
import com.jeantessier.classreader.Method_info;
import com.jeantessier.classreader.MetricsGatherer;
import com.jeantessier.classreader.TransientClassfileLoader;
import com.jeantessier.classreader.impl.Instruction;
import com.jeantessier.dependencyfinder.cli.DirectoryExplorerCommand;
import com.jeantessier.text.Hex;
import java.io.IOException;
import java.util.Collection;

public class ClassMetrics
extends DirectoryExplorerCommand {
    private boolean list;

    @Override
    protected void populateCommandLineSwitches() {
        super.populateCommandLineSwitches();
        this.getCommandLine().addToggleSwitch("list");
        this.getCommandLine().addToggleSwitch("instruction-counts");
    }

    @Override
    public void doProcessing() throws Exception {
        this.list = this.getCommandLine().getToggleSwitch("list");
        MetricsGatherer metrics = new MetricsGatherer();
        TransientClassfileLoader loader = new TransientClassfileLoader();
        ((ClassfileLoader)loader).addLoadListener(this.getVerboseListener());
        ((ClassfileLoader)loader).addLoadListener(new LoadListenerVisitorAdapter(metrics));
        loader.load(this.getCommandLine().getParameters());
        this.getVerboseListener().print("Printing report ...");
        this.getOut().println(metrics.getClasses().size() + " class(es)");
        if (this.list) {
            for (Object o : metrics.getClasses()) {
                this.getOut().println("        " + o);
            }
        }
        this.getOut().println(metrics.getInterfaces().size() + " interface(s)");
        if (this.list) {
            for (Object o : metrics.getInterfaces()) {
                this.getOut().println("        " + o);
            }
        }
        this.getOut().println();
        this.getOut().println(metrics.getMethods().size() + " method(s) (average " + (double)metrics.getMethods().size() / ((double)metrics.getClasses().size() + (double)metrics.getInterfaces().size()) + " per class/interface)");
        this.getOut().println(metrics.getFields().size() + " field(s) (average " + (double)metrics.getFields().size() / ((double)metrics.getClasses().size() + (double)metrics.getInterfaces().size()) + " per class/interface)");
        this.getOut().println();
        this.printCFM(" synthetic element(s)", metrics.getSyntheticClasses(), metrics.getSyntheticFields(), metrics.getSyntheticMethods());
        this.printCFM(" deprecated element(s)", metrics.getDeprecatedClasses(), metrics.getDeprecatedFields(), metrics.getDeprecatedMethods());
        this.printCFMIC(" public element(s)", metrics.getPublicClasses(), metrics.getPublicFields(), metrics.getPublicMethods(), metrics.getPublicInnerClasses());
        this.printFMIC(" protected element(s)", metrics.getProtectedFields(), metrics.getProtectedMethods(), metrics.getProtectedInnerClasses());
        this.printFMIC(" private element(s)", metrics.getPrivateFields(), metrics.getPrivateMethods(), metrics.getPrivateInnerClasses());
        this.printCFMIC(" package element(s)", metrics.getPackageClasses(), metrics.getPackageFields(), metrics.getPackageMethods(), metrics.getPackageInnerClasses());
        this.printCMIC(" abstract element(s)", metrics.getAbstractClasses(), metrics.getAbstractMethods(), metrics.getAbstractInnerClasses());
        this.printFMIC(" static element(s)", metrics.getStaticFields(), metrics.getStaticMethods(), metrics.getStaticInnerClasses());
        this.printCFMIC(" final element(s)", metrics.getFinalClasses(), metrics.getFinalFields(), metrics.getFinalMethods(), metrics.getFinalInnerClasses());
        this.getOut().println(metrics.getSynchronizedMethods().size() + " synchronized method(s)");
        if (this.list) {
            for (Method_info method : metrics.getSynchronizedMethods()) {
                this.getOut().println("        " + method);
            }
        }
        this.getOut().println(metrics.getNativeMethods().size() + " native method(s)");
        if (this.list) {
            for (Method_info method : metrics.getNativeMethods()) {
                this.getOut().println("        " + method);
            }
        }
        this.getOut().println(metrics.getVolatileFields().size() + " volatile field(s)");
        if (this.list) {
            for (Field_info field : metrics.getVolatileFields()) {
                this.getOut().println("        " + field);
            }
        }
        this.getOut().println(metrics.getTransientFields().size() + " transient field(s)");
        if (this.list) {
            for (Field_info field : metrics.getTransientFields()) {
                this.getOut().println("        " + field);
            }
        }
        for (AttributeType attributeType : AttributeType.values()) {
            this.getOut().println(metrics.getAttributeCounts().get(attributeType.getAttributeName()) + " " + attributeType.getAttributeName() + " attribute(s)");
        }
        this.getOut().println(metrics.getCustomAttributes().size() + " custom attribute(s)");
        if (this.list) {
            for (Custom_attribute attribute : metrics.getCustomAttributes()) {
                this.getOut().println("        " + attribute);
            }
        }
        if (this.getCommandLine().getToggleSwitch("instruction-counts")) {
            this.getOut().println();
            this.getOut().println("Instruction counts:");
            for (int opcode = 0; opcode < 256; ++opcode) {
                this.getOut().print("        0x");
                Hex.print(this.getOut(), (byte)opcode);
                this.getOut().println(" " + Instruction.getMnemonic(opcode) + ": " + metrics.getInstructionCounts()[opcode]);
            }
        }
    }

    private void printCMIC(String label, Collection<Classfile> classes, Collection<Method_info> methods, Collection<InnerClass> innerClasses) throws IOException {
        this.getOut().println(classes.size() + methods.size() + innerClasses.size() + label);
        if (this.list) {
            this.getOut().println("    " + classes.size() + " class(es)");
            for (Classfile aClass : classes) {
                this.getOut().println("        " + aClass);
            }
            this.getOut().println("    " + methods.size() + " method(s)");
            for (Method_info method : methods) {
                this.getOut().println("        " + method);
            }
            this.getOut().println("    " + innerClasses.size() + " inner class(es)");
            for (InnerClass innerClass : innerClasses) {
                this.getOut().println("        " + innerClass);
            }
        } else {
            this.getOut().println("    " + classes.size() + " class(es)");
            this.getOut().println("    " + methods.size() + " method(s)");
            this.getOut().println("    " + innerClasses.size() + " inner class(es)");
        }
    }

    private void printCFMIC(String label, Collection<Classfile> classes, Collection<Field_info> fields, Collection<Method_info> methods, Collection<InnerClass> innerClasses) throws IOException {
        this.getOut().println(classes.size() + fields.size() + methods.size() + innerClasses.size() + label);
        if (this.list) {
            this.getOut().println("    " + classes.size() + " class(es)");
            for (Classfile aClass : classes) {
                this.getOut().println("        " + aClass);
            }
            this.getOut().println("    " + fields.size() + " field(s)");
            for (Field_info field : fields) {
                this.getOut().println("        " + field);
            }
            this.getOut().println("    " + methods.size() + " method(s)");
            for (Method_info method : methods) {
                this.getOut().println("        " + method);
            }
            this.getOut().println("    " + innerClasses.size() + " inner class(es)");
            for (InnerClass innerClass : innerClasses) {
                this.getOut().println("        " + innerClass);
            }
        } else {
            this.getOut().println("    " + classes.size() + " class(es)");
            this.getOut().println("    " + fields.size() + " fields(s)");
            this.getOut().println("    " + methods.size() + " method(s)");
            this.getOut().println("    " + innerClasses.size() + " inner class(es)");
        }
    }

    private void printCFM(String label, Collection<Classfile> classes, Collection<Field_info> fields, Collection<Method_info> methods) throws IOException {
        this.getOut().println(classes.size() + fields.size() + methods.size() + label);
        if (this.list) {
            this.getOut().println("    " + classes.size() + " class(es)");
            for (Classfile aClass : classes) {
                this.getOut().println("        " + aClass);
            }
            this.getOut().println("    " + fields.size() + " field(s)");
            for (Field_info field : fields) {
                this.getOut().println("        " + field);
            }
            this.getOut().println("    " + methods.size() + " method(s)");
            for (Method_info method : methods) {
                this.getOut().println("        " + method);
            }
        } else {
            this.getOut().println("    " + classes.size() + " class(es)");
            this.getOut().println("    " + fields.size() + " fields(s)");
            this.getOut().println("    " + methods.size() + " method(s)");
        }
    }

    private void printFMIC(String label, Collection<Field_info> fields, Collection<Method_info> methods, Collection<InnerClass> innerClasses) throws IOException {
        this.getOut().println(fields.size() + methods.size() + innerClasses.size() + label);
        if (this.list) {
            this.getOut().println("    " + fields.size() + " field(s)");
            for (Field_info field : fields) {
                this.getOut().println("        " + field);
            }
            this.getOut().println("    " + methods.size() + " method(s)");
            for (Method_info method : methods) {
                this.getOut().println("        " + method);
            }
            this.getOut().println("    " + innerClasses.size() + " inner class(es)");
            for (InnerClass innerClass : innerClasses) {
                this.getOut().println("        " + innerClass);
            }
        } else {
            this.getOut().println("    " + fields.size() + " fields(s)");
            this.getOut().println("    " + methods.size() + " method(s)");
            this.getOut().println("    " + innerClasses.size() + " inner class(es)");
        }
    }

    public static void main(String[] args) throws Exception {
        new ClassMetrics().run(args);
    }
}

