/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.dependencyfinder.gui;

import com.jeantessier.classreader.ClassfileLoader;
import com.jeantessier.classreader.ClassfileScanner;
import com.jeantessier.classreader.TransientClassfileLoader;
import com.jeantessier.dependency.LinkMaximizer;
import com.jeantessier.dependency.LinkMinimizer;
import com.jeantessier.dependencyfinder.gui.DependencyFinder;
import com.jeantessier.dependencyfinder.gui.VerboseListener;
import java.awt.event.ActionEvent;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;

public class RefreshDependencyGraphAction
extends AbstractAction
implements Runnable {
    private DependencyFinder model = null;

    public RefreshDependencyGraphAction(DependencyFinder model) {
        this.model = model;
        this.putValue("LongDescription", "Re-extract the current dependency graph");
        this.putValue("Name", "Refresh");
        this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("icons/refresh.gif")));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        new Thread(this).start();
    }

    @Override
    public void run() {
        Date start = new Date();
        this.model.clearDependencyResult();
        this.model.clearClosureResult();
        this.model.clearMetricsResult();
        this.model.getStatusLine().showInfo("Scanning ...");
        ClassfileScanner scanner = new ClassfileScanner();
        scanner.load(this.model.getInputFiles());
        this.model.getProgressBar().setMaximum(scanner.getNbFiles());
        this.model.getMonitor().setClosedSession(true);
        TransientClassfileLoader loader = new TransientClassfileLoader(this.model.getClassfileLoaderDispatcher());
        ((ClassfileLoader)loader).addLoadListener(new VerboseListener(this.model.getStatusLine(), this.model.getProgressBar()));
        ((ClassfileLoader)loader).addLoadListener(this.model.getMonitor());
        loader.load(this.model.getInputFiles());
        if (this.model.getMaximize()) {
            this.model.getStatusLine().showInfo("Maximizing ...");
            new LinkMaximizer().traverseNodes(this.model.getPackages());
        } else if (this.model.getMinimize()) {
            this.model.getStatusLine().showInfo("Minimizing ...");
            new LinkMinimizer().traverseNodes(this.model.getPackages());
        }
        Date stop = new Date();
        this.model.getStatusLine().showInfo("Done (" + (double)(stop.getTime() - start.getTime()) / 1000.0 + " secs).");
    }
}

