/*
 * Decompiled with CFR 0.152.
 */
package com.jeantessier.diff;

import com.jeantessier.diff.Differences;
import com.jeantessier.diff.RemovableDifferences;
import com.jeantessier.diff.Visitor;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import org.apache.log4j.Logger;

public class PackageDifferences
extends RemovableDifferences {
    private Collection<Differences> classDifferences = new LinkedList<Differences>();
    private String oldDeclaration = null;
    private String newDeclaration = null;

    PackageDifferences(String name, Map oldPackage, Map newPackage) {
        super(name);
        if (oldPackage != null && !oldPackage.isEmpty()) {
            this.oldDeclaration = name;
        }
        if (newPackage != null && !newPackage.isEmpty()) {
            this.newDeclaration = name;
        }
        if (this.isModified()) {
            Logger.getLogger(this.getClass()).debug((Object)(this.getName() + " declaration has been modified."));
        } else {
            Logger.getLogger(this.getClass()).debug((Object)(this.getName() + " declaration has not been modified."));
        }
    }

    public Collection<Differences> getClassDifferences() {
        return this.classDifferences;
    }

    @Override
    public String getOldDeclaration() {
        return this.oldDeclaration;
    }

    @Override
    public String getNewDeclaration() {
        return this.newDeclaration;
    }

    @Override
    public boolean isModified() {
        return super.isModified() || this.getClassDifferences().size() != 0;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitPackageDifferences(this);
    }
}

