/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.dragndrop;

import de.lessvoid.nifty.EndNotify;
import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.NiftyEvent;
import de.lessvoid.nifty.controls.AbstractController;
import de.lessvoid.nifty.controls.Droppable;
import de.lessvoid.nifty.controls.DroppableDropFilter;
import de.lessvoid.nifty.controls.DroppableDroppedEvent;
import de.lessvoid.nifty.controls.NiftyInputControl;
import de.lessvoid.nifty.controls.dragndrop.DraggableControl;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.input.NiftyInputEvent;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.tools.SizeValue;
import de.lessvoid.xml.xpp3.Attributes;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;

public class DroppableControl
extends AbstractController
implements Droppable {
    private Nifty nifty;
    private List<DroppableDropFilter> filters = new CopyOnWriteArrayList<DroppableDropFilter>();
    private Element droppableContent;
    private DraggableControl draggable;

    public void bind(Nifty nifty, Screen screen, Element element, Properties parameter, Attributes controlDefinitionAttributes) {
        super.bind(element);
        this.nifty = nifty;
        this.droppableContent = element.findElementByName("#droppableContent");
    }

    public void onStartScreen() {
        this.draggable = this.findDraggableChild(this.droppableContent);
        if (this.draggable != null) {
            this.drop(this.draggable, this.reactivate(this.draggable.getElement()), false);
        }
    }

    public boolean inputEvent(NiftyInputEvent inputEvent) {
        return false;
    }

    private EndNotify reactivate(final Element element) {
        return new EndNotify(){

            public void perform() {
                element.reactivate();
            }
        };
    }

    private DraggableControl findDraggableChild(Element element) {
        for (Element child : element.getElements()) {
            if (this.isDraggable(child)) {
                return (DraggableControl)child.getControl(DraggableControl.class);
            }
            DraggableControl draggable = this.findDraggableChild(child);
            if (draggable == null) continue;
            return draggable;
        }
        return null;
    }

    private boolean isDraggable(Element element) {
        NiftyInputControl control = element.getAttachedInputControl();
        if (control != null) {
            return control.getController() instanceof DraggableControl;
        }
        return false;
    }

    protected void drop(DraggableControl droppedDraggable, EndNotify endNotify) {
        this.drop(droppedDraggable, endNotify, true);
    }

    private void drop(DraggableControl droppedDraggable, EndNotify endNotify, boolean notifyObservers) {
        this.draggable = droppedDraggable;
        this.draggable.getElement().setConstraintX(new SizeValue("0px"));
        this.draggable.getElement().setConstraintY(new SizeValue("0px"));
        this.draggable.getElement().markForMove(this.droppableContent, endNotify);
        DroppableControl source = droppedDraggable.getDroppable();
        droppedDraggable.setDroppable(this);
        if (notifyObservers) {
            this.notifyObservers(source, droppedDraggable);
        }
    }

    public DraggableControl getDraggable() {
        return this.draggable;
    }

    private void notifyObservers(DroppableControl source, DraggableControl droppedDraggable) {
        this.nifty.publishEvent(this.getElement().getId(), (NiftyEvent)new DroppableDroppedEvent(source, droppedDraggable, this));
    }

    @Override
    public void addFilter(DroppableDropFilter filter) {
        this.filters.add(filter);
    }

    @Override
    public void removeFilter(DroppableDropFilter filter) {
        this.filters.remove(filter);
    }

    @Override
    public void removeAllFilters() {
        this.filters.clear();
    }

    protected boolean accept(DroppableControl source, DraggableControl draggable) {
        for (DroppableDropFilter filter : this.filters) {
            if (filter.accept(source, draggable, this)) continue;
            return false;
        }
        return true;
    }
}

