/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.controls.imageselect;

import de.lessvoid.nifty.EndNotify;
import de.lessvoid.nifty.Nifty;
import de.lessvoid.nifty.NiftyEvent;
import de.lessvoid.nifty.controls.AbstractController;
import de.lessvoid.nifty.controls.ImageSelect;
import de.lessvoid.nifty.controls.ImageSelectSelectionChangedEvent;
import de.lessvoid.nifty.controls.NextPrevHelper;
import de.lessvoid.nifty.effects.Effect;
import de.lessvoid.nifty.effects.EffectEventId;
import de.lessvoid.nifty.effects.impl.Move;
import de.lessvoid.nifty.elements.Element;
import de.lessvoid.nifty.elements.render.ImageRenderer;
import de.lessvoid.nifty.input.NiftyInputEvent;
import de.lessvoid.nifty.render.NiftyImage;
import de.lessvoid.nifty.render.NiftyRenderEngine;
import de.lessvoid.nifty.screen.Screen;
import de.lessvoid.nifty.tools.SizeValue;
import de.lessvoid.xml.xpp3.Attributes;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

@Deprecated
public class ImageSelectControl
extends AbstractController
implements ImageSelect {
    private Nifty nifty;
    private ArrayList<NiftyImage> images;
    private int currentImageIndex;
    private int imageWidth;
    private NextPrevHelper nextPrevHelper;
    private Element backButtonElement;
    private Element forwardButtonElement;
    private Element imageElement;
    private Element imageElement2;
    private Element backElement;
    private Element forwardElement;
    private boolean block = false;

    public void bind(Nifty niftyParam, Screen screenParam, Element newElement, Properties properties, Attributes controlDefinitionAttributes) {
        super.bind(newElement);
        this.nifty = niftyParam;
        this.images = this.createImages(this.nifty.getRenderEngine(), properties.getProperty("imageList"));
        this.currentImageIndex = 0;
        this.imageWidth = new SizeValue(properties.getProperty("imageWidth", "0px")).getValueAsInt(1.0f);
        this.nextPrevHelper = new NextPrevHelper(this.getElement(), screenParam.getFocusHandler());
        this.backButtonElement = this.getElement().findElementByName("#back-button");
        this.forwardButtonElement = this.getElement().findElementByName("#forward-button");
        this.imageElement = this.getElement().findElementByName("#image");
        this.imageElement2 = this.getElement().findElementByName("#image-2");
        this.backElement = this.getElement().findElementByName("#back");
        this.forwardElement = this.getElement().findElementByName("#forward");
        List moveEffects = this.imageElement.getEffects(EffectEventId.onCustom, Move.class);
        for (Effect e : moveEffects) {
            if ("back".equals(e.getCustomKey())) {
                e.getParameters().put((Object)"offsetX", (Object)String.valueOf(-this.imageWidth - 1));
                continue;
            }
            if (!"forward".equals(e.getCustomKey())) continue;
            e.getParameters().put((Object)"offsetX", (Object)String.valueOf(this.imageWidth + 1));
        }
        moveEffects = this.imageElement2.getEffects(EffectEventId.onCustom, Move.class);
        for (Effect e : moveEffects) {
            if ("back".equals(e.getCustomKey())) {
                e.getParameters().put((Object)"offsetX", (Object)String.valueOf(this.imageWidth));
                continue;
            }
            if (!"forward".equals(e.getCustomKey())) continue;
            e.getParameters().put((Object)"offsetX", (Object)String.valueOf(-this.imageWidth));
        }
        this.updateVisuals();
    }

    public void onStartScreen() {
    }

    public boolean inputEvent(NiftyInputEvent inputEvent) {
        if (NiftyInputEvent.MoveCursorLeft == inputEvent) {
            this.backClick();
        } else if (NiftyInputEvent.MoveCursorRight == inputEvent) {
            this.forwardClick();
        } else {
            if (this.nextPrevHelper.handleNextPrev(inputEvent)) {
                return true;
            }
            if (inputEvent == NiftyInputEvent.Activate) {
                this.getElement().onClick();
                return true;
            }
        }
        return false;
    }

    public void onFocus(boolean getFocus) {
        if (getFocus) {
            this.backButtonElement.startEffect(EffectEventId.onCustom);
            this.forwardButtonElement.startEffect(EffectEventId.onCustom);
        } else {
            this.backButtonElement.stopEffect(EffectEventId.onCustom);
            this.forwardButtonElement.stopEffect(EffectEventId.onCustom);
        }
        super.onFocus(getFocus);
    }

    @Override
    public void backClick() {
        if (this.block) {
            return;
        }
        if (this.currentImageIndex > 0) {
            this.block = true;
            ((ImageRenderer)this.imageElement2.getRenderer(ImageRenderer.class)).setImage(((ImageRenderer)this.imageElement.getRenderer(ImageRenderer.class)).getImage());
            this.imageElement2.setConstraintWidth(new SizeValue(this.imageElement.getWidth() + "px"));
            this.imageElement2.setConstraintHeight(new SizeValue(this.imageElement.getHeight() + "px"));
            this.imageElement2.layoutElements();
            this.imageElement2.show();
            this.imageElement.hide();
            --this.currentImageIndex;
            this.imageIndexChanged();
            this.updateVisuals();
            this.imageElement.stopEffect(EffectEventId.onCustom);
            this.imageElement.startEffect(EffectEventId.onCustom, new EndNotify(){

                public void perform() {
                    ImageSelectControl.this.block = false;
                }
            }, "back");
            this.imageElement.show();
            this.imageElement2.stopEffect(EffectEventId.onCustom);
            this.imageElement2.startEffect(EffectEventId.onCustom, new EndNotify(){

                public void perform() {
                    ImageSelectControl.this.imageElement2.hide();
                }
            }, "back");
        }
    }

    @Override
    public void forwardClick() {
        if (this.block) {
            return;
        }
        if (this.currentImageIndex < this.images.size() - 1) {
            this.block = true;
            ((ImageRenderer)this.imageElement2.getRenderer(ImageRenderer.class)).setImage(((ImageRenderer)this.imageElement.getRenderer(ImageRenderer.class)).getImage());
            this.imageElement2.setConstraintWidth(new SizeValue(this.imageElement.getWidth() + "px"));
            this.imageElement2.setConstraintHeight(new SizeValue(this.imageElement.getHeight() + "px"));
            this.imageElement2.layoutElements();
            this.imageElement2.show();
            this.imageElement.hide();
            ++this.currentImageIndex;
            this.imageIndexChanged();
            this.updateVisuals();
            this.imageElement.stopEffect(EffectEventId.onCustom);
            this.imageElement.startEffect(EffectEventId.onCustom, new EndNotify(){

                public void perform() {
                    ImageSelectControl.this.block = false;
                }
            }, "forward");
            this.imageElement.show();
            this.imageElement2.stopEffect(EffectEventId.onCustom);
            this.imageElement2.startEffect(EffectEventId.onCustom, new EndNotify(){

                public void perform() {
                    ImageSelectControl.this.imageElement2.hide();
                }
            }, "forward");
        }
    }

    @Override
    public void addImage(NiftyImage image) {
        this.images.add(image);
        this.updateVisuals();
    }

    @Override
    public int getSelectedImageIndex() {
        return this.currentImageIndex;
    }

    @Override
    public void setSelectedImageIndex(int imageIndex) {
        if (imageIndex < 0 || imageIndex > this.images.size()) {
            return;
        }
        this.currentImageIndex = imageIndex;
        this.updateVisuals();
        this.imageIndexChanged();
    }

    @Override
    public void removeImage(NiftyImage image) {
        this.images.remove(image);
        this.updateVisuals();
    }

    @Override
    public int getImageCount() {
        return this.images.size();
    }

    private void updateVisuals() {
        if (this.images.isEmpty()) {
            return;
        }
        NiftyImage currentImage = this.images.get(this.currentImageIndex);
        ((ImageRenderer)this.imageElement.getRenderer(ImageRenderer.class)).setImage(currentImage);
        this.imageElement.setConstraintWidth(new SizeValue(currentImage.getWidth() + "px"));
        this.imageElement.setConstraintHeight(new SizeValue(currentImage.getHeight() + "px"));
        this.imageElement.layoutElements();
        if (this.currentImageIndex == 0) {
            this.backElement.hide();
            this.backButtonElement.disable();
        } else {
            this.backElement.show();
            this.backButtonElement.enable();
        }
        if (this.currentImageIndex == this.images.size() - 1) {
            this.forwardElement.hide();
            this.forwardButtonElement.disable();
        } else {
            this.forwardElement.show();
            this.forwardButtonElement.enable();
        }
    }

    private ArrayList<NiftyImage> createImages(NiftyRenderEngine renderDevice, String param) {
        String property = this.nifty.specialValuesReplace(param);
        ArrayList<NiftyImage> imageList = new ArrayList<NiftyImage>();
        if (property != null && property.length() > 0) {
            String[] imageStrings;
            for (String imageString : imageStrings = property.split(",")) {
                imageList.add(renderDevice.createImage(this.nifty.getCurrentScreen(), imageString, false));
            }
        }
        return imageList;
    }

    private void imageIndexChanged() {
        this.nifty.publishEvent(this.getElement().getId(), (NiftyEvent)new ImageSelectSelectionChangedEvent(this, this.currentImageIndex));
    }
}

