/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.render.image.renderstrategy;

import de.lessvoid.nifty.layout.Box;
import de.lessvoid.nifty.render.image.renderstrategy.RenderStrategy;
import de.lessvoid.nifty.spi.render.RenderDevice;
import de.lessvoid.nifty.spi.render.RenderImage;
import de.lessvoid.nifty.tools.Color;
import java.util.logging.Logger;

public class NinePartResizeStrategy
implements RenderStrategy {
    private static Logger log = Logger.getLogger(NinePartResizeStrategy.class.getName());
    private static final int NINE_PART_RESIZE_ARGS_COUNT = 12;
    private NinePartResizeRow m_row0;
    private NinePartResizeRow m_row1;
    private NinePartResizeRow m_row2;
    private Box box = new Box();

    @Override
    public void setParameters(String parameters) {
        String[] args = this.getArguments(parameters);
        this.m_row0 = new NinePartResizeRow(args, 0);
        this.m_row1 = new NinePartResizeRow(args, 4);
        this.m_row2 = new NinePartResizeRow(args, 8);
    }

    private String[] getArguments(String parameters) {
        String[] args = null;
        if (parameters != null) {
            args = parameters.split(",");
        }
        if (args == null || args.length != 12) {
            int argCount = args == null ? 0 : args.length;
            throw new IllegalArgumentException("Trying to parse [" + this.getClass().getName() + "] : wrong parameter count (" + argCount + "). Expected [w1,w2,w3,h1,w4,w5,w6,h2,w7,w8,w9,h3], found [" + parameters + "].");
        }
        return args;
    }

    @Override
    public void render(RenderDevice device, RenderImage image, Box sourceArea, int x, int y, int width, int height, Color color, float scale) {
        int cX = x + width / 2;
        int cY = y + height / 2;
        int srcX = sourceArea.getX();
        int srcW = sourceArea.getWidth();
        if (this.m_row0.getWidth() > srcW || this.m_row1.getWidth() > srcW || this.m_row2.getWidth() > srcW) {
            log.warning("Defined nine-part resize strategy goes out of source area's bounds.");
        }
        int srcH0 = this.m_row0.getHeight();
        int srcH1 = this.m_row1.getHeight();
        int srcH2 = this.m_row2.getHeight();
        int srcY0 = sourceArea.getY();
        int srcY1 = srcY0 + srcH0;
        int srcY2 = srcY1 + srcH1;
        int midlH = height - srcH0 - srcH2;
        int y0 = y;
        int y1 = y0 + srcH0;
        int y2 = y1 + midlH;
        this.box.setX(srcX);
        this.box.setY(srcY0);
        this.box.setWidth(srcW);
        this.box.setHeight(srcH0);
        this.renderRow(device, image, this.m_row0, this.box, x, y0, width, srcH0, color, scale, cX, cY);
        this.box.setX(srcX);
        this.box.setY(srcY1);
        this.box.setWidth(srcW);
        this.box.setHeight(srcH1);
        this.renderRow(device, image, this.m_row1, this.box, x, y1, width, midlH, color, scale, cX, cY);
        this.box.setX(srcX);
        this.box.setY(srcY2);
        this.box.setWidth(srcW);
        this.box.setHeight(srcH2);
        this.renderRow(device, image, this.m_row2, this.box, x, y2, width, srcH2, color, scale, cX, cY);
    }

    private void renderRow(RenderDevice renderDevice, RenderImage image, NinePartResizeRow row, Box sourceArea, int x, int y, int width, int height, Color color, float scale, int centerX, int centerY) {
        int srcY = sourceArea.getY();
        int srcH = sourceArea.getHeight();
        int srcW0 = row.getLeftWidth();
        int srcW1 = row.getMiddleWidth();
        int srcW2 = row.getRightWidth();
        int srcX0 = sourceArea.getX();
        int srcX1 = srcX0 + srcW0;
        int srcX2 = srcX1 + srcW1;
        int midlW = width - srcW0 - srcW2;
        int x0 = x;
        int x1 = x0 + srcW0;
        int x2 = x1 + midlW;
        renderDevice.renderImage(image, x0, y, srcW0, height, srcX0, srcY, srcW0, srcH, color, scale, centerX, centerY);
        renderDevice.renderImage(image, x1, y, midlW, height, srcX1, srcY, srcW1, srcH, color, scale, centerX, centerY);
        renderDevice.renderImage(image, x2, y, srcW2, height, srcX2, srcY, srcW2, srcH, color, scale, centerX, centerY);
    }

    private static class NinePartResizeRow {
        private final int m_leftWidth;
        private final int m_middleWidth;
        private final int m_rightWidth;
        private final int m_height;

        public NinePartResizeRow(String[] data, int dataOffset) {
            this.m_leftWidth = Integer.valueOf(data[dataOffset]);
            this.m_middleWidth = Integer.valueOf(data[dataOffset + 1]);
            this.m_rightWidth = Integer.valueOf(data[dataOffset + 2]);
            this.m_height = Integer.valueOf(data[dataOffset + 3]);
        }

        public int getLeftWidth() {
            return this.m_leftWidth;
        }

        public int getMiddleWidth() {
            return this.m_middleWidth;
        }

        public int getRightWidth() {
            return this.m_rightWidth;
        }

        public int getWidth() {
            return this.m_leftWidth + this.m_middleWidth + this.m_rightWidth;
        }

        public int getHeight() {
            return this.m_height;
        }
    }
}

