/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.tools.resourceloader;

import de.lessvoid.nifty.tools.resourceloader.ClasspathLocation;
import de.lessvoid.nifty.tools.resourceloader.FileSystemLocation;
import de.lessvoid.nifty.tools.resourceloader.ResourceLocation;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;

public class NiftyResourceLoader {
    private ArrayList<ResourceLocation> locations = new ArrayList();

    public NiftyResourceLoader() {
        this.locations.add(new ClasspathLocation());
        this.locations.add(new FileSystemLocation(new File(".")));
    }

    public void addResourceLocation(ResourceLocation location) {
        this.locations.add(location);
    }

    public void removeResourceLocation(ResourceLocation location) {
        this.locations.remove(location);
    }

    public void removeAllResourceLocations() {
        this.locations.clear();
    }

    public InputStream getResourceAsStream(String ref) {
        ResourceLocation location;
        InputStream in = null;
        for (int i = 0; i < this.locations.size() && (in = (location = this.locations.get(i)).getResourceAsStream(ref)) == null; ++i) {
        }
        if (in == null) {
            throw new RuntimeException("Resource not found: " + ref);
        }
        return new BufferedInputStream(in);
    }

    public URL getResource(String ref) {
        ResourceLocation location;
        URL url = null;
        for (int i = 0; i < this.locations.size() && (url = (location = this.locations.get(i)).getResource(ref)) == null; ++i) {
        }
        if (url == null) {
            throw new RuntimeException("Resource not found: " + ref);
        }
        return url;
    }
}

