/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.jkate;

import com.fluendo.jkate.Bitwise;
import com.fluendo.jkate.Event;
import com.fluendo.jkate.Info;
import com.fluendo.jkate.KateException;
import com.fluendo.jkate.KateMarkupType;
import com.fluendo.jkate.KateTextDirectionality;
import com.fluendo.jkate.KateTextEncoding;
import com.fluendo.jkate.Motion;
import com.jcraft.jogg.Buffer;

public final class Decode {
    Buffer opb = new Buffer();
    Info info;

    public Decode(Info i) {
        this.info = i;
    }

    int decodeTextPacket(Event ev) {
        int idx;
        ev.ki = this.info;
        ev.start = Bitwise.read64(this.opb);
        ev.duration = Bitwise.read64(this.opb);
        ev.backlink = Bitwise.read64(this.opb);
        ev.start_time = this.granuleDuration(ev.start);
        ev.end_time = ev.start_time + this.granuleDuration(ev.duration);
        int len = Bitwise.read32(this.opb);
        ev.text = new byte[len];
        Bitwise.readbuf(this.opb, ev.text, len);
        ev.id = -1;
        if (this.opb.read1() != 0) {
            ev.id = Bitwise.read32v(this.opb);
        }
        ev.motions = null;
        if (this.opb.read1() != 0) {
            int nmotions = Bitwise.read32v(this.opb);
            if (nmotions < 0) {
                return -1;
            }
            ev.motions = new Motion[nmotions];
            for (int n = 0; n < nmotions; ++n) {
                if (this.opb.read1() != 0) {
                    int idx2 = Bitwise.read32v(this.opb);
                    if (idx2 < 0 || idx2 >= this.info.motions.length) {
                        return -1;
                    }
                    ev.motions[n] = this.info.motions[idx2];
                    continue;
                }
                try {
                    ev.motions[n] = this.info.unpackMotion(this.opb);
                    continue;
                }
                catch (KateException ke) {
                    return -6;
                }
            }
        }
        if (this.opb.read1() != 0) {
            try {
                if (this.opb.read1() != 0) {
                    ev.text_encoding = KateTextEncoding.CreateTextEncoding(this.opb.read(8));
                }
                if (this.opb.read1() != 0) {
                    ev.text_directionality = KateTextDirectionality.CreateTextDirectionality(this.opb.read(8));
                }
            }
            catch (KateException ke) {
                return -6;
            }
            if (this.opb.read1() != 0) {
                int nbytes = Bitwise.read32v(this.opb);
                if (nbytes < 0) {
                    return -6;
                }
                if (nbytes > 0) {
                    ev.language = new byte[nbytes];
                    Bitwise.readbuf(this.opb, ev.language, nbytes);
                }
            }
            if (this.opb.read1() != 0) {
                idx = Bitwise.read32v(this.opb);
                if (idx < 0 || idx >= this.info.regions.length) {
                    return -6;
                }
                ev.kr = this.info.regions[idx];
            }
            if (this.opb.read1() != 0) {
                try {
                    ev.kr = this.info.unpackRegion(this.opb);
                }
                catch (KateException ke) {
                    return -6;
                }
            }
            if (this.opb.read1() != 0) {
                idx = Bitwise.read32v(this.opb);
                if (idx < 0 || idx >= this.info.styles.length) {
                    return -6;
                }
                ev.ks = this.info.styles[idx];
            }
            if (this.opb.read1() != 0) {
                try {
                    ev.ks = this.info.unpackStyle(this.opb);
                }
                catch (KateException ke) {
                    return -6;
                }
            }
            if (this.opb.read1() != 0) {
                idx = Bitwise.read32v(this.opb);
                if (idx < 0 || idx >= this.info.styles.length) {
                    return -6;
                }
                ev.ks2 = this.info.styles[idx];
            }
            if (this.opb.read1() != 0) {
                try {
                    ev.ks2 = this.info.unpackStyle(this.opb);
                }
                catch (KateException ke) {
                    return -6;
                }
            }
            if (this.opb.read1() != 0) {
                idx = Bitwise.read32v(this.opb);
                if (idx < 0 || idx >= this.info.font_mappings.length) {
                    return -6;
                }
                ev.font_mapping = this.info.font_mappings[idx];
            }
        }
        if ((this.info.bitstream_version_major << 8 | this.info.bitstream_version_minor) >= 2) {
            Bitwise.read32v(this.opb);
            if (this.opb.read1() != 0) {
                if (this.opb.read1() != 0) {
                    idx = Bitwise.read32v(this.opb);
                    if (idx < 0 || idx >= this.info.palettes.length) {
                        return -6;
                    }
                    ev.palette = this.info.palettes[idx];
                }
                if (this.opb.read1() != 0) {
                    try {
                        ev.palette = this.info.unpackPalette(this.opb);
                    }
                    catch (KateException e) {
                        return -6;
                    }
                }
                if (this.opb.read1() != 0) {
                    idx = Bitwise.read32v(this.opb);
                    if (idx < 0 || idx >= this.info.bitmaps.length) {
                        return -6;
                    }
                    ev.bitmap = this.info.bitmaps[idx];
                }
                if (this.opb.read1() != 0) {
                    try {
                        ev.bitmap = this.info.unpackBitmap(this.opb);
                    }
                    catch (KateException e) {
                        return -6;
                    }
                }
                if (this.opb.read1() != 0) {
                    try {
                        ev.markup_type = KateMarkupType.CreateMarkupType(this.opb.read(8));
                    }
                    catch (KateException e) {
                        return -6;
                    }
                }
            }
        }
        return 0;
    }

    public double granuleTime(long granulepos) {
        if (granulepos >= 0L) {
            long base = granulepos >> this.info.granule_shift;
            long offset = granulepos - (base << this.info.granule_shift);
            return (double)(base + offset) * ((double)this.info.gps_denominator / (double)this.info.gps_numerator);
        }
        return -1.0;
    }

    public double granuleDuration(long granule) {
        if (granule >= 0L) {
            return (double)granule * ((double)this.info.gps_denominator / (double)this.info.gps_numerator);
        }
        return -1.0;
    }
}

