/*
 * Decompiled with CFR 0.152.
 */
package de.lessvoid.nifty.render;

import de.lessvoid.nifty.NiftyStopwatch;
import de.lessvoid.nifty.spi.render.RenderDevice;
import de.lessvoid.nifty.spi.render.RenderImage;
import java.util.Hashtable;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Logger;

public class NiftyImageManager {
    private Logger log = Logger.getLogger("NiftyImageManager");
    private RenderDevice renderDevice;
    private Map<String, ReferencedCountedImage> imageCache = new Hashtable<String, ReferencedCountedImage>();
    private Map<RenderImage, ReferencedCountedImage> backReference = new Hashtable<RenderImage, ReferencedCountedImage>();

    public NiftyImageManager(RenderDevice renderDevice) {
        this.renderDevice = renderDevice;
    }

    public RenderImage getImage(String filename, boolean filterLinear) {
        String key = this.buildName(filename, filterLinear);
        if (this.imageCache.containsKey(key)) {
            RenderImage existingEntry = this.imageCache.get(key).addReference();
            this.log.finer(key + " exists [" + this.imageCache.get(key).references + "]");
            return existingEntry;
        }
        NiftyStopwatch.start();
        RenderImage createImage = this.renderDevice.createImage(filename, filterLinear);
        ReferencedCountedImage newEntry = new ReferencedCountedImage(filename, filterLinear, createImage);
        this.backReference.put(createImage, newEntry);
        this.imageCache.put(key, newEntry);
        this.log.finer(key + " create [" + this.imageCache.get(key).references + "]");
        NiftyStopwatch.stop("imageManager.getImage(" + filename + ")");
        return newEntry.getRenderImage();
    }

    public RenderImage reload(RenderImage image) {
        if (this.backReference.containsKey(image)) {
            return this.backReference.get(image).reload();
        }
        return image;
    }

    public void dispose(RenderImage image) {
        if (this.backReference.containsKey(image)) {
            ReferencedCountedImage reference = this.backReference.get(image);
            if (reference.removeReference()) {
                this.imageCache.remove(reference.getName());
                this.backReference.remove(image);
            }
            this.log.finer(reference.getName() + " remove [" + reference.getReferences() + "]");
        }
    }

    public String getInfoString() {
        StringBuffer result = new StringBuffer();
        result.append("I have " + this.imageCache.size() + " entries in cache and " + this.backReference.size() + " backreference entries.\n");
        TreeSet<String> values = new TreeSet<String>();
        for (Map.Entry<String, ReferencedCountedImage> entry : this.imageCache.entrySet()) {
            values.add(entry.getKey() + " -> " + entry.getValue().getReferences() + "\n");
        }
        for (String s : values) {
            result.append(s);
        }
        return result.toString();
    }

    private String buildName(String filename, boolean filterLinear) {
        return filename + "|" + filterLinear;
    }

    private class ReferencedCountedImage {
        private String filename;
        private boolean filterLinear;
        private String key;
        private RenderImage renderImage;
        private int references;

        public ReferencedCountedImage(String filename, boolean filterLinear, RenderImage renderImage) {
            this.filename = filename;
            this.filterLinear = filterLinear;
            this.key = NiftyImageManager.this.buildName(filename, filterLinear);
            this.renderImage = renderImage;
            this.references = 1;
        }

        public RenderImage reload() {
            this.renderImage.dispose();
            this.renderImage = NiftyImageManager.this.renderDevice.createImage(this.filename, this.filterLinear);
            return this.renderImage;
        }

        public RenderImage addReference() {
            ++this.references;
            return this.renderImage;
        }

        public boolean removeReference() {
            --this.references;
            if (this.references == 0) {
                NiftyImageManager.this.log.finer(this.key + " DISPOSE");
                this.renderImage.dispose();
                return true;
            }
            return false;
        }

        public int getReferences() {
            return this.references;
        }

        public RenderImage getRenderImage() {
            return this.renderImage;
        }

        public String getName() {
            return this.key;
        }
    }
}

