/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.Arrays;
import java.util.HashSet;
import org.lwjgl.DisplayMode;
import org.lwjgl.Sys;

public final class Display {
    private static boolean created;
    private static DisplayMode mode;
    private static int handle;
    private static boolean closeRequested;
    public static final int PLATFORM_WGL = 0;
    public static final int PLATFORM_GLX = 1;
    public static final int PLATFORM_AGL = 2;
    static final /* synthetic */ boolean $assertionsDisabled;

    private Display() {
    }

    private static native void init();

    public static DisplayMode[] getAvailableDisplayModes() {
        DisplayMode[] displayModeArray = Display.nGetAvailableDisplayModes();
        if (displayModeArray == null) {
            return new DisplayMode[0];
        }
        HashSet<DisplayMode> hashSet = new HashSet<DisplayMode>(displayModeArray.length);
        hashSet.addAll(Arrays.asList(displayModeArray));
        DisplayMode[] displayModeArray2 = new DisplayMode[hashSet.size()];
        hashSet.toArray(displayModeArray2);
        if (Sys.DEBUG) {
            System.out.println("Removed " + (displayModeArray.length - displayModeArray2.length) + " duplicate displaymodes");
        }
        return displayModeArray2;
    }

    private static native DisplayMode[] nGetAvailableDisplayModes();

    public static native void setDisplayMode(DisplayMode var0) throws Exception;

    public static native void resetDisplayMode();

    public static int getWidth() {
        return Display.mode.width;
    }

    public static int getHeight() {
        return Display.mode.height;
    }

    public static int getDepth() {
        return Display.mode.bpp;
    }

    public static int getFrequency() {
        return Display.mode.freq;
    }

    public static int getHandle() {
        if (!$assertionsDisabled && !created) {
            throw new AssertionError((Object)"The display has not been created yet.");
        }
        return handle;
    }

    public static native int getPlatform();

    public static void setDisplayConfiguration(float f, float f2, float f3) throws Exception {
        if (!($assertionsDisabled || f2 >= -1.0f && f2 <= 1.0f)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !(f3 >= 0.0f)) {
            throw new AssertionError();
        }
        int n = Display.getGammaRampLength();
        if (n == 0) {
            throw new Exception("Display configuration not supported");
        }
        FloatBuffer floatBuffer = ByteBuffer.allocateDirect(n * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        for (int i = 0; i < n; ++i) {
            float f4 = (float)i / (float)(n - 1);
            float f5 = (float)Math.pow(f4, f);
            f5 += f2;
            if ((f5 = (f5 - 0.5f) * f3 + 0.5f) > 1.0f) {
                f5 = 1.0f;
            } else if (f5 < 0.0f) {
                f5 = 0.0f;
            }
            floatBuffer.put(i, f5);
        }
        Display.setGammaRamp(floatBuffer);
        if (Sys.DEBUG) {
            System.out.println("Gamma set, gamma = " + f + ", brightness = " + f2 + ", contrast = " + f3);
        }
    }

    private static native int getGammaRampLength();

    private static native void setGammaRamp(FloatBuffer var0) throws Exception;

    public static native String getAdapter();

    public static native String getVersion();

    static {
        $assertionsDisabled = !Display.class.desiredAssertionStatus();
        closeRequested = false;
        System.loadLibrary(Sys.getLibraryName());
        Display.init();
        if (Sys.DEBUG) {
            System.out.println("Adapter: " + Display.getAdapter() + " Version: " + Display.getVersion());
        }
    }
}

