/*
 * Decompiled with CFR 0.152.
 */
package jme.controller;

import java.awt.Point;
import java.util.logging.Level;
import jme.controller.AbstractGameController;
import jme.entity.camera.Camera;
import jme.exception.MonkeyRuntimeException;
import jme.math.Vector;
import jme.system.KeyBindingManager;
import jme.utility.LoggingSystem;
import org.lwjgl.Display;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class BaseFPSController
extends AbstractGameController {
    protected float accuracy = 0.0f;
    private float motionSpeed = 10.0f;
    private float rotationSpeed = 1.0f;
    private Point mousePosition;
    private Camera entity;
    protected KeyBindingManager key;

    public BaseFPSController(int n) {
        this.entity = new Camera(n);
        this.accuracy = 10.0f;
        this.mousePosition = new Point();
        try {
            Mouse.create();
            Keyboard.create();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            LoggingSystem.getLoggingSystem().getLogger().log(Level.WARNING, "Error creating Mouse and/or Keyboard");
        }
        this.setDefaultKeyBindings();
        LoggingSystem.getLoggingSystem().getLogger().log(Level.INFO, "Created game controller");
    }

    public BaseFPSController(Camera camera) {
        if (null == camera) {
            throw new MonkeyRuntimeException("Camera cannot be null");
        }
        this.entity = camera;
        this.accuracy = 10.0f;
        this.mousePosition = new Point();
        try {
            Mouse.create();
            Keyboard.create();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            LoggingSystem.getLoggingSystem().getLogger().log(Level.WARNING, "Error creating Mouse and/or Keyboard");
        }
        this.setMousePosition(Display.getWidth() >> 1, Display.getHeight() >> 1);
        this.setDefaultKeyBindings();
        LoggingSystem.getLoggingSystem().getLogger().log(Level.INFO, "Created game controller");
    }

    public void tiltView(int n) {
        if (0 == n) {
            return;
        }
        float f = 0.0f;
        f = (float)n / this.accuracy;
        Vector vector = this.entity.getView().subtract(this.entity.getPosition());
        Vector vector2 = vector.cross(this.entity.getUp());
        vector2 = vector2.normalize();
        this.rotate(f, vector2);
    }

    public void panView(float f) {
        if (0.0f == f) {
            return;
        }
        float f2 = 0.0f;
        f2 = f / this.accuracy;
        this.rotate(-f2, new Vector(0.0f, 1.0f, 0.0f));
    }

    public void raise(float f) {
        this.entity.getPosition().y += f;
        this.entity.getView().y += f;
    }

    public boolean update(float f) {
        this.entity.setMoved(false);
        Vector vector = this.entity.getView().subtract(this.entity.getPosition());
        Vector vector2 = vector.cross(this.entity.getUp());
        this.entity.setStrafe(vector2.normalize());
        this.pollMouse();
        int n = Display.getWidth() >> 1;
        int n2 = Display.getHeight() >> 1;
        int n3 = 0;
        int n4 = 0;
        this.mousePosition.x = this.getMousePositionX();
        this.mousePosition.y = this.getMousePositionY();
        this.setMousePosition(n, n2);
        n3 = n - this.mousePosition.x;
        n4 = n2 - this.mousePosition.y;
        this.tiltView(n4);
        this.panView(-n3);
        this.entity.updateFrustum();
        this.entity.update(f);
        Keyboard.poll();
        if (this.isKeyDown("forward")) {
            this.move(this.motionSpeed / f);
        }
        if (this.isKeyDown("backward")) {
            this.move(-this.motionSpeed / f);
        }
        if (this.isKeyDown("strafeLeft")) {
            this.strafe(-this.motionSpeed / f);
        }
        if (this.isKeyDown("strafeRight")) {
            this.strafe(this.motionSpeed / f);
        }
        if (this.isKeyDown("turnRight")) {
            this.panView(this.rotationSpeed / f);
        }
        if (this.isKeyDown("turnLeft")) {
            this.panView(-this.rotationSpeed / f);
        }
        if (this.isKeyDown("rise")) {
            this.raise(this.motionSpeed / f);
        }
        if (this.isKeyDown("lower")) {
            this.raise(-this.motionSpeed / f);
        }
        return this.checkAdditionalKeys();
    }

    public void render() {
        this.entity.render();
    }

    public void setAccuracy(float f) {
        this.accuracy = f;
    }

    public void setMovementSpeed(float f) {
        this.motionSpeed = f;
    }

    public Vector getEntityView() {
        return this.entity.getView();
    }

    public Vector getEntityUp() {
        return this.entity.getUp();
    }

    public void setEntityView(Vector vector) {
        this.entity.setView(vector);
    }

    public void setEntityUp(Vector vector) {
        this.entity.setUp(vector);
    }

    public void rotate(float f, Vector vector) {
        float f2 = vector.x;
        float f3 = vector.y;
        float f4 = vector.z;
        Vector vector2 = new Vector();
        Vector vector3 = this.entity.getView().subtract(this.entity.getPosition());
        float f5 = (float)Math.cos(f);
        float f6 = (float)Math.sin(f);
        vector2.x = (f5 + (1.0f - f5) * f2 * f2) * vector3.x;
        vector2.x += ((1.0f - f5) * f2 * f3 - f4 * f6) * vector3.y;
        vector2.x += ((1.0f - f5) * f2 * f4 + f3 * f6) * vector3.z;
        vector2.y = ((1.0f - f5) * f2 * f3 + f4 * f6) * vector3.x;
        vector2.y += (f5 + (1.0f - f5) * f3 * f3) * vector3.y;
        vector2.y += ((1.0f - f5) * f3 * f4 - f2 * f6) * vector3.z;
        vector2.z = ((1.0f - f5) * f2 * f4 - f3 * f6) * vector3.x;
        vector2.z += ((1.0f - f5) * f3 * f4 + f2 * f6) * vector3.y;
        vector2.z += (f5 + (1.0f - f5) * f4 * f4) * vector3.z;
        this.entity.setView(this.entity.getPosition().add(vector2));
    }

    public void move(float f) {
        Vector vector = this.entity.getView().subtract(this.entity.getPosition()).normalize();
        this.entity.getPosition().x += vector.x * f;
        this.entity.getView().x += vector.x * f;
        this.entity.getPosition().y += vector.y * f;
        this.entity.getView().y += vector.y * f;
        this.entity.getPosition().z += vector.z * f;
        this.entity.getView().z += vector.z * f;
        this.entity.setMoved(true);
    }

    public void strafe(float f) {
        this.entity.getPosition().x += this.entity.getStrafe().x * f;
        this.entity.getPosition().z += this.entity.getStrafe().z * f;
        this.entity.getView().x += this.entity.getStrafe().x * f;
        this.entity.getView().z += this.entity.getStrafe().z * f;
    }

    protected boolean checkAdditionalKeys() {
        return !this.isKeyDown("exit");
    }

    private void setDefaultKeyBindings() {
        this.key = KeyBindingManager.getKeyBindingManager();
        this.key.set("forward", 17);
        this.key.set("backward", 31);
        this.key.set("strafeLeft", 30);
        this.key.set("strafeRight", 32);
        this.key.set("turnLeft", 203);
        this.key.set("turnRight", 205);
        this.key.set("rise", 16);
        this.key.set("lower", 44);
        this.key.set("exit", 1);
    }
}

